/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.Graphs;
import com.google.common.graph.NetworkConnections;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class AbstractDirectedNetworkConnections<N, E>
implements NetworkConnections<N, E> {
    final Map<E, N> inEdgeMap;
    final Map<E, N> outEdgeMap;
    private int selfLoopCount;

    /*
     * WARNING - void declaration
     */
    AbstractDirectedNetworkConnections(Map<E, N> inEdgeMap, Map<E, N> outEdgeMap, int selfLoopCount) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.inEdgeMap = Preconditions.checkNotNull(inEdgeMap);
        this.outEdgeMap = Preconditions.checkNotNull(outEdgeMap);
        this.selfLoopCount = Graphs.checkNonNegative(selfLoopCount);
        Preconditions.checkState(selfLoopCount <= var1_1.size() && var3_3 <= var2_2.size());
    }

    @Override
    public Set<N> adjacentNodes() {
        return Sets.union(this.predecessors(), this.successors());
    }

    @Override
    public Set<E> incidentEdges() {
        return new AbstractSet<E>(this){
            final /* synthetic */ AbstractDirectedNetworkConnections this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                Iterable iterable = this.this$0.selfLoopCount == 0 ? Iterables.concat(this.this$0.inEdgeMap.keySet(), this.this$0.outEdgeMap.keySet()) : Sets.union(this.this$0.inEdgeMap.keySet(), this.this$0.outEdgeMap.keySet());
                return Iterators.unmodifiableIterator(iterable.iterator());
            }

            @Override
            public int size() {
                return IntMath.saturatedAdd(this.this$0.inEdgeMap.size(), this.this$0.outEdgeMap.size() - this.this$0.selfLoopCount);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                void var1_1;
                return this.this$0.inEdgeMap.containsKey(obj) || this.this$0.outEdgeMap.containsKey(var1_1);
            }
        };
    }

    @Override
    public Set<E> inEdges() {
        return Collections.unmodifiableSet(this.inEdgeMap.keySet());
    }

    @Override
    public Set<E> outEdges() {
        return Collections.unmodifiableSet(this.outEdgeMap.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public N adjacentNode(E edge) {
        void var1_1;
        return Objects.requireNonNull(this.outEdgeMap.get(var1_1));
    }

    @Override
    public N removeInEdge(E edge, boolean isSelfLoop) {
        N n;
        if (isSelfLoop) {
            Graphs.checkNonNegative(--this.selfLoopCount);
        }
        n = this.inEdgeMap.remove(n);
        return Objects.requireNonNull(n);
    }

    @Override
    public N removeOutEdge(E edge) {
        N n;
        n = this.outEdgeMap.remove(n);
        return Objects.requireNonNull(n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addInEdge(E edge, N node, boolean isSelfLoop) {
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(edge);
        Preconditions.checkNotNull(node);
        if (var3_3 != false) {
            Graphs.checkPositive(++this.selfLoopCount);
        }
        Preconditions.checkState((var1_1 = this.inEdgeMap.put(var1_1, var2_2)) == null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addOutEdge(E edge, N node) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(edge);
        Preconditions.checkNotNull(node);
        var1_1 = this.outEdgeMap.put(var1_1, var2_2);
        Preconditions.checkState(var1_1 == null);
    }
}

