/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.BaseGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.EndpointPairIterator;
import com.google.common.graph.IncidentEdgeSet;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.util.AbstractSet;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class AbstractBaseGraph<N>
implements BaseGraph<N> {
    AbstractBaseGraph() {
    }

    /*
     * WARNING - void declaration
     */
    protected long edgeCount() {
        void var1_1;
        long degreeSum = 0L;
        for (Object node : this.nodes()) {
            degreeSum += (long)this.degree(node);
        }
        Preconditions.checkState((degreeSum & 1L) == 0L);
        return (long)(var1_1 >>> 1);
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(this){
            final /* synthetic */ AbstractBaseGraph this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of(this.this$0);
            }

            @Override
            public int size() {
                return Ints.saturatedCast(this.this$0.edgeCount());
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                void var1_1;
                if (!(obj instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)obj;
                return this.this$0.isOrderingCompatible(endpointPair) && this.this$0.nodes().contains(endpointPair.nodeU()) && this.this$0.successors(endpointPair.nodeU()).contains(var1_1.nodeV());
            }
        };
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.unordered();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<EndpointPair<N>> incidentEdges(N node) {
        void var1_1;
        Preconditions.checkNotNull(node);
        Preconditions.checkArgument(this.nodes().contains(node), "Node %s is not an element of this graph.", node);
        AbstractBaseGraph abstractBaseGraph = this;
        return new IncidentEdgeSet<N>(abstractBaseGraph, abstractBaseGraph, var1_1){
            {
                void var3_3;
                void var2_2;
            }

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                if (this.graph.isDirected()) {
                    return Iterators.unmodifiableIterator(Iterators.concat(Iterators.transform(this.graph.predecessors(this.node).iterator(), predecessor -> EndpointPair.ordered(predecessor, this.node)), Iterators.transform(Sets.difference(this.graph.successors(this.node), ImmutableSet.of(this.node)).iterator(), successor -> {
                        void var1_1;
                        return EndpointPair.ordered(this.node, var1_1);
                    })));
                }
                return Iterators.unmodifiableIterator(Iterators.transform(this.graph.adjacentNodes(this.node).iterator(), adjacentNode -> {
                    void var1_1;
                    return EndpointPair.unordered(this.node, var1_1);
                }));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int degree(N node) {
        void var1_2;
        void var2_3;
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.predecessors((Object)node).size(), this.successors((Object)node).size());
        }
        Set<N> neighbors = this.adjacentNodes(node);
        boolean selfLoopCount = this.allowsSelfLoops() && neighbors.contains(node);
        return IntMath.saturatedAdd(var2_3.size(), (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int inDegree(N node) {
        void var1_1;
        if (this.isDirected()) {
            return this.predecessors((Object)node).size();
        }
        return this.degree(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int outDegree(N node) {
        void var1_1;
        if (this.isDirected()) {
            return this.successors((Object)node).size();
        }
        return this.degree(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(nodeU);
        Preconditions.checkNotNull(nodeV);
        return this.nodes().contains(nodeU) && this.successors((Object)var1_1).contains(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(endpoints);
        if (!this.isOrderingCompatible(endpoints)) {
            return false;
        }
        N nodeU = endpoints.nodeU();
        N nodeV = endpoints.nodeV();
        return this.nodes().contains(nodeU) && this.successors((Object)var2_2).contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final void validateEndpoints(EndpointPair<?> endpoints) {
        void var1_1;
        Preconditions.checkNotNull(endpoints);
        Preconditions.checkArgument(this.isOrderingCompatible((EndpointPair<?>)var1_1), "Mismatch: unordered endpoints cannot be used with directed graphs");
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpoints) {
        return endpoints.isOrdered() || !this.isDirected();
    }
}

