/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.Subscriber;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

@ElementTypesAreNonnullByDefault
final class SubscriberRegistry {
    private final ConcurrentMap<Class<?>, CopyOnWriteArraySet<Subscriber>> subscribers = Maps.newConcurrentMap();
    private final EventBus bus;
    private static final LoadingCache<Class<?>, ImmutableList<Method>> subscriberMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        @Override
        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return SubscriberRegistry.getAnnotatedMethodsNotCached(concreteClass);
        }
    });
    private static final LoadingCache<Class<?>, ImmutableSet<Class<?>>> flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableSet<Class<?>>>(){

        @Override
        public ImmutableSet<Class<?>> load(Class<?> concreteClass) {
            return ImmutableSet.copyOf(TypeToken.of(concreteClass).getTypes().rawTypes());
        }
    });

    /*
     * WARNING - void declaration
     */
    SubscriberRegistry(EventBus bus) {
        void var1_1;
        this.bus = (EventBus)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void register(Object listener) {
        Multimap<Class<?>, Subscriber> multimap;
        multimap = this.findAllSubscribers(multimap);
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            CopyOnWriteArraySet copyOnWriteArraySet;
            Class eventType = (Class)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (eventSubscribers == null) {
                void var3_4;
                CopyOnWriteArraySet newSet = new CopyOnWriteArraySet();
                copyOnWriteArraySet = MoreObjects.firstNonNull(this.subscribers.putIfAbsent((Class<?>)var3_4, newSet), newSet);
            }
            copyOnWriteArraySet.addAll(collection);
        }
    }

    final void unregister(Object listener) {
        Multimap<Class<?>, Subscriber> multimap = this.findAllSubscribers(listener);
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection collection = (Collection)entry.getValue();
            CopyOnWriteArraySet currentSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (currentSubscribers != null && currentSubscribers.removeAll(collection)) continue;
            listener = String.valueOf(listener);
            throw new IllegalArgumentException(new StringBuilder(65 + String.valueOf(listener).length()).append("missing event subscriber for an annotated method. Is ").append((String)listener).append(" registered?").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    final Set<Subscriber> getSubscribersForTesting(Class<?> eventType) {
        void var1_1;
        return MoreObjects.firstNonNull((AbstractCollection)this.subscribers.get(var1_1), ImmutableSet.of());
    }

    /*
     * WARNING - void declaration
     */
    final Iterator<Subscriber> getSubscribers(Object event) {
        void var2_2;
        Iterator iterator;
        ImmutableSet<Class<?>> eventTypes = SubscriberRegistry.flattenHierarchy(event.getClass());
        ArrayList subscriberIterators = Lists.newArrayListWithCapacity(eventTypes.size());
        iterator = ((ImmutableCollection)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Class eventType = (Class)iterator.next();
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (eventSubscribers == null) continue;
            subscriberIterators.add(var3_3.iterator());
        }
        return Iterators.concat(var2_2.iterator());
    }

    /*
     * WARNING - void declaration
     */
    private Multimap<Class<?>, Subscriber> findAllSubscribers(Object listener) {
        void var2_2;
        HashMultimap<Class<?>, Subscriber> methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        for (Method method : SubscriberRegistry.getAnnotatedMethods(clazz)) {
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> eventType = classArray[0];
            methodsInListener.put(eventType, Subscriber.create(this.bus, listener, method));
        }
        return var2_2;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        try {
            return subscriberMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            Serializable serializable;
            Serializable e = uncheckedExecutionException;
            Throwables.throwIfUnchecked(uncheckedExecutionException.getCause());
            throw serializable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<Method> getAnnotatedMethodsNotCached(Class<?> clazz) {
        void var1_1;
        Iterator iterator;
        Iterator supertypes = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap<MethodIdentifier, Method> identifiers = Maps.newHashMap();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Method[] methodArray = (Method[])iterator.next();
            for (Method method : methodArray.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class) || method.isSynthetic()) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                Preconditions.checkArgument(parameterTypes.length == 1, "Method %s has @Subscribe annotation but has %s parameters. Subscriber methods must have exactly 1 parameter.", (Object)method, parameterTypes.length);
                Preconditions.checkArgument(!parameterTypes[0].isPrimitive(), "@Subscribe method %s's parameter is %s. Subscriber methods cannot accept primitives. Consider changing the parameter to %s.", (Object)method, (Object)parameterTypes[0].getName(), (Object)Primitives.wrap(parameterTypes[0]).getSimpleName());
                MethodIdentifier ident = new MethodIdentifier(method);
                if (identifiers.containsKey(ident)) continue;
                identifiers.put(ident, method);
            }
        }
        return ImmutableList.copyOf(var1_1.values());
    }

    @VisibleForTesting
    static ImmutableSet<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        Serializable serializable;
        try {
            return flattenHierarchyCache.getUnchecked((Class<?>)serializable);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            serializable = uncheckedExecutionException;
            throw Throwables.propagate(uncheckedExecutionException.getCause());
        }
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        /*
         * WARNING - void declaration
         */
        MethodIdentifier(Method method) {
            void var1_1;
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(var1_1.getParameterTypes());
        }

        public final int hashCode() {
            return Objects.hashCode(this.name, this.parameterTypes);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            if (o instanceof MethodIdentifier) {
                void var1_1;
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals(ident.name) && this.parameterTypes.equals(var1_1.parameterTypes);
            }
            return false;
        }
    }
}

