/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
class Subscriber {
    private EventBus bus;
    @VisibleForTesting
    final Object target;
    private final Method method;
    private final Executor executor;

    /*
     * WARNING - void declaration
     */
    static Subscriber create(EventBus bus, Object listener, Method method) {
        void var2_2;
        void var1_1;
        EventBus eventBus;
        if (Subscriber.isDeclaredThreadSafe(method)) {
            return new Subscriber(bus, listener, method);
        }
        return new SynchronizedSubscriber(eventBus, var1_1, (Method)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Subscriber(EventBus bus, Object target, Method method) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.bus = bus;
        this.target = Preconditions.checkNotNull(var2_2);
        this.method = method;
        var3_3.setAccessible(true);
        this.executor = var1_1.executor();
    }

    /*
     * WARNING - void declaration
     */
    final void dispatchEvent(Object event) {
        void var1_1;
        this.executor.execute(() -> {
            try {
                this.invokeSubscriberMethod(var1_1);
                return;
            }
            catch (InvocationTargetException e) {
                void var1_1;
                void var2_2;
                this.bus.handleSubscriberException(var2_2.getCause(), this.context(var1_1));
                return;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    void invokeSubscriberMethod(Object event) throws InvocationTargetException {
        try {
            this.method.invoke(this.target, Preconditions.checkNotNull(event));
            return;
        }
        catch (IllegalArgumentException e) {
            event = String.valueOf(event);
            throw new Error(new StringBuilder(33 + String.valueOf(event).length()).append("Method rejected target/argument: ").append((String)event).toString(), e);
        }
        catch (IllegalAccessException e) {
            String string;
            string = String.valueOf(string);
            throw new Error(new StringBuilder(28 + String.valueOf(string).length()).append("Method became inaccessible: ").append(string).toString(), e);
        }
        catch (InvocationTargetException invocationTargetException) {
            void var2_4;
            InvocationTargetException e = invocationTargetException;
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw var2_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private SubscriberExceptionContext context(Object event) {
        void var1_1;
        return new SubscriberExceptionContext(this.bus, var1_1, this.target, this.method);
    }

    public final int hashCode() {
        return (31 + this.method.hashCode()) * 31 + System.identityHashCode(this.target);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj instanceof Subscriber) {
            void var1_1;
            Subscriber that = (Subscriber)obj;
            return this.target == that.target && this.method.equals(var1_1.method);
        }
        return false;
    }

    private static boolean isDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    @VisibleForTesting
    static final class SynchronizedSubscriber
    extends Subscriber {
        /*
         * WARNING - void declaration
         */
        private SynchronizedSubscriber(EventBus bus, Object target, Method method) {
            super((EventBus)var1_1, var2_2, (Method)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void invokeSubscriberMethod(Object event) throws InvocationTargetException {
            SynchronizedSubscriber synchronizedSubscriber = this;
            synchronized (synchronizedSubscriber) {
                void var1_1;
                super.invokeSubscriberMethod(var1_1);
                return;
            }
        }
    }
}

