/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.Dispatcher;
import com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import com.google.common.eventbus.Subscriber;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.common.eventbus.SubscriberRegistry;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
public class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus() {
        this("default");
    }

    /*
     * WARNING - void declaration
     */
    public EventBus(String identifier) {
        this((String)var1_1, MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), LoggingHandler.INSTANCE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EventBus(SubscriberExceptionHandler exceptionHandler) {
        this("default", MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), (SubscriberExceptionHandler)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    EventBus(String identifier, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler exceptionHandler) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.identifier = (String)Preconditions.checkNotNull(var1_1);
        this.executor = (Executor)Preconditions.checkNotNull(var2_2);
        this.dispatcher = (Dispatcher)Preconditions.checkNotNull(var3_3);
        this.exceptionHandler = Preconditions.checkNotNull(exceptionHandler);
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    /*
     * WARNING - void declaration
     */
    void handleSubscriberException(Throwable e, SubscriberExceptionContext context) {
        Preconditions.checkNotNull(e);
        Preconditions.checkNotNull(context);
        try {
            this.exceptionHandler.handleException(e, context);
            return;
        }
        catch (Throwable e2) {
            void var2_3;
            void var1_1;
            logger.log(Level.SEVERE, String.format(Locale.ROOT, "Exception %s thrown while handling exception: %s", e2, var1_1), (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void register(Object object) {
        void var1_1;
        this.subscribers.register(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void unregister(Object object) {
        void var1_1;
        this.subscribers.unregister(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void post(Object event) {
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            void var2_2;
            this.dispatcher.dispatch(event, (Iterator<Subscriber>)var2_2);
            return;
        }
        if (!(event instanceof DeadEvent)) {
            void var1_1;
            this.post(new DeadEvent(this, var1_1));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.identifier).toString();
    }

    static final class LoggingHandler
    implements SubscriberExceptionHandler {
        static final LoggingHandler INSTANCE = new LoggingHandler();

        LoggingHandler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void handleException(Throwable exception, SubscriberExceptionContext context) {
            Logger logger = LoggingHandler.logger(context);
            if (logger.isLoggable(Level.SEVERE)) {
                void var1_1;
                void var2_2;
                void var3_3;
                var3_3.log(Level.SEVERE, LoggingHandler.message((SubscriberExceptionContext)var2_2), (Throwable)var1_1);
            }
        }

        private static Logger logger(SubscriberExceptionContext context) {
            String string;
            String string2 = EventBus.class.getName();
            string = ((SubscriberExceptionContext)((Object)string)).getEventBus().identifier();
            return Logger.getLogger(new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(".").append(string).toString());
        }

        private static String message(SubscriberExceptionContext context) {
            String string;
            String string2;
            Method method = context.getSubscriberMethod();
            String string3 = method.getName();
            string2 = ((Method)((Object)string2)).getParameterTypes()[0].getName();
            String string4 = String.valueOf(context.getSubscriber());
            string = String.valueOf(((SubscriberExceptionContext)((Object)string)).getEvent());
            return new StringBuilder(80 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append("Exception thrown by subscriber method ").append(string3).append('(').append(string2).append(')').append(" on subscriber ").append(string4).append(" when dispatching event: ").append(string).toString();
        }
    }
}

