/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import com.google.common.eventbus.Subscriber;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@ElementTypesAreNonnullByDefault
abstract class Dispatcher {
    Dispatcher() {
    }

    static Dispatcher perThreadDispatchQueue() {
        return new PerThreadQueuedDispatcher();
    }

    static Dispatcher legacyAsync() {
        return new LegacyAsyncDispatcher();
    }

    static Dispatcher immediate() {
        return ImmediateDispatcher.INSTANCE;
    }

    abstract void dispatch(Object var1, Iterator<Subscriber> var2);

    private static final class ImmediateDispatcher
    extends Dispatcher {
        private static final ImmediateDispatcher INSTANCE = new ImmediateDispatcher();

        private ImmediateDispatcher() {
        }

        @Override
        final void dispatch(Object event, Iterator<Subscriber> subscribers) {
            Preconditions.checkNotNull(event);
            while (subscribers.hasNext()) {
                subscribers.next().dispatchEvent(event);
            }
        }
    }

    private static final class LegacyAsyncDispatcher
    extends Dispatcher {
        private final ConcurrentLinkedQueue<EventWithSubscriber> queue = Queues.newConcurrentLinkedQueue();

        private LegacyAsyncDispatcher() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void dispatch(Object event, Iterator<Subscriber> subscribers) {
            EventWithSubscriber e;
            Preconditions.checkNotNull(event);
            while (subscribers.hasNext()) {
                this.queue.add(new EventWithSubscriber(event, subscribers.next()));
            }
            while ((e = this.queue.poll()) != null) {
                void var1_1;
                e.subscriber.dispatchEvent(((EventWithSubscriber)var1_1).event);
            }
        }

        private static final class EventWithSubscriber {
            private final Object event;
            private final Subscriber subscriber;

            /*
             * WARNING - void declaration
             */
            private EventWithSubscriber(Object event, Subscriber subscriber) {
                void var2_2;
                void var1_1;
                this.event = var1_1;
                this.subscriber = var2_2;
            }
        }
    }

    private static final class PerThreadQueuedDispatcher
    extends Dispatcher {
        private final ThreadLocal<Queue<Event>> queue = new ThreadLocal<Queue<Event>>(this){

            @Override
            protected Queue<Event> initialValue() {
                return Queues.newArrayDeque();
            }
        };
        private final ThreadLocal<Boolean> dispatching = new ThreadLocal<Boolean>(this){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        private PerThreadQueuedDispatcher() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void dispatch(Object event, Iterator<Subscriber> subscribers) {
            void var2_3;
            Preconditions.checkNotNull(event);
            Preconditions.checkNotNull(subscribers);
            Queue<Event> queueForThread = this.queue.get();
            queueForThread.offer(new Event(event, (Iterator)var2_3));
            if (!this.dispatching.get().booleanValue()) {
                this.dispatching.set(Boolean.TRUE);
                try {
                    Event nextEvent;
                    while ((nextEvent = queueForThread.poll()) != null) {
                        while (nextEvent.subscribers.hasNext()) {
                            ((Subscriber)nextEvent.subscribers.next()).dispatchEvent(nextEvent.event);
                        }
                    }
                    return;
                }
                finally {
                    this.dispatching.remove();
                    this.queue.remove();
                }
            }
        }

        private static final class Event {
            private final Object event;
            private final Iterator<Subscriber> subscribers;

            /*
             * WARNING - void declaration
             */
            private Event(Object event, Iterator<Subscriber> subscribers) {
                void var2_2;
                void var1_1;
                this.event = var1_1;
                this.subscribers = var2_2;
            }
        }
    }
}

