/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import com.google.common.escape.Escaper;
import com.google.common.escape.Platform;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected UnicodeEscaper() {
    }

    protected abstract char[] escape(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public String escape(String string) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(string);
        int end = string.length();
        int index = this.nextEscapeIndex(string, 0, end);
        if (index == var2_2) {
            return string;
        }
        return this.escapeSlow((String)var1_1, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected int nextEscapeIndex(CharSequence csq, int start, int end) {
        void var2_2;
        int cp;
        for (int index = start; index < end && (cp = UnicodeEscaper.codePointAt(csq, index, end)) >= 0 && this.escape(cp) == null; index += Character.isSupplementaryCodePoint(cp) ? 2 : 1) {
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected final String escapeSlow(String s, int index) {
        int end = s.length();
        char[] dest = Platform.charBufferFromThreadLocal();
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index < end) {
            int cp = UnicodeEscaper.codePointAt(s, index, end);
            if (cp < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped = this.escape(cp);
            int nextIndex = index + (Character.isSupplementaryCodePoint(cp) ? 2 : 1);
            if (escaped != null) {
                int charsSkipped = index - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end - index) + 32;
                    dest = UnicodeEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s.getChars(unescapedChunkStart, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy(escaped, 0, dest, destIndex, escaped.length);
                    destIndex += escaped.length;
                }
                unescapedChunkStart = nextIndex;
            }
            index = this.nextEscapeIndex(s, nextIndex, end);
        }
        int charsSkipped = end - unescapedChunkStart;
        if (charsSkipped > 0) {
            void var3_3;
            void var1_1;
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = UnicodeEscaper.growBuffer(dest, destIndex, endIndex);
            }
            var1_1.getChars(unescapedChunkStart, (int)var3_3, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    /*
     * WARNING - void declaration
     */
    protected static int codePointAt(CharSequence seq, int index, int end) {
        Preconditions.checkNotNull(seq);
        if (index < end) {
            void var3_4;
            CharSequence charSequence;
            void var1_1;
            char c;
            char c1;
            if ((c1 = seq.charAt(index++)) < '\ud800' || c1 > '\udfff') {
                return c1;
            }
            if (c1 <= '\udbff') {
                if (index == end) {
                    return -c1;
                }
                char c2 = seq.charAt(index);
                if (Character.isLowSurrogate(c2)) {
                    return Character.toCodePoint(c1, c2);
                }
                char c3 = c2;
                seq = String.valueOf(seq);
                throw new IllegalArgumentException(new StringBuilder(89 + String.valueOf(seq).length()).append("Expected low surrogate but got char '").append(c).append("' with value ").append((int)c3).append(" at index ").append(index).append(" in '").append((String)seq).append("'").toString());
            }
            c = c1;
            void var4_6 = var1_1 - true;
            String string = String.valueOf(charSequence);
            throw new IllegalArgumentException(new StringBuilder(88 + String.valueOf(string).length()).append("Unexpected low surrogate character '").append((char)var3_4).append("' with value ").append((int)c).append(" at index ").append((int)var4_6).append(" in '").append(string).append("'").toString());
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    /*
     * WARNING - void declaration
     */
    private static char[] growBuffer(char[] dest, int index, int size) {
        void var2_3;
        if (size < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] copy = new char[size];
        if (index > 0) {
            void var1_1;
            char[] cArray;
            System.arraycopy(cArray, 0, copy, 0, (int)var1_1);
        }
        return var2_3;
    }
}

