/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import com.google.common.escape.Escaper;
import com.google.common.escape.UnicodeEscaper;
import java.util.HashMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Escapers {
    private static final Escaper NULL_ESCAPER = new CharEscaper(){

        @Override
        public String escape(String string) {
            return Preconditions.checkNotNull(string);
        }

        @Override
        protected char[] escape(char c) {
            return null;
        }
    };

    private Escapers() {
    }

    public static Escaper nullEscaper() {
        return NULL_ESCAPER;
    }

    public static Builder builder() {
        return new Builder();
    }

    static UnicodeEscaper asUnicodeEscaper(Escaper escaper) {
        Escaper escaper2;
        Preconditions.checkNotNull(escaper);
        if (escaper instanceof UnicodeEscaper) {
            return (UnicodeEscaper)escaper;
        }
        if (escaper instanceof CharEscaper) {
            return Escapers.wrap((CharEscaper)escaper);
        }
        String string = String.valueOf(escaper2.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "Cannot create a UnicodeEscaper from: ".concat(string) : new String("Cannot create a UnicodeEscaper from: "));
    }

    /*
     * WARNING - void declaration
     */
    public static String computeReplacement(CharEscaper escaper, char c) {
        void var1_1;
        return Escapers.stringOrNull(escaper.escape((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String computeReplacement(UnicodeEscaper escaper, int cp) {
        void var1_1;
        return Escapers.stringOrNull(escaper.escape((int)var1_1));
    }

    private static String stringOrNull(char[] in) {
        char[] cArray;
        if (in == null) {
            return null;
        }
        return new String(cArray);
    }

    private static UnicodeEscaper wrap(CharEscaper escaper) {
        CharEscaper charEscaper;
        return new UnicodeEscaper(){

            /*
             * WARNING - void declaration
             */
            @Override
            protected char[] escape(int cp) {
                int n;
                if (cp < 65536) {
                    return charEscaper.escape((char)cp);
                }
                char[] surrogateChars = new char[2];
                Character.toChars(cp, surrogateChars, 0);
                char[] hiChars = charEscaper.escape(surrogateChars[0]);
                char[] loChars = charEscaper.escape(surrogateChars[1]);
                if (hiChars == null && loChars == null) {
                    return null;
                }
                int hiCount = hiChars != null ? hiChars.length : 1;
                int loCount = loChars != null ? loChars.length : 1;
                char[] output = new char[hiCount + loCount];
                if (hiChars != null) {
                    for (n = 0; n < hiChars.length; ++n) {
                        output[n] = hiChars[n];
                    }
                } else {
                    output[0] = surrogateChars[0];
                }
                if (loChars != null) {
                    for (n = 0; n < loChars.length; ++n) {
                        output[hiCount + n] = loChars[n];
                    }
                } else {
                    void var2_3;
                    output[hiCount] = var2_3[1];
                }
                return output;
            }
        };
    }

    public static final class Builder {
        private final Map<Character, String> replacementMap = new HashMap<Character, String>();
        private char safeMin = '\u0000';
        private char safeMax = (char)65535;
        private String unsafeReplacement = null;

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setSafeRange(char safeMin, char safeMax) {
            void var2_2;
            void var1_1;
            this.safeMin = var1_1;
            this.safeMax = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setUnsafeReplacement(String unsafeReplacement) {
            void var1_1;
            this.unsafeReplacement = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addEscape(char c, String replacement) {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(replacement);
            this.replacementMap.put(Character.valueOf((char)var1_1), (String)var2_2);
            return this;
        }

        public final Escaper build() {
            Builder builder = this;
            return new ArrayBasedCharEscaper(builder, builder.replacementMap, this.safeMin, this.safeMax){
                private final char[] replacementChars;
                final /* synthetic */ Builder this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((Map<Character, String>)var2_2, (char)var3_3, safeMax);
                    this.replacementChars = this.this$0.unsafeReplacement != null ? this.this$0.unsafeReplacement.toCharArray() : null;
                }

                @Override
                protected char[] escapeUnsafe(char c) {
                    return this.replacementChars;
                }
            };
        }
    }
}

