/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import com.google.common.escape.Escaper;
import java.util.HashMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    /*
     * WARNING - void declaration
     */
    public final CharEscaperBuilder addEscape(char c, String r) {
        void var2_2;
        this.map.put(Character.valueOf(c), (String)Preconditions.checkNotNull(var2_2));
        if (c > this.max) {
            void var1_1;
            this.max = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CharEscaperBuilder addEscapes(char[] cs, String r) {
        void var1_1;
        Preconditions.checkNotNull(r);
        for (void c : var1_1) {
            this.addEscape((char)c, r);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final char[][] toArray() {
        void var1_1;
        char[][] result = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            void var3_3;
            result[entry.getKey().charValue()] = ((String)var3_3.getValue()).toCharArray();
        }
        return var1_1;
    }

    public final Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final char[][] replacements;
        private final int replaceLength;

        /*
         * WARNING - void declaration
         */
        CharArrayDecorator(char[][] replacements) {
            void var1_1;
            this.replacements = replacements;
            this.replaceLength = ((void)var1_1).length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String escape(String s) {
            void var1_1;
            int slen = s.length();
            for (int index = 0; index < slen; ++index) {
                char c = s.charAt(index);
                if (c >= this.replacements.length || this.replacements[c] == null) continue;
                return this.escapeSlow(s, index);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected char[] escape(char c) {
            if (c < this.replaceLength) {
                void var1_1;
                return this.replacements[var1_1];
            }
            return null;
        }
    }
}

