/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import com.google.common.escape.UnicodeEscaper;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ArrayBasedUnicodeEscaper
extends UnicodeEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final int safeMin;
    private final int safeMax;
    private final char safeMinChar;
    private final char safeMaxChar;

    /*
     * WARNING - void declaration
     */
    protected ArrayBasedUnicodeEscaper(Map<Character, String> replacementMap, int safeMin, int safeMax, String unsafeReplacement) {
        this(ArrayBasedEscaperMap.create((Map<Character, String>)var1_1), (int)var2_2, (int)var3_3, unsafeReplacement);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ArrayBasedUnicodeEscaper(ArrayBasedEscaperMap escaperMap, int safeMin, int safeMax, String unsafeReplacement) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(escaperMap);
        this.replacements = var1_1.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = -1;
            safeMin = Integer.MAX_VALUE;
        }
        this.safeMin = safeMin;
        this.safeMax = safeMax;
        if (safeMin >= 55296) {
            this.safeMinChar = (char)65535;
            this.safeMaxChar = '\u0000';
            return;
        }
        this.safeMinChar = (char)var2_2;
        this.safeMaxChar = (char)Math.min((int)var3_3, 55295);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String escape(String s) {
        void var1_1;
        Preconditions.checkNotNull(s);
        for (int i = 0; i < s.length(); ++i) {
            void var3_3;
            char c = s.charAt(i);
            if ((c >= this.replacementsLength || this.replacements[c] == null) && c <= this.safeMaxChar && var3_3 >= this.safeMinChar) continue;
            return this.escapeSlow(s, i);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final char[] escape(int cp) {
        void var1_1;
        char[] chars;
        if (cp < this.replacementsLength && (chars = this.replacements[cp]) != null) {
            void var2_2;
            return var2_2;
        }
        if (cp >= this.safeMin && cp <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int nextEscapeIndex(CharSequence csq, int index, int end) {
        void var2_2;
        char c;
        while (index < end && ((c = csq.charAt(index)) >= this.replacementsLength || this.replacements[c] == null) && c <= this.safeMaxChar && c >= this.safeMinChar) {
            ++index;
        }
        return (int)var2_2;
    }

    protected abstract char[] escapeUnsafe(int var1);
}

