/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import java.util.Collections;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class ArrayBasedEscaperMap {
    private final char[][] replacementArray;
    private static final char[][] EMPTY_REPLACEMENT_ARRAY = new char[0][0];

    public static ArrayBasedEscaperMap create(Map<Character, String> replacements) {
        Map<Character, String> map;
        return new ArrayBasedEscaperMap(ArrayBasedEscaperMap.createReplacementArray(map));
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBasedEscaperMap(char[][] replacementArray) {
        void var1_1;
        this.replacementArray = var1_1;
    }

    final char[][] getReplacementArray() {
        return this.replacementArray;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static char[][] createReplacementArray(Map<Character, String> map) {
        void var1_2;
        Preconditions.checkNotNull(map);
        if (map.isEmpty()) {
            return EMPTY_REPLACEMENT_ARRAY;
        }
        char c = Collections.max(map.keySet()).charValue();
        char[][] replacements = new char[c + '\u0001'][];
        for (Character c2 : map.keySet()) {
            void var3_4;
            replacements[c2.charValue()] = map.get(var3_4).toCharArray();
        }
        return var1_2;
    }
}

