/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.ElementTypesAreNonnullByDefault;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ArrayBasedCharEscaper
extends CharEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final char safeMin;
    private final char safeMax;

    /*
     * WARNING - void declaration
     */
    protected ArrayBasedCharEscaper(Map<Character, String> replacementMap, char safeMin, char safeMax) {
        this(ArrayBasedEscaperMap.create((Map<Character, String>)var1_1), (char)var2_2, (char)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ArrayBasedCharEscaper(ArrayBasedEscaperMap escaperMap, char safeMin, char safeMax) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(escaperMap);
        this.replacements = var1_1.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (safeMax < safeMin) {
            safeMax = '\u0000';
            safeMin = (char)65535;
        }
        this.safeMin = var2_2;
        this.safeMax = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String escape(String s) {
        void var1_1;
        Preconditions.checkNotNull(s);
        for (int i = 0; i < s.length(); ++i) {
            void var3_3;
            char c = s.charAt(i);
            if ((c >= this.replacementsLength || this.replacements[c] == null) && c <= this.safeMax && var3_3 >= this.safeMin) continue;
            return this.escapeSlow(s, i);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final char[] escape(char c) {
        void var1_1;
        char[] chars;
        if (c < this.replacementsLength && (chars = this.replacements[c]) != null) {
            void var2_2;
            return var2_2;
        }
        if (c >= this.safeMin && c <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe((char)var1_1);
    }

    protected abstract char[] escapeUnsafe(char var1);
}

