/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import java.util.Comparator;
import java.util.NavigableSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class UnmodifiableSortedMultiset<E>
extends Multisets.UnmodifiableMultiset<E>
implements SortedMultiset<E> {
    private transient UnmodifiableSortedMultiset<E> descendingMultiset;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    UnmodifiableSortedMultiset(SortedMultiset<E> delegate) {
        super(var1_1);
        void var1_1;
    }

    @Override
    protected final SortedMultiset<E> delegate() {
        return (SortedMultiset)super.delegate();
    }

    @Override
    public final Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    final NavigableSet<E> createElementSet() {
        return Sets.unmodifiableNavigableSet(this.delegate().elementSet());
    }

    @Override
    public final NavigableSet<E> elementSet() {
        return (NavigableSet)super.elementSet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> descendingMultiset() {
        void var1_1;
        UnmodifiableSortedMultiset<E> result = this.descendingMultiset;
        if (result == null) {
            result = new UnmodifiableSortedMultiset(this.delegate().descendingMultiset());
            new UnmodifiableSortedMultiset(this.delegate().descendingMultiset()).descendingMultiset = this;
            this.descendingMultiset = result;
            return this.descendingMultiset;
        }
        return var1_1;
    }

    @Override
    public final Multiset.Entry<E> firstEntry() {
        return this.delegate().firstEntry();
    }

    @Override
    public final Multiset.Entry<E> lastEntry() {
        return this.delegate().lastEntry();
    }

    @Override
    public final Multiset.Entry<E> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Multiset.Entry<E> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> headMultiset(@ParametricNullness E upperBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        return Multisets.unmodifiableSortedMultiset(this.delegate().headMultiset(var1_1, (BoundType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> subMultiset(@ParametricNullness E lowerBound, BoundType lowerBoundType, @ParametricNullness E upperBound, BoundType upperBoundType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Multisets.unmodifiableSortedMultiset(this.delegate().subMultiset(var1_1, (BoundType)var2_2, var3_3, upperBoundType));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> tailMultiset(@ParametricNullness E lowerBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        return Multisets.unmodifiableSortedMultiset(this.delegate().tailMultiset(var1_1, (BoundType)var2_2));
    }
}

