/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractNavigableMap;
import com.google.common.collect.AbstractRangeSet;
import com.google.common.collect.BoundType;
import com.google.common.collect.Cut;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public class TreeRangeSet<C extends Comparable<?>>
extends AbstractRangeSet<C>
implements Serializable {
    @VisibleForTesting
    final NavigableMap<Cut<C>, Range<C>> rangesByLowerBound;
    private transient Set<Range<C>> asRanges;
    private transient Set<Range<C>> asDescendingSetOfRanges;
    private transient RangeSet<C> complement;

    public static <C extends Comparable<?>> TreeRangeSet<C> create() {
        return new TreeRangeSet<C>(new TreeMap<Cut<C>, Range<C>>());
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> TreeRangeSet<C> create(RangeSet<C> rangeSet) {
        void var1_1;
        RangeSet<C> rangeSet2;
        TreeRangeSet<C> result = TreeRangeSet.create();
        result.addAll((RangeSet)rangeSet2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> TreeRangeSet<C> create(Iterable<Range<C>> ranges) {
        void var1_1;
        Iterable<Range<C>> iterable;
        TreeRangeSet<C> result = TreeRangeSet.create();
        result.addAll(iterable);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TreeRangeSet(NavigableMap<Cut<C>, Range<C>> rangesByLowerCut) {
        void var1_1;
        this.rangesByLowerBound = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Range<C>> asRanges() {
        void var1_1;
        Set<Range<C>> result = this.asRanges;
        if (result == null) {
            TreeRangeSet treeRangeSet = this;
            this.asRanges = new AsRanges(treeRangeSet, treeRangeSet.rangesByLowerBound.values());
            return this.asRanges;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Range<C>> asDescendingSetOfRanges() {
        void var1_1;
        Set<Range<C>> result = this.asDescendingSetOfRanges;
        if (result == null) {
            TreeRangeSet treeRangeSet = this;
            this.asDescendingSetOfRanges = new AsRanges(treeRangeSet, treeRangeSet.rangesByLowerBound.descendingMap().values());
            return this.asDescendingSetOfRanges;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Range<C> rangeContaining(C value) {
        void var1_1;
        Preconditions.checkNotNull(value);
        Map.Entry<Cut<C>, Range<C>> floorEntry = this.rangesByLowerBound.floorEntry(Cut.belowValue(value));
        if (floorEntry != null && floorEntry.getValue().contains(var1_1)) {
            void var2_2;
            return (Range)var2_2.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean intersects(Range<C> range) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(range);
        Map.Entry ceilingEntry = this.rangesByLowerBound.ceilingEntry(range.lowerBound);
        if (ceilingEntry != null && ceilingEntry.getValue().isConnected(range) && !ceilingEntry.getValue().intersection(range).isEmpty()) {
            return true;
        }
        Map.Entry priorEntry = this.rangesByLowerBound.lowerEntry(range.lowerBound);
        return priorEntry != null && priorEntry.getValue().isConnected(range) && !((Range)var2_2.getValue()).intersection(var1_1).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean encloses(Range<C> range) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(range);
        Map.Entry floorEntry = this.rangesByLowerBound.floorEntry(range.lowerBound);
        return floorEntry != null && ((Range)var2_2.getValue()).encloses(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Range<C> rangeEnclosing(Range<C> range) {
        void var1_1;
        Preconditions.checkNotNull(range);
        Map.Entry floorEntry = this.rangesByLowerBound.floorEntry(range.lowerBound);
        if (floorEntry != null && floorEntry.getValue().encloses((Range<C>)var1_1)) {
            void var2_2;
            return (Range)var2_2.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Range<C> span() {
        void var2_2;
        void var1_1;
        Map.Entry<Cut<C>, Range<C>> firstEntry = this.rangesByLowerBound.firstEntry();
        Map.Entry<Cut<C>, Range<C>> lastEntry = this.rangesByLowerBound.lastEntry();
        if (firstEntry == null || lastEntry == null) {
            throw new NoSuchElementException();
        }
        return Range.create(((Range)var1_1.getValue()).lowerBound, ((Range)var2_2.getValue()).upperBound);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(Range<C> rangeToAdd) {
        void var1_1;
        void var2_2;
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToAdd);
        if (rangeToAdd.isEmpty()) {
            return;
        }
        Cut lbToAdd = rangeToAdd.lowerBound;
        Cut ubToAdd = rangeToAdd.upperBound;
        Map.Entry entryBelowLB = this.rangesByLowerBound.lowerEntry(lbToAdd);
        if (entryBelowLB != null) {
            Range<C> rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(lbToAdd) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(ubToAdd) >= 0) {
                    ubToAdd = rangeBelowLB.upperBound;
                }
                lbToAdd = rangeBelowLB.lowerBound;
            }
        }
        if ((entryBelowUB = this.rangesByLowerBound.floorEntry(ubToAdd)) != null) {
            Range<C> rangeBelowUB = entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(ubToAdd) >= 0) {
                void var3_3;
                ubToAdd = var3_3.upperBound;
            }
        }
        this.rangesByLowerBound.subMap(lbToAdd, ubToAdd).clear();
        this.replaceRangeWithSameLowerBound(Range.create(var2_2, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(Range<C> rangeToRemove) {
        void var1_1;
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToRemove);
        if (rangeToRemove.isEmpty()) {
            return;
        }
        Map.Entry entryBelowLB = this.rangesByLowerBound.lowerEntry(rangeToRemove.lowerBound);
        if (entryBelowLB != null) {
            Range<C> rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(rangeToRemove.lowerBound) >= 0) {
                if (rangeToRemove.hasUpperBound() && rangeBelowLB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                    this.replaceRangeWithSameLowerBound(Range.create(rangeToRemove.upperBound, rangeBelowLB.upperBound));
                }
                this.replaceRangeWithSameLowerBound(Range.create(rangeBelowLB.lowerBound, rangeToRemove.lowerBound));
            }
        }
        if ((entryBelowUB = this.rangesByLowerBound.floorEntry(rangeToRemove.upperBound)) != null) {
            Range<C> rangeBelowUB = entryBelowUB.getValue();
            if (rangeToRemove.hasUpperBound() && rangeBelowUB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                void var2_2;
                this.replaceRangeWithSameLowerBound(Range.create(rangeToRemove.upperBound, var2_2.upperBound));
            }
        }
        this.rangesByLowerBound.subMap(rangeToRemove.lowerBound, var1_1.upperBound).clear();
    }

    /*
     * WARNING - void declaration
     */
    private void replaceRangeWithSameLowerBound(Range<C> range) {
        void var1_1;
        if (range.isEmpty()) {
            this.rangesByLowerBound.remove(range.lowerBound);
            return;
        }
        this.rangesByLowerBound.put(range.lowerBound, (Range<C>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RangeSet<C> complement() {
        void var1_1;
        RangeSet<C> result = this.complement;
        if (result == null) {
            this.complement = new Complement();
            return this.complement;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RangeSet<C> subRangeSet(Range<C> view) {
        void var1_1;
        if (view.equals(Range.all())) {
            return this;
        }
        return new SubRangeSet(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Range access$600(TreeRangeSet x0, Range x1) {
        void var1_1;
        return x0.rangeEnclosing((Range)var1_1);
    }

    private final class SubRangeSet
    extends TreeRangeSet<C> {
        private final Range<C> restriction;

        /*
         * WARNING - void declaration
         */
        SubRangeSet(Range<C> restriction) {
            void var2_2;
            super(new SubRangeSetRangesByLowerBound(Range.all(), restriction, TreeRangeSet.this.rangesByLowerBound));
            this.restriction = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean encloses(Range<C> range) {
            if (!this.restriction.isEmpty() && this.restriction.encloses(range)) {
                void var1_1;
                Range enclosing = TreeRangeSet.access$600(TreeRangeSet.this, range);
                return enclosing != null && !var1_1.intersection(this.restriction).isEmpty();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Range<C> rangeContaining(C value) {
            void var1_1;
            if (!this.restriction.contains(value)) {
                return null;
            }
            Range result = TreeRangeSet.this.rangeContaining(value);
            if (result == null) {
                return null;
            }
            return var1_1.intersection(this.restriction);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(Range<C> rangeToAdd) {
            void var1_1;
            Preconditions.checkArgument(this.restriction.encloses(rangeToAdd), "Cannot add range %s to subRangeSet(%s)", rangeToAdd, this.restriction);
            TreeRangeSet.this.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void remove(Range<C> rangeToRemove) {
            if (rangeToRemove.isConnected(this.restriction)) {
                void var1_1;
                TreeRangeSet.this.remove(var1_1.intersection(this.restriction));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(C value) {
            void var1_1;
            return this.restriction.contains(value) && TreeRangeSet.this.contains((Comparable)var1_1);
        }

        @Override
        public final void clear() {
            TreeRangeSet.this.remove(this.restriction);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final RangeSet<C> subRangeSet(Range<C> view) {
            if (view.encloses(this.restriction)) {
                return this;
            }
            if (view.isConnected(this.restriction)) {
                void var1_1;
                SubRangeSet subRangeSet = this;
                return subRangeSet.new SubRangeSet(subRangeSet.restriction.intersection((Range)var1_1));
            }
            return ImmutableRangeSet.of();
        }
    }

    private static final class SubRangeSetRangesByLowerBound<C extends Comparable<?>>
    extends AbstractNavigableMap<Cut<C>, Range<C>> {
        private final Range<Cut<C>> lowerBoundWindow;
        private final Range<C> restriction;
        private final NavigableMap<Cut<C>, Range<C>> rangesByLowerBound;
        private final NavigableMap<Cut<C>, Range<C>> rangesByUpperBound;

        /*
         * WARNING - void declaration
         */
        private SubRangeSetRangesByLowerBound(Range<Cut<C>> lowerBoundWindow, Range<C> restriction, NavigableMap<Cut<C>, Range<C>> rangesByLowerBound) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.lowerBoundWindow = (Range)Preconditions.checkNotNull(var1_1);
            this.restriction = (Range)Preconditions.checkNotNull(var2_2);
            this.rangesByLowerBound = Preconditions.checkNotNull(rangesByLowerBound);
            this.rangesByUpperBound = new RangesByUpperBound(var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private NavigableMap<Cut<C>, Range<C>> subMap(Range<Cut<C>> window) {
            void var1_1;
            if (!window.isConnected(this.lowerBoundWindow)) {
                return ImmutableSortedMap.of();
            }
            return new SubRangeSetRangesByLowerBound<C>(this.lowerBoundWindow.intersection((Range<Cut<C>>)var1_1), this.restriction, this.rangesByLowerBound);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> subMap(Cut<C> fromKey, boolean fromInclusive, Cut<C> toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.subMap(Range.range(var1_1, BoundType.forBoolean((boolean)var2_2), var3_3, BoundType.forBoolean(toInclusive)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> headMap(Cut<C> toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subMap(Range.upTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> tailMap(Cut<C> fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subMap(Range.downTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        @Override
        public final Comparator<? super Cut<C>> comparator() {
            return Ordering.natural();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Range<C> get(Object key) {
            if (key instanceof Cut) {
                try {
                    Range<C> candidate;
                    Cut cut = (Cut)key;
                    if (!this.lowerBoundWindow.contains(cut) || cut.compareTo(this.restriction.lowerBound) < 0 || cut.compareTo(this.restriction.upperBound) >= 0) {
                        return null;
                    }
                    if (cut.equals(this.restriction.lowerBound)) {
                        candidate = Maps.valueOrNull(this.rangesByLowerBound.floorEntry(cut));
                        if (candidate != null && candidate.upperBound.compareTo(this.restriction.lowerBound) > 0) {
                            return candidate.intersection(this.restriction);
                        }
                    } else {
                        Range result = (Range)this.rangesByLowerBound.get(candidate);
                        if (result != null) {
                            void var1_1;
                            return var1_1.intersection(this.restriction);
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> entryIterator() {
            block4: {
                if (this.restriction.isEmpty()) {
                    return Iterators.emptyIterator();
                }
                if (this.lowerBoundWindow.upperBound.isLessThan(this.restriction.lowerBound)) {
                    return Iterators.emptyIterator();
                }
                if (!this.lowerBoundWindow.lowerBound.isLessThan(this.restriction.lowerBound)) break block4;
                v0 = this.rangesByUpperBound;
                v1 = this.restriction.lowerBound;
                ** GOTO lbl-1000
            }
            v0 = this.rangesByLowerBound;
            v1 = (Cut)this.lowerBoundWindow.lowerBound.endpoint();
            if (this.lowerBoundWindow.lowerBoundType() == BoundType.CLOSED) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            completeRangeItr = v0.tailMap(v1, v2).values().iterator();
            upperBoundOnLowerBounds = Ordering.natural().min(this.lowerBoundWindow.upperBound, Cut.belowValue(this.restriction.upperBound));
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (Iterator)var1_1, (Cut)var2_2){
                final /* synthetic */ Iterator val$completeRangeItr;
                final /* synthetic */ Cut val$upperBoundOnLowerBounds;
                final /* synthetic */ SubRangeSetRangesByLowerBound this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$completeRangeItr = iterator;
                    this.val$upperBoundOnLowerBounds = cut;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<Cut<C>, Range<C>> computeNext() {
                    void var1_1;
                    if (!this.val$completeRangeItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    Range nextRange = (Range)this.val$completeRangeItr.next();
                    if (this.val$upperBoundOnLowerBounds.isLessThan(nextRange.lowerBound)) {
                        return (Map.Entry)this.endOfData();
                    }
                    nextRange = nextRange.intersection(this.this$0.restriction);
                    return Maps.immutableEntry(nextRange.lowerBound, var1_1);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> descendingEntryIterator() {
            void var1_1;
            Cut upperBoundOnLowerBounds;
            if (this.restriction.isEmpty()) {
                return Iterators.emptyIterator();
            }
            Iterator completeRangeItr = this.rangesByLowerBound.headMap(upperBoundOnLowerBounds.endpoint(), (upperBoundOnLowerBounds = Ordering.natural().min(this.lowerBoundWindow.upperBound, Cut.belowValue(this.restriction.upperBound))).typeAsUpperBound() == BoundType.CLOSED).descendingMap().values().iterator();
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (Iterator)var1_1){
                final /* synthetic */ Iterator val$completeRangeItr;
                final /* synthetic */ SubRangeSetRangesByLowerBound this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$completeRangeItr = iterator;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<Cut<C>, Range<C>> computeNext() {
                    if (!this.val$completeRangeItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    Range nextRange = (Range)this.val$completeRangeItr.next();
                    if (((SubRangeSetRangesByLowerBound)this.this$0).restriction.lowerBound.compareTo(nextRange.upperBound) >= 0) {
                        return (Map.Entry)this.endOfData();
                    }
                    nextRange = nextRange.intersection(this.this$0.restriction);
                    if (this.this$0.lowerBoundWindow.contains(nextRange.lowerBound)) {
                        void var1_1;
                        return Maps.immutableEntry(nextRange.lowerBound, var1_1);
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }

        @Override
        public final int size() {
            return Iterators.size(this.entryIterator());
        }
    }

    private final class Complement
    extends TreeRangeSet<C> {
        Complement() {
            super(new ComplementRangesByLowerBound(TreeRangeSet.this.rangesByLowerBound));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(Range<C> rangeToAdd) {
            void var1_1;
            TreeRangeSet.this.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void remove(Range<C> rangeToRemove) {
            void var1_1;
            TreeRangeSet.this.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(C value) {
            void var1_1;
            return !TreeRangeSet.this.contains((Comparable)var1_1);
        }

        @Override
        public final RangeSet<C> complement() {
            return TreeRangeSet.this;
        }
    }

    private static final class ComplementRangesByLowerBound<C extends Comparable<?>>
    extends AbstractNavigableMap<Cut<C>, Range<C>> {
        private final NavigableMap<Cut<C>, Range<C>> positiveRangesByLowerBound;
        private final NavigableMap<Cut<C>, Range<C>> positiveRangesByUpperBound;
        private final Range<Cut<C>> complementLowerBoundWindow;

        /*
         * WARNING - void declaration
         */
        ComplementRangesByLowerBound(NavigableMap<Cut<C>, Range<C>> positiveRangesByLowerBound) {
            this((NavigableMap<Cut<C>, Range<C>>)var1_1, Range.all());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private ComplementRangesByLowerBound(NavigableMap<Cut<C>, Range<C>> positiveRangesByLowerBound, Range<Cut<C>> window) {
            void var2_2;
            void var1_1;
            this.positiveRangesByLowerBound = positiveRangesByLowerBound;
            this.positiveRangesByUpperBound = new RangesByUpperBound(var1_1);
            this.complementLowerBoundWindow = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private NavigableMap<Cut<C>, Range<C>> subMap(Range<Cut<C>> subWindow) {
            void var1_1;
            if (!this.complementLowerBoundWindow.isConnected(subWindow)) {
                return ImmutableSortedMap.of();
            }
            subWindow = subWindow.intersection(this.complementLowerBoundWindow);
            return new ComplementRangesByLowerBound<C>(this.positiveRangesByLowerBound, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> subMap(Cut<C> fromKey, boolean fromInclusive, Cut<C> toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.subMap(Range.range(var1_1, BoundType.forBoolean((boolean)var2_2), var3_3, BoundType.forBoolean(toInclusive)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> headMap(Cut<C> toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subMap(Range.upTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> tailMap(Cut<C> fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subMap(Range.downTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        @Override
        public final Comparator<? super Cut<C>> comparator() {
            return Ordering.natural();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> entryIterator() {
            void var1_1;
            void var2_2;
            Cut firstComplementRangeLowerBound;
            Collection positiveRanges = this.complementLowerBoundWindow.hasLowerBound() ? this.positiveRangesByUpperBound.tailMap(this.complementLowerBoundWindow.lowerEndpoint(), this.complementLowerBoundWindow.lowerBoundType() == BoundType.CLOSED).values() : this.positiveRangesByUpperBound.values();
            PeekingIterator positiveItr = Iterators.peekingIterator(positiveRanges.iterator());
            if (this.complementLowerBoundWindow.contains(Cut.belowAll()) && (!positiveItr.hasNext() || ((Range)positiveItr.peek()).lowerBound != Cut.belowAll())) {
                firstComplementRangeLowerBound = Cut.belowAll();
            } else if (positiveItr.hasNext()) {
                firstComplementRangeLowerBound = ((Range)positiveItr.next()).upperBound;
            } else {
                return Iterators.emptyIterator();
            }
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (Cut)var2_2, (PeekingIterator)var1_1){
                Cut<C> nextComplementRangeLowerBound;
                final /* synthetic */ Cut val$firstComplementRangeLowerBound;
                final /* synthetic */ PeekingIterator val$positiveItr;
                final /* synthetic */ ComplementRangesByLowerBound this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$firstComplementRangeLowerBound = cut;
                    this.val$positiveItr = peekingIterator;
                    this.nextComplementRangeLowerBound = this.val$firstComplementRangeLowerBound;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<Cut<C>, Range<C>> computeNext() {
                    void var1_2;
                    Range negativeRange;
                    if (((ComplementRangesByLowerBound)this.this$0).complementLowerBoundWindow.upperBound.isLessThan(this.nextComplementRangeLowerBound) || this.nextComplementRangeLowerBound == Cut.aboveAll()) {
                        return (Map.Entry)this.endOfData();
                    }
                    if (this.val$positiveItr.hasNext()) {
                        void var2_1;
                        Range positiveRange = (Range)this.val$positiveItr.next();
                        negativeRange = Range.create(this.nextComplementRangeLowerBound, positiveRange.lowerBound);
                        this.nextComplementRangeLowerBound = var2_1.upperBound;
                    } else {
                        negativeRange = Range.create(this.nextComplementRangeLowerBound, Cut.aboveAll());
                        this.nextComplementRangeLowerBound = Cut.aboveAll();
                    }
                    return Maps.immutableEntry(negativeRange.lowerBound, var1_2);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> descendingEntryIterator() {
            void var1_1;
            void var2_3;
            Cut cut;
            boolean inclusive;
            Cut startingPoint = this.complementLowerBoundWindow.hasUpperBound() ? this.complementLowerBoundWindow.upperEndpoint() : Cut.aboveAll();
            PeekingIterator positiveItr = Iterators.peekingIterator(this.positiveRangesByUpperBound.headMap(startingPoint, inclusive = this.complementLowerBoundWindow.hasUpperBound() && this.complementLowerBoundWindow.upperBoundType() == BoundType.CLOSED).descendingMap().values().iterator());
            if (positiveItr.hasNext()) {
                cut = ((Range)positiveItr.peek()).upperBound == Cut.aboveAll() ? ((Range)positiveItr.next()).lowerBound : this.positiveRangesByLowerBound.higherKey(((Range)positiveItr.peek()).upperBound);
            } else {
                if (!this.complementLowerBoundWindow.contains(Cut.belowAll()) || this.positiveRangesByLowerBound.containsKey(Cut.belowAll())) {
                    return Iterators.emptyIterator();
                }
                cut = this.positiveRangesByLowerBound.higherKey(Cut.belowAll());
            }
            Cut firstComplementRangeUpperBound = MoreObjects.firstNonNull(cut, Cut.aboveAll());
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (Cut)var2_3, (PeekingIterator)var1_1){
                Cut<C> nextComplementRangeUpperBound;
                final /* synthetic */ Cut val$firstComplementRangeUpperBound;
                final /* synthetic */ PeekingIterator val$positiveItr;
                final /* synthetic */ ComplementRangesByLowerBound this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$firstComplementRangeUpperBound = cut;
                    this.val$positiveItr = peekingIterator;
                    this.nextComplementRangeUpperBound = this.val$firstComplementRangeUpperBound;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<Cut<C>, Range<C>> computeNext() {
                    if (this.nextComplementRangeUpperBound == Cut.belowAll()) {
                        return (Map.Entry)this.endOfData();
                    }
                    if (this.val$positiveItr.hasNext()) {
                        Range positiveRange = (Range)this.val$positiveItr.next();
                        Range negativeRange = Range.create(positiveRange.upperBound, this.nextComplementRangeUpperBound);
                        this.nextComplementRangeUpperBound = positiveRange.lowerBound;
                        if (((ComplementRangesByLowerBound)this.this$0).complementLowerBoundWindow.lowerBound.isLessThan(negativeRange.lowerBound)) {
                            void var2_3;
                            return Maps.immutableEntry(negativeRange.lowerBound, var2_3);
                        }
                    } else if (((ComplementRangesByLowerBound)this.this$0).complementLowerBoundWindow.lowerBound.isLessThan(Cut.belowAll())) {
                        void var1_2;
                        Range negativeRange = Range.create(Cut.belowAll(), this.nextComplementRangeUpperBound);
                        this.nextComplementRangeUpperBound = Cut.belowAll();
                        return Maps.immutableEntry(Cut.belowAll(), var1_2);
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }

        @Override
        public final int size() {
            return Iterators.size(this.entryIterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Range<C> get(Object key) {
            if (key instanceof Cut) {
                try {
                    void var1_1;
                    Cut cut = (Cut)key;
                    Map.Entry<Cut<C>, Range<C>> firstEntry = this.tailMap(cut, true).firstEntry();
                    if (firstEntry != null && firstEntry.getKey().equals(var1_1)) {
                        void var2_2;
                        return (Range)var2_2.getValue();
                    }
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }
    }

    @VisibleForTesting
    static final class RangesByUpperBound<C extends Comparable<?>>
    extends AbstractNavigableMap<Cut<C>, Range<C>> {
        private final NavigableMap<Cut<C>, Range<C>> rangesByLowerBound;
        private final Range<Cut<C>> upperBoundWindow;

        /*
         * WARNING - void declaration
         */
        RangesByUpperBound(NavigableMap<Cut<C>, Range<C>> rangesByLowerBound) {
            void var1_1;
            this.rangesByLowerBound = var1_1;
            this.upperBoundWindow = Range.all();
        }

        /*
         * WARNING - void declaration
         */
        private RangesByUpperBound(NavigableMap<Cut<C>, Range<C>> rangesByLowerBound, Range<Cut<C>> upperBoundWindow) {
            void var2_2;
            void var1_1;
            this.rangesByLowerBound = var1_1;
            this.upperBoundWindow = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private NavigableMap<Cut<C>, Range<C>> subMap(Range<Cut<C>> window) {
            if (window.isConnected(this.upperBoundWindow)) {
                void var1_1;
                return new RangesByUpperBound<C>(this.rangesByLowerBound, var1_1.intersection(this.upperBoundWindow));
            }
            return ImmutableSortedMap.of();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> subMap(Cut<C> fromKey, boolean fromInclusive, Cut<C> toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.subMap(Range.range(var1_1, BoundType.forBoolean((boolean)var2_2), var3_3, BoundType.forBoolean(toInclusive)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> headMap(Cut<C> toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subMap(Range.upTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<Cut<C>, Range<C>> tailMap(Cut<C> fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subMap(Range.downTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        @Override
        public final Comparator<? super Cut<C>> comparator() {
            return Ordering.natural();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Range<C> get(Object key) {
            if (key instanceof Cut) {
                try {
                    void var1_1;
                    Cut cut = (Cut)key;
                    if (!this.upperBoundWindow.contains(cut)) {
                        return null;
                    }
                    Map.Entry<Cut, Range<C>> candidate = this.rangesByLowerBound.lowerEntry(cut);
                    if (candidate != null && candidate.getValue().upperBound.equals(var1_1)) {
                        void var2_2;
                        return (Range)var2_2.getValue();
                    }
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> entryIterator() {
            void var1_1;
            Iterator backingItr;
            Map.Entry<Cut<C>, Range<C>> lowerEntry;
            backingItr = !this.upperBoundWindow.hasLowerBound() ? this.rangesByLowerBound.values().iterator() : ((lowerEntry = this.rangesByLowerBound.lowerEntry(this.upperBoundWindow.lowerEndpoint())) == null ? this.rangesByLowerBound.values().iterator() : (this.upperBoundWindow.lowerBound.isLessThan(((Range)backingItr.getValue()).upperBound) ? this.rangesByLowerBound.tailMap((Cut)backingItr.getKey(), true).values().iterator() : this.rangesByLowerBound.tailMap(this.upperBoundWindow.lowerEndpoint(), true).values().iterator()));
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (Iterator)var1_1){
                final /* synthetic */ Iterator val$backingItr;
                final /* synthetic */ RangesByUpperBound this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$backingItr = iterator;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<Cut<C>, Range<C>> computeNext() {
                    void var1_1;
                    if (!this.val$backingItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    Range range = (Range)this.val$backingItr.next();
                    if (((RangesByUpperBound)this.this$0).upperBoundWindow.upperBound.isLessThan(range.upperBound)) {
                        return (Map.Entry)this.endOfData();
                    }
                    return Maps.immutableEntry(range.upperBound, var1_1);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Iterator<Map.Entry<Cut<C>, Range<C>>> descendingEntryIterator() {
            void var1_1;
            Collection candidates = this.upperBoundWindow.hasUpperBound() ? this.rangesByLowerBound.headMap(this.upperBoundWindow.upperEndpoint(), false).descendingMap().values() : this.rangesByLowerBound.descendingMap().values();
            PeekingIterator backingItr = Iterators.peekingIterator(candidates.iterator());
            if (backingItr.hasNext() && this.upperBoundWindow.upperBound.isLessThan(((Range)backingItr.peek()).upperBound)) {
                backingItr.next();
            }
            return new AbstractIterator<Map.Entry<Cut<C>, Range<C>>>(this, (PeekingIterator)var1_1){
                final /* synthetic */ PeekingIterator val$backingItr;
                final /* synthetic */ RangesByUpperBound this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$backingItr = peekingIterator;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Map.Entry<Cut<C>, Range<C>> computeNext() {
                    if (!this.val$backingItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    Range range = (Range)this.val$backingItr.next();
                    if (((RangesByUpperBound)this.this$0).upperBoundWindow.lowerBound.isLessThan(range.upperBound)) {
                        void var1_1;
                        return Maps.immutableEntry(range.upperBound, var1_1);
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }

        @Override
        public final int size() {
            if (this.upperBoundWindow.equals(Range.all())) {
                return this.rangesByLowerBound.size();
            }
            return Iterators.size(this.entryIterator());
        }

        @Override
        public final boolean isEmpty() {
            if (this.upperBoundWindow.equals(Range.all())) {
                return this.rangesByLowerBound.isEmpty();
            }
            return !this.entryIterator().hasNext();
        }
    }

    final class AsRanges
    extends ForwardingCollection<Range<C>>
    implements Set<Range<C>> {
        final Collection<Range<C>> delegate;

        /*
         * WARNING - void declaration
         */
        AsRanges(TreeRangeSet this$0, Collection<Range<C>> delegate) {
            void var2_2;
            this.delegate = var2_2;
        }

        @Override
        protected final Collection<Range<C>> delegate() {
            return this.delegate;
        }

        @Override
        public final int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object o) {
            void var1_1;
            return Sets.equalsImpl(this, var1_1);
        }
    }
}

