/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.Cut;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class TreeRangeMap<K extends Comparable, V>
implements RangeMap<K, V> {
    private final NavigableMap<Cut<K>, RangeMapEntry<K, V>> entriesByLowerBound = Maps.newTreeMap();
    private static final RangeMap<Comparable<?>, Object> EMPTY_SUB_RANGE_MAP = new RangeMap<Comparable<?>, Object>(){

        @Override
        public Object get(Comparable<?> key) {
            return null;
        }

        @Override
        public Map.Entry<Range<Comparable<?>>, Object> getEntry(Comparable<?> key) {
            return null;
        }

        @Override
        public Range<Comparable<?>> span() {
            throw new NoSuchElementException();
        }

        @Override
        public void put(Range<Comparable<?>> range, Object value) {
            String string;
            Preconditions.checkNotNull(range);
            string = String.valueOf(string);
            throw new IllegalArgumentException(new StringBuilder(46 + String.valueOf(string).length()).append("Cannot insert range ").append(string).append(" into an empty subRangeMap").toString());
        }

        @Override
        public void putCoalescing(Range<Comparable<?>> range, Object value) {
            String string;
            Preconditions.checkNotNull(range);
            string = String.valueOf(string);
            throw new IllegalArgumentException(new StringBuilder(46 + String.valueOf(string).length()).append("Cannot insert range ").append(string).append(" into an empty subRangeMap").toString());
        }

        @Override
        public void putAll(RangeMap<Comparable<?>, Object> rangeMap) {
            if (!rangeMap.asMapOfRanges().isEmpty()) {
                throw new IllegalArgumentException("Cannot putAll(nonEmptyRangeMap) into an empty subRangeMap");
            }
        }

        @Override
        public void clear() {
        }

        @Override
        public void remove(Range<Comparable<?>> range) {
            Preconditions.checkNotNull(range);
        }

        @Override
        public void merge(Range<Comparable<?>> range, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
            String string;
            Preconditions.checkNotNull(range);
            string = String.valueOf(string);
            throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string).length()).append("Cannot merge range ").append(string).append(" into an empty subRangeMap").toString());
        }

        @Override
        public Map<Range<Comparable<?>>, Object> asMapOfRanges() {
            return Collections.emptyMap();
        }

        @Override
        public Map<Range<Comparable<?>>, Object> asDescendingMapOfRanges() {
            return Collections.emptyMap();
        }

        @Override
        public RangeMap<Comparable<?>, Object> subRangeMap(Range<Comparable<?>> range) {
            Preconditions.checkNotNull(range);
            return this;
        }
    };

    public static <K extends Comparable, V> TreeRangeMap<K, V> create() {
        return new TreeRangeMap<K, V>();
    }

    private TreeRangeMap() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(K key) {
        void var1_1;
        Map.Entry<Range<K>, V> entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return var1_1.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<Range<K>, V> getEntry(K key) {
        void var1_1;
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> mapEntry = this.entriesByLowerBound.floorEntry(Cut.belowValue(key));
        if (mapEntry != null && mapEntry.getValue().contains(var1_1)) {
            void var2_2;
            return (Map.Entry)var2_2.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void put(Range<K> range, V value) {
        if (!range.isEmpty()) {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(value);
            this.remove(range);
            this.entriesByLowerBound.put(range.lowerBound, new RangeMapEntry(var1_1, var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void putCoalescing(Range<K> range, V value) {
        void var2_2;
        void var1_1;
        if (this.entriesByLowerBound.isEmpty()) {
            this.put(range, value);
            return;
        }
        Range<K> coalescedRange = this.coalescedRange(range, Preconditions.checkNotNull(value));
        this.put((Range<K>)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Range<K> coalescedRange(Range<K> range, V value) {
        void var1_1;
        void var2_2;
        Range<K> range2;
        Range<K> coalescedRange = range;
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> lowerEntry = this.entriesByLowerBound.lowerEntry(range.lowerBound);
        coalescedRange = TreeRangeMap.coalesce(coalescedRange, value, lowerEntry);
        Map.Entry higherEntry = this.entriesByLowerBound.floorEntry(range.upperBound);
        range2 = TreeRangeMap.coalesce(range2, var2_2, var1_1);
        return range2;
    }

    /*
     * WARNING - void declaration
     */
    private static <K extends Comparable, V> Range<K> coalesce(Range<K> range, V value, Map.Entry<Cut<K>, RangeMapEntry<K, V>> entry) {
        Range<K> range2;
        void var1_1;
        if (entry != null && ((Range)entry.getValue().getKey()).isConnected(range) && entry.getValue().getValue().equals(var1_1)) {
            void var2_2;
            return range.span((Range<K>)((RangeMapEntry)var2_2.getValue()).getKey());
        }
        return range2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void putAll(RangeMap<K, V> rangeMap) {
        for (Map.Entry<Range<K>, V> entry : rangeMap.asMapOfRanges().entrySet()) {
            void var2_2;
            this.put(entry.getKey(), var2_2.getValue());
        }
    }

    @Override
    public final void clear() {
        this.entriesByLowerBound.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range<K> span() {
        void var2_2;
        void var1_1;
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> firstEntry = this.entriesByLowerBound.firstEntry();
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> lastEntry = this.entriesByLowerBound.lastEntry();
        if (firstEntry == null || lastEntry == null) {
            throw new NoSuchElementException();
        }
        return Range.create(((Range)((RangeMapEntry)var1_1.getValue()).getKey()).lowerBound, ((Range)((RangeMapEntry)var2_2.getValue()).getKey()).upperBound);
    }

    /*
     * WARNING - void declaration
     */
    private void putRangeMapEntry(Cut<K> lowerBound, Cut<K> upperBound, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.entriesByLowerBound.put(lowerBound, new RangeMapEntry(var1_1, var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void remove(Range<K> rangeToRemove) {
        void var1_1;
        RangeMapEntry<K, V> rangeMapEntry;
        Map.Entry mapEntryAboveToTruncate;
        RangeMapEntry<K, V> rangeMapEntry2;
        if (rangeToRemove.isEmpty()) {
            return;
        }
        Map.Entry mapEntryBelowToTruncate = this.entriesByLowerBound.lowerEntry(rangeToRemove.lowerBound);
        if (mapEntryBelowToTruncate != null && (rangeMapEntry2 = mapEntryBelowToTruncate.getValue()).getUpperBound().compareTo(rangeToRemove.lowerBound) > 0) {
            if (rangeMapEntry2.getUpperBound().compareTo(rangeToRemove.upperBound) > 0) {
                this.putRangeMapEntry(rangeToRemove.upperBound, rangeMapEntry2.getUpperBound(), mapEntryBelowToTruncate.getValue().getValue());
            }
            this.putRangeMapEntry(rangeMapEntry2.getLowerBound(), rangeToRemove.lowerBound, mapEntryBelowToTruncate.getValue().getValue());
        }
        if ((mapEntryAboveToTruncate = this.entriesByLowerBound.lowerEntry(rangeToRemove.upperBound)) != null && (rangeMapEntry = mapEntryAboveToTruncate.getValue()).getUpperBound().compareTo(rangeToRemove.upperBound) > 0) {
            void var3_3;
            void var2_2;
            this.putRangeMapEntry(rangeToRemove.upperBound, var2_2.getUpperBound(), ((RangeMapEntry)var3_3.getValue()).getValue());
        }
        this.entriesByLowerBound.subMap(rangeToRemove.lowerBound, var1_1.upperBound).clear();
    }

    /*
     * WARNING - void declaration
     */
    private void split(Cut<K> cut) {
        void var2_2;
        void var1_1;
        Map.Entry<Cut<K>, RangeMapEntry<K, V>> mapEntryToSplit = this.entriesByLowerBound.lowerEntry(cut);
        if (mapEntryToSplit == null) {
            return;
        }
        RangeMapEntry<K, V> rangeMapEntry = mapEntryToSplit.getValue();
        if (rangeMapEntry.getUpperBound().compareTo(cut) <= 0) {
            return;
        }
        this.putRangeMapEntry(rangeMapEntry.getLowerBound(), cut, rangeMapEntry.getValue());
        this.putRangeMapEntry((Cut<K>)var1_1, rangeMapEntry.getUpperBound(), var2_2.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void merge(Range<K> range, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Iterator backingItr;
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(remappingFunction);
        if (range.isEmpty()) {
            return;
        }
        this.split(range.lowerBound);
        this.split(range.upperBound);
        Set entriesInMergeRange = this.entriesByLowerBound.subMap(range.lowerBound, range.upperBound).entrySet();
        ImmutableMap.Builder gaps = ImmutableMap.builder();
        if (value != null) {
            backingItr = entriesInMergeRange.iterator();
            Cut<Object> lowerBound = range.lowerBound;
            while (backingItr.hasNext()) {
                RangeMapEntry<K, V> entry = backingItr.next().getValue();
                Cut<K> upperBound = entry.getLowerBound();
                if (!lowerBound.equals(upperBound)) {
                    gaps.put(lowerBound, new RangeMapEntry(lowerBound, upperBound, value));
                }
                lowerBound = entry.getUpperBound();
            }
            if (!lowerBound.equals(range.upperBound)) {
                void var1_1;
                gaps.put(lowerBound, new RangeMapEntry(lowerBound, var1_1.upperBound, value));
            }
        }
        backingItr = entriesInMergeRange.iterator();
        while (backingItr.hasNext()) {
            Map.Entry entry = backingItr.next();
            V newValue = remappingFunction.apply(entry.getValue().getValue(), value);
            if (newValue == null) {
                backingItr.remove();
                continue;
            }
            entry.setValue(new RangeMapEntry<K, V>(entry.getValue().getLowerBound(), entry.getValue().getUpperBound(), newValue));
        }
        this.entriesByLowerBound.putAll(gaps.build());
    }

    @Override
    public final Map<Range<K>, V> asMapOfRanges() {
        TreeRangeMap treeRangeMap = this;
        return treeRangeMap.new AsMapOfRanges(treeRangeMap.entriesByLowerBound.values());
    }

    @Override
    public final Map<Range<K>, V> asDescendingMapOfRanges() {
        TreeRangeMap treeRangeMap = this;
        return treeRangeMap.new AsMapOfRanges(treeRangeMap.entriesByLowerBound.descendingMap().values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final RangeMap<K, V> subRangeMap(Range<K> subRange) {
        void var1_1;
        if (subRange.equals(Range.all())) {
            return this;
        }
        return new SubRangeMap(var1_1);
    }

    private RangeMap<K, V> emptySubRangeMap() {
        return EMPTY_SUB_RANGE_MAP;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object o) {
        if (o instanceof RangeMap) {
            void var1_1;
            RangeMap rangeMap = (RangeMap)o;
            return this.asMapOfRanges().equals(var1_1.asMapOfRanges());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.asMapOfRanges().hashCode();
    }

    @Override
    public final String toString() {
        return this.entriesByLowerBound.values().toString();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Range access$100(TreeRangeMap x0, Range x1, Object x2) {
        void var2_2;
        void var1_1;
        return x0.coalescedRange((Range)var1_1, var2_2);
    }

    private class SubRangeMap
    implements RangeMap<K, V> {
        private final Range<K> subRange;

        /*
         * WARNING - void declaration
         */
        SubRangeMap(Range<K> subRange) {
            void var2_2;
            this.subRange = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(K key) {
            if (this.subRange.contains(key)) {
                void var1_1;
                return TreeRangeMap.this.get(var1_1);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<Range<K>, V> getEntry(K key) {
            Map.Entry entry;
            if (this.subRange.contains(key) && (entry = TreeRangeMap.this.getEntry(key)) != null) {
                void var1_1;
                return Maps.immutableEntry(entry.getKey().intersection(this.subRange), var1_1.getValue());
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Range<K> span() {
            void var2_2;
            void var1_1;
            Cut<Object> upperBound;
            Cut lowerBound;
            Map.Entry lowerEntry = TreeRangeMap.this.entriesByLowerBound.floorEntry(this.subRange.lowerBound);
            if (lowerEntry != null && ((RangeMapEntry)lowerEntry.getValue()).getUpperBound().compareTo(this.subRange.lowerBound) > 0) {
                lowerBound = this.subRange.lowerBound;
            } else {
                lowerBound = TreeRangeMap.this.entriesByLowerBound.ceilingKey(this.subRange.lowerBound);
                if (lowerBound == null || lowerBound.compareTo(this.subRange.upperBound) >= 0) {
                    throw new NoSuchElementException();
                }
            }
            Map.Entry upperEntry = TreeRangeMap.this.entriesByLowerBound.lowerEntry(this.subRange.upperBound);
            if (upperEntry == null) {
                throw new NoSuchElementException();
            }
            upperBound = ((RangeMapEntry)upperEntry.getValue()).getUpperBound().compareTo(this.subRange.upperBound) >= 0 ? this.subRange.upperBound : ((RangeMapEntry)upperBound.getValue()).getUpperBound();
            return Range.create(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void put(Range<K> range, V value) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(this.subRange.encloses(range), "Cannot put range %s into a subRangeMap(%s)", range, this.subRange);
            TreeRangeMap.this.put(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putCoalescing(Range<K> range, V value) {
            void var2_2;
            void var1_1;
            if (TreeRangeMap.this.entriesByLowerBound.isEmpty() || !this.subRange.encloses(range)) {
                this.put(range, value);
                return;
            }
            Range coalescedRange = TreeRangeMap.access$100(TreeRangeMap.this, range, Preconditions.checkNotNull(value));
            this.put(var1_1.intersection(this.subRange), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(RangeMap<K, V> rangeMap) {
            void var1_1;
            void var2_2;
            if (rangeMap.asMapOfRanges().isEmpty()) {
                return;
            }
            Range span = rangeMap.span();
            Preconditions.checkArgument(this.subRange.encloses(span), "Cannot putAll rangeMap with span %s into a subRangeMap(%s)", (Object)var2_2, this.subRange);
            TreeRangeMap.this.putAll(var1_1);
        }

        @Override
        public void clear() {
            TreeRangeMap.this.remove(this.subRange);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void remove(Range<K> range) {
            if (range.isConnected(this.subRange)) {
                void var1_1;
                TreeRangeMap.this.remove(var1_1.intersection(this.subRange));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void merge(Range<K> range, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            void var3_3;
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(this.subRange.encloses(range), "Cannot merge range %s into a subRangeMap(%s)", range, this.subRange);
            TreeRangeMap.this.merge(var1_1, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RangeMap<K, V> subRangeMap(Range<K> range) {
            void var1_1;
            if (!range.isConnected(this.subRange)) {
                return TreeRangeMap.this.emptySubRangeMap();
            }
            return TreeRangeMap.this.subRangeMap(var1_1.intersection(this.subRange));
        }

        @Override
        public Map<Range<K>, V> asMapOfRanges() {
            return new SubRangeMapAsMap(this);
        }

        @Override
        public Map<Range<K>, V> asDescendingMapOfRanges() {
            return new SubRangeMapAsMap(){
                {
                    void var1_1;
                    super((SubRangeMap)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                Iterator<Map.Entry<Range<K>, V>> entryIterator() {
                    void var1_1;
                    if (SubRangeMap.this.subRange.isEmpty()) {
                        return Iterators.emptyIterator();
                    }
                    Iterator backingItr = TreeRangeMap.this.entriesByLowerBound.headMap(((SubRangeMap)SubRangeMap.this).subRange.upperBound, false).descendingMap().values().iterator();
                    return new AbstractIterator<Map.Entry<Range<K>, V>>(this, (Iterator)var1_1){
                        final /* synthetic */ Iterator val$backingItr;
                        final /* synthetic */ 1 this$2;
                        {
                            void var1_1;
                            this.this$2 = var1_1;
                            this.val$backingItr = iterator;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        protected Map.Entry<Range<K>, V> computeNext() {
                            if (this.val$backingItr.hasNext()) {
                                void var1_1;
                                RangeMapEntry entry = (RangeMapEntry)this.val$backingItr.next();
                                if (entry.getUpperBound().compareTo(((SubRangeMap)this.this$2.SubRangeMap.this).subRange.lowerBound) <= 0) {
                                    return (Map.Entry)this.endOfData();
                                }
                                return Maps.immutableEntry(((Range)entry.getKey()).intersection(this.this$2.SubRangeMap.this.subRange), var1_1.getValue());
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o instanceof RangeMap) {
                void var1_1;
                RangeMap rangeMap = (RangeMap)o;
                return this.asMapOfRanges().equals(var1_1.asMapOfRanges());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.asMapOfRanges().hashCode();
        }

        @Override
        public String toString() {
            return this.asMapOfRanges().toString();
        }

        class SubRangeMapAsMap
        extends AbstractMap<Range<K>, V> {
            final /* synthetic */ SubRangeMap this$1;

            /*
             * WARNING - void declaration
             */
            SubRangeMapAsMap(SubRangeMap this$1) {
                void var1_1;
                this.this$1 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean containsKey(Object key) {
                void var1_1;
                return this.get(var1_1) != null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public V get(Object key) {
                try {
                    if (key instanceof Range) {
                        void var1_1;
                        Range r = (Range)key;
                        if (!this.this$1.subRange.encloses(r) || r.isEmpty()) {
                            return null;
                        }
                        RangeMapEntry candidate = null;
                        if (r.lowerBound.compareTo(((SubRangeMap)this.this$1).subRange.lowerBound) == 0) {
                            Map.Entry entry = this.this$1.TreeRangeMap.this.entriesByLowerBound.floorEntry(r.lowerBound);
                            if (entry != null) {
                                void var3_3;
                                candidate = (RangeMapEntry)var3_3.getValue();
                            }
                        } else {
                            candidate = (RangeMapEntry)this.this$1.TreeRangeMap.this.entriesByLowerBound.get(r.lowerBound);
                        }
                        if (candidate != null && ((Range)candidate.getKey()).isConnected(this.this$1.subRange) && ((Range)candidate.getKey()).intersection(this.this$1.subRange).equals(var1_1)) {
                            void var2_2;
                            return var2_2.getValue();
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public V remove(Object key) {
                Object value = this.get(key);
                if (value != null) {
                    void var2_2;
                    void var1_1;
                    Range range = (Range)Objects.requireNonNull(key);
                    this.this$1.TreeRangeMap.this.remove(var1_1);
                    return var2_2;
                }
                return null;
            }

            @Override
            public void clear() {
                this.this$1.clear();
            }

            /*
             * WARNING - void declaration
             */
            private boolean removeEntryIf(Predicate<? super Map.Entry<Range<K>, V>> predicate) {
                void var2_2;
                ArrayList toRemove = Lists.newArrayList();
                for (Map.Entry entry : this.entrySet()) {
                    if (!predicate.apply(entry)) continue;
                    toRemove.add(entry.getKey());
                }
                for (Range range : toRemove) {
                    this.this$1.TreeRangeMap.this.remove(range);
                }
                return !var2_2.isEmpty();
            }

            @Override
            public Set<Range<K>> keySet() {
                SubRangeMapAsMap subRangeMapAsMap = this;
                return new Maps.KeySet<Range<K>, V>(subRangeMapAsMap, subRangeMapAsMap){
                    final /* synthetic */ SubRangeMapAsMap this$2;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$2 = var1_1;
                        super(var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean remove(Object o) {
                        void var1_1;
                        return this.this$2.remove(var1_1) != null;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean retainAll(Collection<?> c) {
                        void var1_1;
                        return SubRangeMapAsMap.access$400(this.this$2, Predicates.compose(Predicates.not(Predicates.in(var1_1)), Maps.keyFunction()));
                    }
                };
            }

            @Override
            public Set<Map.Entry<Range<K>, V>> entrySet() {
                return new Maps.EntrySet<Range<K>, V>(this){
                    final /* synthetic */ SubRangeMapAsMap this$2;
                    {
                        void var1_1;
                        this.this$2 = var1_1;
                    }

                    @Override
                    Map<Range<K>, V> map() {
                        return this.this$2;
                    }

                    @Override
                    public Iterator<Map.Entry<Range<K>, V>> iterator() {
                        return this.this$2.entryIterator();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean retainAll(Collection<?> c) {
                        void var1_1;
                        return SubRangeMapAsMap.access$400(this.this$2, Predicates.not(Predicates.in(var1_1)));
                    }

                    @Override
                    public int size() {
                        return Iterators.size(this.iterator());
                    }

                    @Override
                    public boolean isEmpty() {
                        return !this.iterator().hasNext();
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            Iterator<Map.Entry<Range<K>, V>> entryIterator() {
                void var1_1;
                if (this.this$1.subRange.isEmpty()) {
                    return Iterators.emptyIterator();
                }
                Cut cutToStart = MoreObjects.firstNonNull(this.this$1.TreeRangeMap.this.entriesByLowerBound.floorKey(((SubRangeMap)this.this$1).subRange.lowerBound), ((SubRangeMap)this.this$1).subRange.lowerBound);
                Iterator backingItr = this.this$1.TreeRangeMap.this.entriesByLowerBound.tailMap(cutToStart, true).values().iterator();
                return new AbstractIterator<Map.Entry<Range<K>, V>>(this, (Iterator)var1_1){
                    final /* synthetic */ Iterator val$backingItr;
                    final /* synthetic */ SubRangeMapAsMap this$2;
                    {
                        void var1_1;
                        this.this$2 = var1_1;
                        this.val$backingItr = iterator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Map.Entry<Range<K>, V> computeNext() {
                        while (this.val$backingItr.hasNext()) {
                            void var1_1;
                            RangeMapEntry entry = (RangeMapEntry)this.val$backingItr.next();
                            if (entry.getLowerBound().compareTo(((SubRangeMap)this.this$2.this$1).subRange.upperBound) >= 0) {
                                return (Map.Entry)this.endOfData();
                            }
                            if (entry.getUpperBound().compareTo(((SubRangeMap)this.this$2.this$1).subRange.lowerBound) <= 0) continue;
                            return Maps.immutableEntry(((Range)entry.getKey()).intersection(this.this$2.this$1.subRange), var1_1.getValue());
                        }
                        return (Map.Entry)this.endOfData();
                    }
                };
            }

            @Override
            public Collection<V> values() {
                SubRangeMapAsMap subRangeMapAsMap = this;
                return new Maps.Values<Range<K>, V>(subRangeMapAsMap, subRangeMapAsMap){
                    final /* synthetic */ SubRangeMapAsMap this$2;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$2 = var1_1;
                        super(var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean removeAll(Collection<?> c) {
                        void var1_1;
                        return SubRangeMapAsMap.access$400(this.this$2, Predicates.compose(Predicates.in(var1_1), Maps.valueFunction()));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public boolean retainAll(Collection<?> c) {
                        void var1_1;
                        return SubRangeMapAsMap.access$400(this.this$2, Predicates.compose(Predicates.not(Predicates.in(var1_1)), Maps.valueFunction()));
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ boolean access$400(SubRangeMapAsMap x0, Predicate x1) {
                void var1_1;
                return x0.removeEntryIf((Predicate)var1_1);
            }
        }
    }

    private final class AsMapOfRanges
    extends Maps.IteratorBasedAbstractMap<Range<K>, V> {
        final Iterable<Map.Entry<Range<K>, V>> entryIterable;

        /*
         * WARNING - void declaration
         */
        AsMapOfRanges(Iterable<RangeMapEntry<K, V>> entryIterable) {
            void var2_2;
            this.entryIterable = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object key) {
            if (key instanceof Range) {
                void var1_1;
                Range range = (Range)key;
                RangeMapEntry rangeMapEntry = (RangeMapEntry)TreeRangeMap.this.entriesByLowerBound.get(range.lowerBound);
                if (rangeMapEntry != null && ((Range)rangeMapEntry.getKey()).equals(var1_1)) {
                    void var2_2;
                    return var2_2.getValue();
                }
            }
            return null;
        }

        @Override
        public final int size() {
            return TreeRangeMap.this.entriesByLowerBound.size();
        }

        @Override
        final Iterator<Map.Entry<Range<K>, V>> entryIterator() {
            return this.entryIterable.iterator();
        }
    }

    private static final class RangeMapEntry<K extends Comparable, V>
    extends AbstractMapEntry<Range<K>, V> {
        private final Range<K> range;
        private final V value;

        /*
         * WARNING - void declaration
         */
        RangeMapEntry(Cut<K> lowerBound, Cut<K> upperBound, V value) {
            this(Range.create(var1_1, var2_2), var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        RangeMapEntry(Range<K> range, V value) {
            void var2_2;
            void var1_1;
            this.range = var1_1;
            this.value = var2_2;
        }

        @Override
        public final Range<K> getKey() {
            return this.range;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean contains(K value) {
            void var1_1;
            return this.range.contains(var1_1);
        }

        final Cut<K> getLowerBound() {
            return this.range.lowerBound;
        }

        final Cut<K> getUpperBound() {
            return this.range.upperBound;
        }
    }
}

