/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSortedMultiset;
import com.google.common.collect.BoundType;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.GeneralRange;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Serialization;
import com.google.common.collect.SortedMultiset;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.ObjIntConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class TreeMultiset<E>
extends AbstractSortedMultiset<E>
implements Serializable {
    private final transient Reference<AvlNode<E>> rootReference;
    private final transient GeneralRange<E> range;
    private final transient AvlNode<E> header;
    @GwtIncompatible
    private static final long serialVersionUID = 1L;

    public static <E extends Comparable> TreeMultiset<E> create() {
        return new TreeMultiset(Ordering.natural());
    }

    public static <E> TreeMultiset<E> create(Comparator<? super E> comparator) {
        Comparator<? super E> comparator2;
        if (comparator == null) {
            return new TreeMultiset(Ordering.natural());
        }
        return new TreeMultiset<E>(comparator2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable> TreeMultiset<E> create(Iterable<? extends E> elements) {
        void var1_1;
        Iterable<? extends E> iterable;
        TreeMultiset<E> multiset = TreeMultiset.create();
        Iterables.addAll(multiset, iterable);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    TreeMultiset(Reference<AvlNode<E>> rootReference, GeneralRange<E> range, AvlNode<E> endLink) {
        super(range.comparator());
        void var3_3;
        void var2_2;
        void var1_1;
        this.rootReference = var1_1;
        this.range = var2_2;
        this.header = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    TreeMultiset(Comparator<? super E> comparator) {
        super(comparator);
        void var1_1;
        this.range = GeneralRange.all(var1_1);
        this.header = new AvlNode();
        TreeMultiset.successor(this.header, this.header);
        this.rootReference = new Reference();
    }

    /*
     * WARNING - void declaration
     */
    private long aggregateForEntries(Aggregate aggr) {
        void var3_3;
        AvlNode<E> root = this.rootReference.get();
        long total = aggr.treeAggregate(root);
        if (this.range.hasLowerBound()) {
            total -= this.aggregateBelowRange(aggr, root);
        }
        if (this.range.hasUpperBound()) {
            void var2_2;
            void var1_1;
            total -= this.aggregateAboveRange((Aggregate)var1_1, (AvlNode<E>)var2_2);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private long aggregateBelowRange(Aggregate aggr, AvlNode<E> node) {
        void var2_2;
        void var1_1;
        void var3_3;
        while (true) {
            if (node == null) {
                return 0L;
            }
            int cmp = this.comparator().compare(NullnessCasts.uncheckedCastNullableTToT(this.range.getLowerEndpoint()), node.getElement());
            if (cmp >= 0) break;
            node = node.left;
        }
        if (var3_3 == false) {
            switch (this.range.getLowerBoundType()) {
                case OPEN: {
                    return (long)aggr.nodeAggregate(node) + aggr.treeAggregate(node.left);
                }
                case CLOSED: {
                    return aggr.treeAggregate(node.left);
                }
            }
            throw new AssertionError();
        }
        return aggr.treeAggregate(node.left) + (long)aggr.nodeAggregate(node) + this.aggregateBelowRange((Aggregate)var1_1, ((AvlNode)var2_2).right);
    }

    /*
     * WARNING - void declaration
     */
    private long aggregateAboveRange(Aggregate aggr, AvlNode<E> node) {
        void var2_2;
        void var1_1;
        void var3_3;
        while (true) {
            if (node == null) {
                return 0L;
            }
            int cmp = this.comparator().compare(NullnessCasts.uncheckedCastNullableTToT(this.range.getUpperEndpoint()), node.getElement());
            if (cmp <= 0) break;
            node = node.right;
        }
        if (var3_3 == false) {
            switch (this.range.getUpperBoundType()) {
                case OPEN: {
                    return (long)aggr.nodeAggregate(node) + aggr.treeAggregate(node.right);
                }
                case CLOSED: {
                    return aggr.treeAggregate(node.right);
                }
            }
            throw new AssertionError();
        }
        return aggr.treeAggregate(node.right) + (long)aggr.nodeAggregate(node) + this.aggregateAboveRange((Aggregate)var1_1, ((AvlNode)var2_2).left);
    }

    @Override
    public final int size() {
        return Ints.saturatedCast(this.aggregateForEntries(Aggregate.SIZE));
    }

    @Override
    final int distinctElements() {
        return Ints.saturatedCast(this.aggregateForEntries(Aggregate.DISTINCT));
    }

    static int distinctElements(AvlNode<?> node) {
        AvlNode<?> avlNode;
        if (node == null) {
            return 0;
        }
        return ((AvlNode)avlNode).distinctElements;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int count(Object element) {
        try {
            void var1_1;
            void var2_2;
            Object e = element;
            AvlNode<E> root = this.rootReference.get();
            if (!this.range.contains(e) || root == null) {
                return 0;
            }
            return var2_2.count(this.comparator(), var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int add(@ParametricNullness E element, int occurrences) {
        void var1_1;
        void var3_3;
        void var2_2;
        CollectPreconditions.checkNonnegative(occurrences, "occurrences");
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(this.range.contains(element));
        AvlNode<E> root = this.rootReference.get();
        if (root == null) {
            E e = element;
            this.comparator().compare(e, e);
            AvlNode<E> newRoot = new AvlNode<E>(element, occurrences);
            TreeMultiset.successor(this.header, newRoot, this.header);
            this.rootReference.checkAndSet(root, newRoot);
            return 0;
        }
        int[] result = new int[1];
        AvlNode<E> newRoot = root.add(this.comparator(), element, (int)var2_2, result);
        this.rootReference.checkAndSet((AvlNode<E>)var3_3, (AvlNode<E>)var1_1);
        return result[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int remove(Object element, int occurrences) {
        void var1_1;
        void var3_3;
        CollectPreconditions.checkNonnegative(occurrences, "occurrences");
        if (occurrences == 0) {
            return this.count(element);
        }
        AvlNode<void> root = this.rootReference.get();
        int[] result = new int[1];
        try {
            void var2_2;
            void e;
            if (!this.range.contains(e) || root == null) {
                return 0;
            }
            AvlNode<void> newRoot = root.remove(this.comparator(), e, (int)var2_2, result);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return 0;
        }
        this.rootReference.checkAndSet((AvlNode<E>)var3_3, (AvlNode<E>)var1_1);
        return result[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setCount(@ParametricNullness E element, int count) {
        void var1_1;
        void var3_3;
        void var2_2;
        CollectPreconditions.checkNonnegative(count, "count");
        if (!this.range.contains(element)) {
            Preconditions.checkArgument(count == 0);
            return 0;
        }
        AvlNode<E> root = this.rootReference.get();
        if (root == null) {
            if (count > 0) {
                this.add(element, count);
            }
            return 0;
        }
        int[] result = new int[1];
        AvlNode<E> newRoot = root.setCount(this.comparator(), element, (int)var2_2, result);
        this.rootReference.checkAndSet((AvlNode<E>)var3_3, (AvlNode<E>)var1_1);
        return result[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean setCount(@ParametricNullness E element, int oldCount, int newCount) {
        void var2_2;
        void var1_1;
        void var3_3;
        CollectPreconditions.checkNonnegative(newCount, "newCount");
        CollectPreconditions.checkNonnegative(oldCount, "oldCount");
        Preconditions.checkArgument(this.range.contains(element));
        AvlNode<E> root = this.rootReference.get();
        if (root == null) {
            if (oldCount == 0) {
                if (newCount > 0) {
                    this.add(element, newCount);
                }
                return true;
            }
            return false;
        }
        int[] result = new int[1];
        AvlNode<E> newRoot = root.setCount(this.comparator(), element, oldCount, (int)var3_3, result);
        this.rootReference.checkAndSet(root, (AvlNode<E>)var1_1);
        return result[0] == var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clear() {
        if (!this.range.hasLowerBound() && !this.range.hasUpperBound()) {
            AvlNode current = ((AvlNode)this.header).succ();
            while (current != this.header) {
                void var2_2;
                AvlNode next = current.succ();
                AvlNode.access$202(current, 0);
                AvlNode.access$502(current, null);
                AvlNode.access$602(current, null);
                AvlNode.access$802(current, null);
                AvlNode.access$902(current, null);
                current = var2_2;
            }
            TreeMultiset.successor(this.header, this.header);
            this.rootReference.clear();
            return;
        }
        Iterators.clear(this.entryIterator());
    }

    /*
     * WARNING - void declaration
     */
    private Multiset.Entry<E> wrapEntry(AvlNode<E> baseEntry) {
        void var1_1;
        return new Multisets.AbstractEntry<E>(this, (AvlNode)var1_1){
            final /* synthetic */ AvlNode val$baseEntry;
            final /* synthetic */ TreeMultiset this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$baseEntry = avlNode;
            }

            @Override
            @ParametricNullness
            public E getElement() {
                return this.val$baseEntry.getElement();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int getCount() {
                void var1_1;
                int result = this.val$baseEntry.getCount();
                if (result == 0) {
                    return this.this$0.count(this.getElement());
                }
                return (int)var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private AvlNode<E> firstNode() {
        void var1_1;
        AvlNode node;
        AvlNode<E> root = this.rootReference.get();
        if (root == null) {
            return null;
        }
        if (this.range.hasLowerBound()) {
            void var2_2;
            E endpoint = NullnessCasts.uncheckedCastNullableTToT(this.range.getLowerEndpoint());
            node = AvlNode.access$1000(root, this.comparator(), endpoint);
            if (node == null) {
                return null;
            }
            if (this.range.getLowerBoundType() == BoundType.OPEN && this.comparator().compare(var2_2, node.getElement()) == 0) {
                node = node.succ();
            }
        } else {
            node = ((AvlNode)this.header).succ();
        }
        if (node == this.header || !this.range.contains(node.getElement())) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private AvlNode<E> lastNode() {
        void var1_1;
        AvlNode node;
        AvlNode<E> root = this.rootReference.get();
        if (root == null) {
            return null;
        }
        if (this.range.hasUpperBound()) {
            void var2_2;
            E endpoint = NullnessCasts.uncheckedCastNullableTToT(this.range.getUpperEndpoint());
            node = AvlNode.access$1100(root, this.comparator(), endpoint);
            if (node == null) {
                return null;
            }
            if (this.range.getUpperBoundType() == BoundType.OPEN && this.comparator().compare(var2_2, node.getElement()) == 0) {
                node = node.pred();
            }
        } else {
            node = ((AvlNode)this.header).pred();
        }
        if (node == this.header || !this.range.contains(node.getElement())) {
            return null;
        }
        return var1_1;
    }

    @Override
    final Iterator<E> elementIterator() {
        return Multisets.elementIterator(this.entryIterator());
    }

    @Override
    final Iterator<Multiset.Entry<E>> entryIterator() {
        return new Iterator<Multiset.Entry<E>>(this){
            AvlNode<E> current;
            Multiset.Entry<E> prevEntry;
            final /* synthetic */ TreeMultiset this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.current = this.this$0.firstNode();
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return false;
                }
                if (this.this$0.range.tooHigh(this.current.getElement())) {
                    this.current = null;
                    return false;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Multiset.Entry<E> next() {
                void var1_1;
                Multiset.Entry result;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.prevEntry = result = TreeMultiset.access$1500(this.this$0, Objects.requireNonNull(this.current));
                this.current = this.current.succ() == this.this$0.header ? null : this.current.succ();
                return var1_1;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.prevEntry != null, "no calls to next() since the last call to remove()");
                this.this$0.setCount(this.prevEntry.getElement(), 0);
                this.prevEntry = null;
            }
        };
    }

    @Override
    final Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        return new Iterator<Multiset.Entry<E>>(this){
            AvlNode<E> current;
            Multiset.Entry<E> prevEntry;
            final /* synthetic */ TreeMultiset this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.current = this.this$0.lastNode();
                this.prevEntry = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return false;
                }
                if (this.this$0.range.tooLow(this.current.getElement())) {
                    this.current = null;
                    return false;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Multiset.Entry<E> next() {
                void var1_1;
                Multiset.Entry result;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Objects.requireNonNull(this.current);
                this.prevEntry = result = TreeMultiset.access$1500(this.this$0, this.current);
                this.current = this.current.pred() == this.this$0.header ? null : this.current.pred();
                return var1_1;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.prevEntry != null, "no calls to next() since the last call to remove()");
                this.this$0.setCount(this.prevEntry.getElement(), 0);
                this.prevEntry = null;
            }
        };
    }

    @Override
    public final void forEachEntry(ObjIntConsumer<? super E> action) {
        Preconditions.checkNotNull(action);
        AvlNode node = this.firstNode();
        while (node != this.header && node != null && !this.range.tooHigh(node.getElement())) {
            action.accept(node.getElement(), node.getCount());
            node = node.succ();
        }
    }

    @Override
    public final Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> headMultiset(@ParametricNullness E upperBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        return new TreeMultiset<void>(this.rootReference, this.range.intersect(GeneralRange.upTo(this.comparator(), var1_1, (BoundType)var2_2)), this.header);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> tailMultiset(@ParametricNullness E lowerBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        return new TreeMultiset<void>(this.rootReference, this.range.intersect(GeneralRange.downTo(this.comparator(), var1_1, (BoundType)var2_2)), this.header);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> void successor(AvlNode<T> a, AvlNode<T> b) {
        AvlNode<T> avlNode;
        void var1_1;
        AvlNode.access$902(a, b);
        AvlNode.access$802((AvlNode)var1_1, avlNode);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> void successor(AvlNode<T> a, AvlNode<T> b, AvlNode<T> c) {
        void var2_2;
        void var1_1;
        TreeMultiset.successor(a, b);
        TreeMultiset.successor(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        stream.writeObject(this.elementSet().comparator());
        Serialization.writeMultiset(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var1_1;
        void var2_2;
        stream.defaultReadObject();
        Comparator comparator = (Comparator)stream.readObject();
        Serialization.getFieldSetter(AbstractSortedMultiset.class, "comparator").set((AbstractSortedMultiset)this, comparator);
        Serialization.getFieldSetter(TreeMultiset.class, "range").set(this, GeneralRange.all(comparator));
        Serialization.getFieldSetter(TreeMultiset.class, "rootReference").set(this, new Reference());
        AvlNode header = new AvlNode();
        Serialization.getFieldSetter(TreeMultiset.class, "header").set(this, header);
        void v0 = var2_2;
        TreeMultiset.successor(v0, v0);
        Serialization.populateMultiset(this, (ObjectInputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Multiset.Entry access$1500(TreeMultiset x0, AvlNode x1) {
        void var1_1;
        return x0.wrapEntry((AvlNode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1800(AvlNode x0, AvlNode x1, AvlNode x2) {
        void var2_2;
        void var1_1;
        TreeMultiset.successor(x0, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1900(AvlNode x0, AvlNode x1) {
        void var1_1;
        TreeMultiset.successor(x0, var1_1);
    }

    private static final class AvlNode<E> {
        private final E elem;
        private int elemCount;
        private int distinctElements;
        private long totalCount;
        private int height;
        private AvlNode<E> left;
        private AvlNode<E> right;
        private AvlNode<E> pred;
        private AvlNode<E> succ;

        /*
         * WARNING - void declaration
         */
        AvlNode(@ParametricNullness E elem, int elemCount) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(elemCount > 0);
            this.elem = var1_1;
            this.elemCount = elemCount;
            this.totalCount = (long)var2_2;
            this.distinctElements = 1;
            this.height = 1;
            this.left = null;
            this.right = null;
        }

        AvlNode() {
            this.elem = null;
            this.elemCount = 1;
        }

        private AvlNode<E> pred() {
            return Objects.requireNonNull(this.pred);
        }

        private AvlNode<E> succ() {
            return Objects.requireNonNull(this.succ);
        }

        /*
         * WARNING - void declaration
         */
        final int count(Comparator<? super E> comparator, @ParametricNullness E e) {
            while (true) {
                void var3_3;
                AvlNode<E> this_;
                int cmp;
                if ((cmp = comparator.compare(e, this_.getElement())) < 0) {
                    if (this_.left == null) {
                        return 0;
                    }
                    this_ = this_.left;
                    continue;
                }
                if (var3_3 <= 0) break;
                if (this_.right == null) {
                    return 0;
                }
                this_ = this_.right;
            }
            return this_.elemCount;
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> addRightChild(@ParametricNullness E e, int count) {
            void var2_2;
            void var1_1;
            this.right = new AvlNode<void>(var1_1, count);
            AvlNode avlNode = this;
            TreeMultiset.access$1800(avlNode, avlNode.right, this.succ());
            this.height = Math.max(2, this.height);
            ++this.distinctElements;
            this.totalCount += (long)var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> addLeftChild(@ParametricNullness E e, int count) {
            void var2_2;
            void var1_1;
            this.left = new AvlNode<void>(var1_1, count);
            TreeMultiset.access$1800(this.pred(), this.left, this);
            this.height = Math.max(2, this.height);
            ++this.distinctElements;
            this.totalCount += (long)var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final AvlNode<E> add(Comparator<? super E> comparator, @ParametricNullness E e, int count, int[] result) {
            void var3_3;
            int cmp = comparator.compare(e, this.getElement());
            if (cmp < 0) {
                AvlNode<E> initLeft = this.left;
                if (initLeft == null) {
                    result[0] = 0;
                    return this.addLeftChild(e, count);
                }
                int initHeight = initLeft.height;
                this.left = initLeft.add(comparator, e, count, result);
                if (result[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)count;
                if (this.left.height == initHeight) {
                    return this;
                }
                return this.rebalance();
            }
            if (cmp > 0) {
                void var2_2;
                void var1_1;
                AvlNode<void> initRight = this.right;
                if (initRight == null) {
                    result[0] = 0;
                    return this.addRightChild(e, count);
                }
                int initHeight = initRight.height;
                this.right = initRight.add((Comparator<void>)var1_1, var2_2, count, result);
                if (result[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)count;
                if (this.right.height == initHeight) {
                    return this;
                }
                return this.rebalance();
            }
            result[0] = this.elemCount;
            long l = (long)this.elemCount + (long)count;
            Preconditions.checkArgument(l <= Integer.MAX_VALUE);
            this.elemCount += count;
            this.totalCount += (long)var3_3;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final AvlNode<E> remove(Comparator<? super E> comparator, @ParametricNullness E e, int count, int[] result) {
            void var3_3;
            void initLeft2;
            int cmp = comparator.compare(e, this.getElement());
            if (cmp < 0) {
                AvlNode<E> initLeft2 = this.left;
                if (initLeft2 == null) {
                    result[0] = 0;
                    return this;
                }
                this.left = initLeft2.remove(comparator, e, count, result);
                if (result[0] > 0) {
                    if (count >= result[0]) {
                        --this.distinctElements;
                        this.totalCount -= (long)result[0];
                    } else {
                        this.totalCount -= (long)count;
                    }
                }
                if (result[0] == 0) {
                    return this;
                }
                return this.rebalance();
            }
            if (initLeft2 > 0) {
                void var2_2;
                void var1_1;
                AvlNode<void> initRight = this.right;
                if (initRight == null) {
                    result[0] = 0;
                    return this;
                }
                this.right = initRight.remove((Comparator<void>)var1_1, var2_2, count, result);
                if (result[0] > 0) {
                    if (count >= result[0]) {
                        --this.distinctElements;
                        this.totalCount -= (long)result[0];
                    } else {
                        this.totalCount -= (long)count;
                    }
                }
                return this.rebalance();
            }
            result[0] = this.elemCount;
            if (count >= this.elemCount) {
                return this.deleteMe();
            }
            this.elemCount -= count;
            this.totalCount -= (long)var3_3;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final AvlNode<E> setCount(Comparator<? super E> comparator, @ParametricNullness E e, int count, int[] result) {
            void var3_3;
            void initLeft2;
            int cmp = comparator.compare(e, this.getElement());
            if (cmp < 0) {
                AvlNode<E> initLeft2 = this.left;
                if (initLeft2 == null) {
                    result[0] = 0;
                    if (count > 0) {
                        return this.addLeftChild(e, count);
                    }
                    return this;
                }
                this.left = initLeft2.setCount(comparator, e, count, result);
                if (count == 0 && result[0] != 0) {
                    --this.distinctElements;
                } else if (count > 0 && result[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)(count - result[0]);
                return this.rebalance();
            }
            if (initLeft2 > 0) {
                void var2_2;
                void var1_1;
                AvlNode<void> initRight = this.right;
                if (initRight == null) {
                    result[0] = 0;
                    if (count > 0) {
                        return this.addRightChild(e, count);
                    }
                    return this;
                }
                this.right = initRight.setCount((Comparator<void>)var1_1, var2_2, count, result);
                if (count == 0 && result[0] != 0) {
                    --this.distinctElements;
                } else if (count > 0 && result[0] == 0) {
                    ++this.distinctElements;
                }
                this.totalCount += (long)(count - result[0]);
                return this.rebalance();
            }
            result[0] = this.elemCount;
            if (count == 0) {
                return this.deleteMe();
            }
            this.totalCount += (long)(count - this.elemCount);
            this.elemCount = var3_3;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final AvlNode<E> setCount(Comparator<? super E> comparator, @ParametricNullness E e, int expectedCount, int newCount, int[] result) {
            void var3_3;
            void initLeft2;
            int cmp = comparator.compare(e, this.getElement());
            if (cmp < 0) {
                AvlNode<E> initLeft2 = this.left;
                if (initLeft2 == null) {
                    result[0] = 0;
                    if (expectedCount == 0 && newCount > 0) {
                        return this.addLeftChild(e, newCount);
                    }
                    return this;
                }
                this.left = initLeft2.setCount(comparator, e, expectedCount, newCount, result);
                if (result[0] == expectedCount) {
                    if (newCount == 0 && result[0] != 0) {
                        --this.distinctElements;
                    } else if (newCount > 0 && result[0] == 0) {
                        ++this.distinctElements;
                    }
                    this.totalCount += (long)(newCount - result[0]);
                }
                return this.rebalance();
            }
            if (initLeft2 > 0) {
                void var2_2;
                void var1_1;
                AvlNode<void> initRight = this.right;
                if (initRight == null) {
                    result[0] = 0;
                    if (expectedCount == 0 && newCount > 0) {
                        return this.addRightChild(e, newCount);
                    }
                    return this;
                }
                this.right = initRight.setCount((Comparator<void>)var1_1, var2_2, expectedCount, newCount, result);
                if (result[0] == expectedCount) {
                    if (newCount == 0 && result[0] != 0) {
                        --this.distinctElements;
                    } else if (newCount > 0 && result[0] == 0) {
                        ++this.distinctElements;
                    }
                    this.totalCount += (long)(newCount - result[0]);
                }
                return this.rebalance();
            }
            result[0] = this.elemCount;
            if (var3_3 == this.elemCount) {
                if (newCount == 0) {
                    return this.deleteMe();
                }
                this.totalCount += (long)(newCount - this.elemCount);
                this.elemCount = newCount;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> deleteMe() {
            void var2_3;
            void var1_1;
            int oldElemCount = this.elemCount;
            this.elemCount = 0;
            TreeMultiset.access$1900(this.pred(), this.succ());
            if (this.left == null) {
                return this.right;
            }
            if (this.right == null) {
                return this.left;
            }
            if (this.left.height >= this.right.height) {
                AvlNode<E> newTop = this.pred();
                this.pred().left = super.removeMax(newTop);
                newTop.right = this.right;
                newTop.distinctElements = this.distinctElements - 1;
                newTop.totalCount = this.totalCount - (long)oldElemCount;
                return super.rebalance();
            }
            AvlNode<E> newTop = this.succ();
            this.succ().right = super.removeMin(newTop);
            newTop.left = this.left;
            newTop.distinctElements = this.distinctElements - 1;
            newTop.totalCount = this.totalCount - (long)var1_1;
            return super.rebalance();
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> removeMin(AvlNode<E> node) {
            void var1_1;
            if (this.left == null) {
                return this.right;
            }
            this.left = super.removeMin(node);
            --this.distinctElements;
            this.totalCount -= (long)var1_1.elemCount;
            return this.rebalance();
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> removeMax(AvlNode<E> node) {
            void var1_1;
            if (this.right == null) {
                return this.left;
            }
            this.right = super.removeMax(node);
            --this.distinctElements;
            this.totalCount -= (long)var1_1.elemCount;
            return this.rebalance();
        }

        private void recomputeMultiset() {
            this.distinctElements = 1 + TreeMultiset.distinctElements(this.left) + TreeMultiset.distinctElements(this.right);
            this.totalCount = (long)this.elemCount + AvlNode.totalCount(this.left) + AvlNode.totalCount(this.right);
        }

        private void recomputeHeight() {
            this.height = 1 + Math.max(AvlNode.height(this.left), AvlNode.height(this.right));
        }

        private void recompute() {
            this.recomputeMultiset();
            this.recomputeHeight();
        }

        private AvlNode<E> rebalance() {
            switch (this.balanceFactor()) {
                case -2: {
                    Objects.requireNonNull(this.right);
                    if (super.balanceFactor() > 0) {
                        this.right = super.rotateRight();
                    }
                    return this.rotateLeft();
                }
                case 2: {
                    Objects.requireNonNull(this.left);
                    if (super.balanceFactor() < 0) {
                        this.left = super.rotateLeft();
                    }
                    return this.rotateRight();
                }
            }
            this.recomputeHeight();
            return this;
        }

        private int balanceFactor() {
            return AvlNode.height(this.left) - AvlNode.height(this.right);
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> rotateLeft() {
            void var1_1;
            Preconditions.checkState(this.right != null);
            AvlNode<E> newTop = this.right;
            this.right = newTop.left;
            newTop.left = this;
            newTop.totalCount = this.totalCount;
            newTop.distinctElements = this.distinctElements;
            this.recompute();
            super.recomputeHeight();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> rotateRight() {
            void var1_1;
            Preconditions.checkState(this.left != null);
            AvlNode<E> newTop = this.left;
            this.left = newTop.right;
            newTop.right = this;
            newTop.totalCount = this.totalCount;
            newTop.distinctElements = this.distinctElements;
            this.recompute();
            super.recomputeHeight();
            return var1_1;
        }

        private static long totalCount(AvlNode<?> node) {
            AvlNode<?> avlNode;
            if (node == null) {
                return 0L;
            }
            return avlNode.totalCount;
        }

        private static int height(AvlNode<?> node) {
            AvlNode<?> avlNode;
            if (node == null) {
                return 0;
            }
            return avlNode.height;
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> ceiling(Comparator<? super E> comparator, @ParametricNullness E e) {
            while (true) {
                void var3_3;
                int cmp;
                if ((cmp = comparator.compare(e, this_.getElement())) < 0) {
                    if (this_.left == null) {
                        return this_;
                    }
                    return MoreObjects.firstNonNull(super.ceiling(comparator, e), this_);
                }
                if (var3_3 == false) {
                    return this_;
                }
                if (this_.right == null) {
                    return null;
                }
                AvlNode<E> this_ = this_.right;
            }
        }

        /*
         * WARNING - void declaration
         */
        private AvlNode<E> floor(Comparator<? super E> comparator, @ParametricNullness E e) {
            while (true) {
                void var3_3;
                int cmp;
                if ((cmp = comparator.compare(e, this_.getElement())) > 0) {
                    if (this_.right == null) {
                        return this_;
                    }
                    return MoreObjects.firstNonNull(super.floor(comparator, e), this_);
                }
                if (var3_3 == false) {
                    return this_;
                }
                if (this_.left == null) {
                    return null;
                }
                AvlNode<E> this_ = this_.left;
            }
        }

        @ParametricNullness
        final E getElement() {
            return NullnessCasts.uncheckedCastNullableTToT(this.elem);
        }

        final int getCount() {
            return this.elemCount;
        }

        public final String toString() {
            return Multisets.immutableEntry(this.getElement(), this.getCount()).toString();
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$202(AvlNode x0, int x1) {
            void var1_1;
            x0.elemCount = var1_1;
            return x0.elemCount;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AvlNode access$502(AvlNode x0, AvlNode x1) {
            void var1_1;
            x0.left = var1_1;
            return x0.left;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AvlNode access$602(AvlNode x0, AvlNode x1) {
            void var1_1;
            x0.right = var1_1;
            return x0.right;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AvlNode access$802(AvlNode x0, AvlNode x1) {
            void var1_1;
            x0.pred = var1_1;
            return x0.pred;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AvlNode access$902(AvlNode x0, AvlNode x1) {
            void var1_1;
            x0.succ = var1_1;
            return x0.succ;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AvlNode access$1000(AvlNode x0, Comparator x1, Object x2) {
            void var2_2;
            void var1_1;
            return x0.ceiling((Comparator)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ AvlNode access$1100(AvlNode x0, Comparator x1, Object x2) {
            void var2_2;
            void var1_1;
            return x0.floor((Comparator)var1_1, var2_2);
        }
    }

    private static final class Reference<T> {
        private T value;

        private Reference() {
        }

        public final T get() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkAndSet(T expected, T newValue) {
            void var2_2;
            void var1_1;
            if (this.value != var1_1) {
                throw new ConcurrentModificationException();
            }
            this.value = var2_2;
        }

        final void clear() {
            this.value = null;
        }
    }

    private static enum Aggregate {
        SIZE{

            @Override
            final int nodeAggregate(AvlNode<?> node) {
                return ((AvlNode)node).elemCount;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final long treeAggregate(AvlNode<?> root) {
                void var1_1;
                if (root == null) {
                    return 0L;
                }
                return ((AvlNode)var1_1).totalCount;
            }
        }
        ,
        DISTINCT{

            @Override
            final int nodeAggregate(AvlNode<?> node) {
                return 1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final long treeAggregate(AvlNode<?> root) {
                void var1_1;
                if (root == null) {
                    return 0L;
                }
                return ((AvlNode)var1_1).distinctElements;
            }
        };


        abstract int nodeAggregate(AvlNode<?> var1);

        abstract long treeAggregate(AvlNode<?> var1);
    }
}

