/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.StandardRowSortedTable;
import com.google.common.collect.StandardTable;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
public class TreeBasedTable<R, C, V>
extends StandardRowSortedTable<R, C, V> {
    private final Comparator<? super C> columnComparator;
    private static final long serialVersionUID = 0L;

    public static <R extends Comparable, C extends Comparable, V> TreeBasedTable<R, C, V> create() {
        return new TreeBasedTable(Ordering.natural(), Ordering.natural());
    }

    /*
     * WARNING - void declaration
     */
    public static <R, C, V> TreeBasedTable<R, C, V> create(Comparator<? super R> rowComparator, Comparator<? super C> columnComparator) {
        void var1_1;
        Comparator<? super R> comparator;
        Preconditions.checkNotNull(rowComparator);
        Preconditions.checkNotNull(columnComparator);
        return new TreeBasedTable<R, C, V>(comparator, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <R, C, V> TreeBasedTable<R, C, V> create(TreeBasedTable<R, C, ? extends V> table) {
        void var1_1;
        TreeBasedTable<R, C, ? extends V> treeBasedTable;
        TreeBasedTable<R, C, V> result = new TreeBasedTable<R, C, V>(table.rowComparator(), table.columnComparator());
        result.putAll((Table)treeBasedTable);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    TreeBasedTable(Comparator<? super R> rowComparator, Comparator<? super C> columnComparator) {
        super(new TreeMap(var1_1), new Factory(columnComparator));
        void var2_2;
        void var1_1;
        this.columnComparator = var2_2;
    }

    @Deprecated
    public Comparator<? super R> rowComparator() {
        return Objects.requireNonNull(this.rowKeySet().comparator());
    }

    @Deprecated
    public Comparator<? super C> columnComparator() {
        return this.columnComparator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<C, V> row(R rowKey) {
        void var1_1;
        return new TreeRow(var1_1);
    }

    @Override
    public SortedSet<R> rowKeySet() {
        return super.rowKeySet();
    }

    @Override
    public SortedMap<R, Map<C, V>> rowMap() {
        return super.rowMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Iterator<C> createColumnKeyIterator() {
        void var1_1;
        void var2_2;
        Comparator<C> comparator = this.columnComparator();
        UnmodifiableIterator<C> merged = Iterators.mergeSorted(Iterables.transform(this.backingMap.values(), input -> input.keySet().iterator()), comparator);
        return new AbstractIterator<C>(this, (Iterator)var2_2, (Comparator)var1_1){
            C lastValue;
            final /* synthetic */ Iterator val$merged;
            final /* synthetic */ Comparator val$comparator;
            {
                this.val$merged = iterator;
                this.val$comparator = comparator;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected C computeNext() {
                while (this.val$merged.hasNext()) {
                    void var1_1;
                    Object next = this.val$merged.next();
                    boolean bl = this.lastValue != null && this.val$comparator.compare(next, this.lastValue) == 0;
                    if (bl) continue;
                    this.lastValue = var1_1;
                    return this.lastValue;
                }
                this.lastValue = null;
                return this.endOfData();
            }
        };
    }

    private class TreeRow
    extends StandardTable.Row
    implements SortedMap<C, V> {
        final C lowerBound;
        final C upperBound;
        transient SortedMap<C, V> wholeRow;

        /*
         * WARNING - void declaration
         */
        TreeRow(R rowKey) {
            this(var2_2, null, null);
            void var2_2;
        }

        /*
         * WARNING - void declaration
         */
        TreeRow(R rowKey, C lowerBound, C upperBound) {
            void var3_3;
            void var2_2;
            super(TreeBasedTable.this, var2_2);
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            Preconditions.checkArgument(lowerBound == null || upperBound == null || this.compare(var3_3, upperBound) <= 0);
        }

        @Override
        public SortedSet<C> keySet() {
            return new Maps.SortedKeySet(this);
        }

        @Override
        public Comparator<? super C> comparator() {
            return TreeBasedTable.this.columnComparator();
        }

        /*
         * WARNING - void declaration
         */
        int compare(Object a, Object b) {
            void var2_2;
            void var1_1;
            Comparator comparator = this.comparator();
            return comparator.compare(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        boolean rangeContains(Object o) {
            block2: {
                block4: {
                    void var1_1;
                    block3: {
                        if (o == null) break block2;
                        if (this.lowerBound == null) break block3;
                        TreeRow treeRow = this;
                        if (treeRow.compare(treeRow.lowerBound, o) > 0) break block2;
                    }
                    if (this.upperBound == null) break block4;
                    TreeRow treeRow = this;
                    if (treeRow.compare(treeRow.upperBound, var1_1) <= 0) break block2;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<C, V> subMap(C fromKey, C toKey) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(this.rangeContains(Preconditions.checkNotNull(fromKey)) && this.rangeContains(Preconditions.checkNotNull(toKey)));
            return new TreeRow(this.rowKey, var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<C, V> headMap(C toKey) {
            void var1_1;
            Preconditions.checkArgument(this.rangeContains(Preconditions.checkNotNull(toKey)));
            return new TreeRow(this.rowKey, this.lowerBound, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<C, V> tailMap(C fromKey) {
            void var1_1;
            Preconditions.checkArgument(this.rangeContains(Preconditions.checkNotNull(fromKey)));
            return new TreeRow(this.rowKey, var1_1, this.upperBound);
        }

        @Override
        public C firstKey() {
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                throw new NoSuchElementException();
            }
            return ((SortedMap)this.backingRowMap).firstKey();
        }

        @Override
        public C lastKey() {
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                throw new NoSuchElementException();
            }
            return ((SortedMap)this.backingRowMap).lastKey();
        }

        void updateWholeRowField() {
            if (this.wholeRow == null || this.wholeRow.isEmpty() && TreeBasedTable.this.backingMap.containsKey(this.rowKey)) {
                this.wholeRow = (SortedMap)TreeBasedTable.this.backingMap.get(this.rowKey);
            }
        }

        /*
         * WARNING - void declaration
         */
        SortedMap<C, V> computeBackingRowMap() {
            this.updateWholeRowField();
            SortedMap map = this.wholeRow;
            if (map != null) {
                void var1_1;
                if (this.lowerBound != null) {
                    map = map.tailMap(this.lowerBound);
                }
                if (this.upperBound != null) {
                    map = map.headMap(this.upperBound);
                }
                return var1_1;
            }
            return null;
        }

        @Override
        void maintainEmptyInvariant() {
            this.updateWholeRowField();
            if (this.wholeRow != null && this.wholeRow.isEmpty()) {
                TreeBasedTable.this.backingMap.remove(this.rowKey);
                this.wholeRow = null;
                this.backingRowMap = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.rangeContains(key) && super.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(C key, V value) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(this.rangeContains(Preconditions.checkNotNull(key)));
            return super.put(var1_1, var2_2);
        }
    }

    private static class Factory<C, V>
    implements Supplier<TreeMap<C, V>>,
    Serializable {
        final Comparator<? super C> comparator;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        Factory(Comparator<? super C> comparator) {
            void var1_1;
            this.comparator = var1_1;
        }

        @Override
        public TreeMap<C, V> get() {
            return new TreeMap(this.comparator);
        }
    }
}

