/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ParametricNullness;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class TransformedIterator<F, T>
implements Iterator<T> {
    final Iterator<? extends F> backingIterator;

    /*
     * WARNING - void declaration
     */
    TransformedIterator(Iterator<? extends F> backingIterator) {
        void var1_1;
        this.backingIterator = (Iterator)Preconditions.checkNotNull(var1_1);
    }

    @ParametricNullness
    abstract T transform(@ParametricNullness F var1);

    @Override
    public final boolean hasNext() {
        return this.backingIterator.hasNext();
    }

    @Override
    @ParametricNullness
    public final T next() {
        TransformedIterator transformedIterator = this;
        return transformedIterator.transform(transformedIterator.backingIterator.next());
    }

    @Override
    public final void remove() {
        this.backingIterator.remove();
    }
}

