/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class TopKSelector<T> {
    private final int k;
    private final Comparator<? super T> comparator;
    private final T[] buffer;
    private int bufferSize;
    private T threshold;

    public static <T extends Comparable<? super T>> TopKSelector<T> least(int k) {
        return TopKSelector.least(k, Ordering.natural());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> TopKSelector<T> least(int k, Comparator<? super T> comparator) {
        int n;
        void var1_1;
        return new TopKSelector<T>(var1_1, n);
    }

    public static <T extends Comparable<? super T>> TopKSelector<T> greatest(int k) {
        return TopKSelector.greatest(k, Ordering.natural());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> TopKSelector<T> greatest(int k, Comparator<? super T> comparator) {
        int n;
        void var1_1;
        return new TopKSelector(Ordering.from(var1_1).reverse(), n);
    }

    /*
     * WARNING - void declaration
     */
    private TopKSelector(Comparator<? super T> comparator, int k) {
        void var2_2;
        void var1_1;
        this.comparator = (Comparator)Preconditions.checkNotNull(var1_1, "comparator");
        this.k = k;
        Preconditions.checkArgument(k >= 0, "k (%s) must be >= 0", k);
        Preconditions.checkArgument(k <= 0x3FFFFFFF, "k (%s) must be <= Integer.MAX_VALUE / 2", k);
        this.buffer = new Object[IntMath.checkedMultiply((int)var2_2, 2)];
        this.bufferSize = 0;
        this.threshold = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void offer(@ParametricNullness T elem) {
        if (this.k == 0) {
            return;
        }
        if (this.bufferSize == 0) {
            this.buffer[0] = elem;
            this.threshold = elem;
            this.bufferSize = 1;
            return;
        }
        if (this.bufferSize < this.k) {
            this.buffer[this.bufferSize++] = elem;
            if (this.comparator.compare(elem, NullnessCasts.uncheckedCastNullableTToT(this.threshold)) > 0) {
                this.threshold = elem;
                return;
            }
        } else if (this.comparator.compare(elem, NullnessCasts.uncheckedCastNullableTToT(this.threshold)) < 0) {
            void var1_1;
            this.buffer[this.bufferSize++] = var1_1;
            if (this.bufferSize == 2 * this.k) {
                this.trim();
            }
        }
    }

    private void trim() {
        int left = 0;
        int right = 2 * this.k - 1;
        int minThresholdPosition = 0;
        int iterations2 = 0;
        int maxIterations = IntMath.log2(right, RoundingMode.CEILING) * 3;
        while (left < right) {
            int pivotIndex = left + right + 1 >>> 1;
            int pivotNewIndex = this.partition(left, right, pivotIndex);
            if (pivotNewIndex > this.k) {
                right = pivotNewIndex - 1;
            } else {
                if (pivotNewIndex >= this.k) break;
                left = Math.max(pivotNewIndex, left + 1);
                minThresholdPosition = pivotNewIndex;
            }
            if (++iterations2 < maxIterations) continue;
            T[] iterations2 = this.buffer;
            Arrays.sort(this.buffer, left, right + 1, this.comparator);
            break;
        }
        this.bufferSize = this.k;
        this.threshold = NullnessCasts.uncheckedCastNullableTToT(this.buffer[minThresholdPosition]);
        for (void i = var3_3 + true; i < this.k; ++i) {
            if (this.comparator.compare(NullnessCasts.uncheckedCastNullableTToT(this.buffer[i]), NullnessCasts.uncheckedCastNullableTToT(this.threshold)) <= 0) continue;
            this.threshold = this.buffer[i];
        }
    }

    /*
     * WARNING - void declaration
     */
    private int partition(int left, int right, int pivotIndex) {
        void var3_3;
        void i;
        T pivotValue = NullnessCasts.uncheckedCastNullableTToT(this.buffer[pivotIndex]);
        this.buffer[pivotIndex] = this.buffer[right];
        int pivotNewIndex = left;
        while (i < right) {
            if (this.comparator.compare(NullnessCasts.uncheckedCastNullableTToT(this.buffer[i]), pivotValue) < 0) {
                this.swap(pivotNewIndex, (int)i);
                ++pivotNewIndex;
            }
            ++i;
        }
        this.buffer[var2_2] = this.buffer[pivotNewIndex];
        this.buffer[pivotNewIndex] = pivotValue;
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void swap(int i, int j) {
        void var3_3;
        T tmp = this.buffer[i];
        this.buffer[var1_1] = this.buffer[j];
        this.buffer[var2_2] = var3_3;
    }

    final TopKSelector<T> combine(TopKSelector<T> other) {
        for (int i = 0; i < other.bufferSize; ++i) {
            this.offer(NullnessCasts.uncheckedCastNullableTToT(other.buffer[i]));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final void offerAll(Iterable<? extends T> elements) {
        void var1_1;
        this.offerAll(var1_1.iterator());
    }

    public final void offerAll(Iterator<? extends T> elements) {
        while (elements.hasNext()) {
            this.offer(elements.next());
        }
    }

    public final List<T> topK() {
        T[] TArray = this.buffer;
        Arrays.sort(this.buffer, 0, this.bufferSize, this.comparator);
        if (this.bufferSize > this.k) {
            Arrays.fill(this.buffer, this.k, this.buffer.length, null);
            this.bufferSize = this.k;
            this.threshold = this.buffer[this.k - 1];
        }
        return Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(this.buffer, this.bufferSize)));
    }
}

