/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.StandardTable;
import com.google.common.collect.Synchronized;
import com.google.common.collect.Table;
import com.google.common.collect.TableCollectors;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Tables {
    private static final Function<? extends Map<?, ?>, ? extends Map<?, ?>> UNMODIFIABLE_WRAPPER = new Function<Map<Object, Object>, Map<Object, Object>>(){

        @Override
        public Map<Object, Object> apply(Map<Object, Object> input) {
            return Collections.unmodifiableMap(input);
        }
    };

    private Tables() {
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <T, R, C, V, I extends Table<R, C, V>> Collector<T, ?, I> toTable(java.util.function.Function<? super T, ? extends R> rowFunction, java.util.function.Function<? super T, ? extends C> columnFunction, java.util.function.Function<? super T, ? extends V> valueFunction, java.util.function.Supplier<I> tableSupplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TableCollectors.toTable(rowFunction, var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R, C, V, I extends Table<R, C, V>> Collector<T, ?, I> toTable(java.util.function.Function<? super T, ? extends R> rowFunction, java.util.function.Function<? super T, ? extends C> columnFunction, java.util.function.Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction, java.util.function.Supplier<I> tableSupplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TableCollectors.toTable(rowFunction, var1_1, var2_2, var3_3, tableSupplier);
    }

    /*
     * WARNING - void declaration
     */
    public static <R, C, V> Table.Cell<R, C, V> immutableCell(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        R r;
        return new ImmutableCell<R, void, void>(r, var1_1, var2_2);
    }

    public static <R, C, V> Table<C, R, V> transpose(Table<R, C, V> table) {
        Table<R, C, V> table2;
        if (table instanceof TransposeTable) {
            return ((TransposeTable)table).original;
        }
        return new TransposeTable<C, R, V>(table2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <R, C, V> Table<R, C, V> newCustomTable(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        void var1_1;
        Map<R, Map<C, V>> map;
        Preconditions.checkArgument(backingMap.isEmpty());
        Preconditions.checkNotNull(factory);
        return new StandardTable<R, C, V>(map, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <R, C, V1, V2> Table<R, C, V2> transformValues(Table<R, C, V1> fromTable, Function<? super V1, V2> function) {
        void var1_1;
        Table<R, C, V1> table;
        return new TransformedTable(table, var1_1);
    }

    public static <R, C, V> Table<R, C, V> unmodifiableTable(Table<? extends R, ? extends C, ? extends V> table) {
        Table<? extends R, ? extends C, ? extends V> table2;
        return new UnmodifiableTable<R, C, V>(table2);
    }

    @Beta
    public static <R, C, V> RowSortedTable<R, C, V> unmodifiableRowSortedTable(RowSortedTable<R, ? extends C, ? extends V> table) {
        RowSortedTable<R, ? extends C, ? extends V> rowSortedTable;
        return new UnmodifiableRowSortedMap<R, C, V>(rowSortedTable);
    }

    private static <K, V> Function<Map<K, V>, Map<K, V>> unmodifiableWrapper() {
        return UNMODIFIABLE_WRAPPER;
    }

    public static <R, C, V> Table<R, C, V> synchronizedTable(Table<R, C, V> table) {
        return Synchronized.table(table, null);
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Table<?, ?, ?> table, Object obj) {
        if (obj == table) {
            return true;
        }
        if (obj instanceof Table) {
            void var1_1;
            Table<?, ?, ?> table2;
            Table that = (Table)obj;
            return table2.cellSet().equals(var1_1.cellSet());
        }
        return false;
    }

    static final class UnmodifiableRowSortedMap<R, C, V>
    extends UnmodifiableTable<R, C, V>
    implements RowSortedTable<R, C, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public UnmodifiableRowSortedMap(RowSortedTable<R, ? extends C, ? extends V> delegate) {
            super(var1_1);
            void var1_1;
        }

        @Override
        protected final RowSortedTable<R, C, V> delegate() {
            return (RowSortedTable)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final SortedMap<R, Map<C, V>> rowMap() {
            void var1_1;
            Function wrapper = Tables.unmodifiableWrapper();
            return Collections.unmodifiableSortedMap(Maps.transformValues(this.delegate().rowMap(), var1_1));
        }

        @Override
        public final SortedSet<R> rowKeySet() {
            return Collections.unmodifiableSortedSet(this.delegate().rowKeySet());
        }
    }

    private static class UnmodifiableTable<R, C, V>
    extends ForwardingTable<R, C, V>
    implements Serializable {
        final Table<? extends R, ? extends C, ? extends V> delegate;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableTable(Table<? extends R, ? extends C, ? extends V> delegate) {
            void var1_1;
            this.delegate = (Table)Preconditions.checkNotNull(var1_1);
        }

        @Override
        protected Table<R, C, V> delegate() {
            return this.delegate;
        }

        @Override
        public Set<Table.Cell<R, C, V>> cellSet() {
            return Collections.unmodifiableSet(super.cellSet());
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<R, V> column(@ParametricNullness C columnKey) {
            void var1_1;
            return Collections.unmodifiableMap(super.column(var1_1));
        }

        @Override
        public Set<C> columnKeySet() {
            return Collections.unmodifiableSet(super.columnKeySet());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<C, Map<R, V>> columnMap() {
            void var1_1;
            Function wrapper = Tables.unmodifiableWrapper();
            return Collections.unmodifiableMap(Maps.transformValues(super.columnMap(), var1_1));
        }

        @Override
        public V put(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object rowKey, Object columnKey) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<C, V> row(@ParametricNullness R rowKey) {
            void var1_1;
            return Collections.unmodifiableMap(super.row(var1_1));
        }

        @Override
        public Set<R> rowKeySet() {
            return Collections.unmodifiableSet(super.rowKeySet());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<R, Map<C, V>> rowMap() {
            void var1_1;
            Function wrapper = Tables.unmodifiableWrapper();
            return Collections.unmodifiableMap(Maps.transformValues(super.rowMap(), var1_1));
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(super.values());
        }
    }

    private static class TransformedTable<R, C, V1, V2>
    extends AbstractTable<R, C, V2> {
        final Table<R, C, V1> fromTable;
        final Function<? super V1, V2> function;

        /*
         * WARNING - void declaration
         */
        TransformedTable(Table<R, C, V1> fromTable, Function<? super V1, V2> function) {
            void var2_2;
            void var1_1;
            this.fromTable = (Table)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object rowKey, Object columnKey) {
            void var2_2;
            void var1_1;
            return this.fromTable.contains(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V2 get(Object rowKey, Object columnKey) {
            if (this.contains(rowKey, columnKey)) {
                void var2_2;
                void var1_1;
                return this.function.apply(NullnessCasts.uncheckedCastNullableTToT(this.fromTable.get(var1_1, var2_2)));
            }
            return null;
        }

        @Override
        public int size() {
            return this.fromTable.size();
        }

        @Override
        public void clear() {
            this.fromTable.clear();
        }

        @Override
        public V2 put(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V2 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Table<? extends R, ? extends C, ? extends V2> table) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V2 remove(Object rowKey, Object columnKey) {
            if (this.contains(rowKey, columnKey)) {
                void var2_2;
                void var1_1;
                return this.function.apply(NullnessCasts.uncheckedCastNullableTToT(this.fromTable.remove(var1_1, var2_2)));
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<C, V2> row(@ParametricNullness R rowKey) {
            void var1_1;
            return Maps.transformValues(this.fromTable.row(var1_1), this.function);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<R, V2> column(@ParametricNullness C columnKey) {
            void var1_1;
            return Maps.transformValues(this.fromTable.column(var1_1), this.function);
        }

        Function<Table.Cell<R, C, V1>, Table.Cell<R, C, V2>> cellFunction() {
            return new Function<Table.Cell<R, C, V1>, Table.Cell<R, C, V2>>(this){
                final /* synthetic */ TransformedTable this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Table.Cell<R, C, V2> apply(Table.Cell<R, C, V1> cell) {
                    void var1_1;
                    return Tables.immutableCell(cell.getRowKey(), cell.getColumnKey(), this.this$0.function.apply(var1_1.getValue()));
                }
            };
        }

        @Override
        Iterator<Table.Cell<R, C, V2>> cellIterator() {
            return Iterators.transform(this.fromTable.cellSet().iterator(), this.cellFunction());
        }

        @Override
        Spliterator<Table.Cell<R, C, V2>> cellSpliterator() {
            return CollectSpliterators.map(this.fromTable.cellSet().spliterator(), this.cellFunction());
        }

        @Override
        public Set<R> rowKeySet() {
            return this.fromTable.rowKeySet();
        }

        @Override
        public Set<C> columnKeySet() {
            return this.fromTable.columnKeySet();
        }

        @Override
        Collection<V2> createValues() {
            return Collections2.transform(this.fromTable.values(), this.function);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<R, Map<C, V2>> rowMap() {
            void var1_1;
            Function rowFunction = new Function<Map<C, V1>, Map<C, V2>>(this){
                final /* synthetic */ TransformedTable this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public Map<C, V2> apply(Map<C, V1> row) {
                    return Maps.transformValues(row, this.this$0.function);
                }
            };
            return Maps.transformValues(this.fromTable.rowMap(), var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<C, Map<R, V2>> columnMap() {
            void var1_1;
            Function columnFunction = new Function<Map<R, V1>, Map<R, V2>>(this){
                final /* synthetic */ TransformedTable this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public Map<R, V2> apply(Map<R, V1> column) {
                    return Maps.transformValues(column, this.this$0.function);
                }
            };
            return Maps.transformValues(this.fromTable.columnMap(), var1_1);
        }
    }

    private static class TransposeTable<C, R, V>
    extends AbstractTable<C, R, V> {
        final Table<R, C, V> original;
        private static final Function<Table.Cell<?, ?, ?>, Table.Cell<?, ?, ?>> TRANSPOSE_CELL = new Function<Table.Cell<?, ?, ?>, Table.Cell<?, ?, ?>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Table.Cell<?, ?, ?> apply(Table.Cell<?, ?, ?> cell) {
                void var1_1;
                return Tables.immutableCell(cell.getColumnKey(), cell.getRowKey(), var1_1.getValue());
            }
        };

        /*
         * WARNING - void declaration
         */
        TransposeTable(Table<R, C, V> original) {
            void var1_1;
            this.original = (Table)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public void clear() {
            this.original.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<C, V> column(@ParametricNullness R columnKey) {
            void var1_1;
            return this.original.row(var1_1);
        }

        @Override
        public Set<R> columnKeySet() {
            return this.original.rowKeySet();
        }

        @Override
        public Map<R, Map<C, V>> columnMap() {
            return this.original.rowMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object rowKey, Object columnKey) {
            void var1_1;
            void var2_2;
            return this.original.contains(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsColumn(Object columnKey) {
            void var1_1;
            return this.original.containsRow(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsRow(Object rowKey) {
            void var1_1;
            return this.original.containsColumn(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsValue(Object value) {
            void var1_1;
            return this.original.containsValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object rowKey, Object columnKey) {
            void var1_1;
            void var2_2;
            return this.original.get(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(@ParametricNullness C rowKey, @ParametricNullness R columnKey, @ParametricNullness V value) {
            void var3_3;
            void var1_1;
            void var2_2;
            return this.original.put(var2_2, var1_1, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(Table<? extends C, ? extends R, ? extends V> table) {
            void var1_1;
            this.original.putAll(Tables.transpose(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object rowKey, Object columnKey) {
            void var1_1;
            void var2_2;
            return this.original.remove(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<R, V> row(@ParametricNullness C rowKey) {
            void var1_1;
            return this.original.column(var1_1);
        }

        @Override
        public Set<C> rowKeySet() {
            return this.original.columnKeySet();
        }

        @Override
        public Map<C, Map<R, V>> rowMap() {
            return this.original.columnMap();
        }

        @Override
        public int size() {
            return this.original.size();
        }

        @Override
        public Collection<V> values() {
            return this.original.values();
        }

        @Override
        Iterator<Table.Cell<C, R, V>> cellIterator() {
            return Iterators.transform(this.original.cellSet().iterator(), TRANSPOSE_CELL);
        }

        @Override
        Spliterator<Table.Cell<C, R, V>> cellSpliterator() {
            return CollectSpliterators.map(this.original.cellSet().spliterator(), TRANSPOSE_CELL);
        }
    }

    static abstract class AbstractCell<R, C, V>
    implements Table.Cell<R, C, V> {
        AbstractCell() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Table.Cell) {
                void var1_1;
                Table.Cell other = (Table.Cell)obj;
                return Objects.equal(this.getRowKey(), other.getRowKey()) && Objects.equal(this.getColumnKey(), other.getColumnKey()) && Objects.equal(this.getValue(), var1_1.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getRowKey(), this.getColumnKey(), this.getValue());
        }

        public String toString() {
            String string = String.valueOf(this.getRowKey());
            String string2 = String.valueOf(this.getColumnKey());
            String string3 = String.valueOf(this.getValue());
            return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string).append(",").append(string2).append(")=").append(string3).toString();
        }
    }

    static final class ImmutableCell<R, C, V>
    extends AbstractCell<R, C, V>
    implements Serializable {
        @ParametricNullness
        private final R rowKey;
        @ParametricNullness
        private final C columnKey;
        @ParametricNullness
        private final V value;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ImmutableCell(@ParametricNullness R rowKey, @ParametricNullness C columnKey, @ParametricNullness V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.rowKey = var1_1;
            this.columnKey = var2_2;
            this.value = var3_3;
        }

        @Override
        @ParametricNullness
        public final R getRowKey() {
            return this.rowKey;
        }

        @Override
        @ParametricNullness
        public final C getColumnKey() {
            return this.columnKey;
        }

        @Override
        @ParametricNullness
        public final V getValue() {
            return this.value;
        }
    }
}

