/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class TableCollectors {
    /*
     * WARNING - void declaration
     */
    static <T, R, C, V> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction) {
        void var2_2;
        void var1_1;
        Function<? super T, ? extends R> function;
        Preconditions.checkNotNull(rowFunction, "rowFunction");
        Preconditions.checkNotNull(columnFunction, "columnFunction");
        Preconditions.checkNotNull(valueFunction, "valueFunction");
        return Collector.of(ImmutableTable.Builder::new, (arg_0, arg_1) -> TableCollectors.lambda$toImmutableTable$0(function, (Function)var1_1, (Function)var2_2, arg_0, arg_1), ImmutableTable.Builder::combine, ImmutableTable.Builder::build, new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, R, C, V> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        void var3_3;
        void var2_2;
        void var1_1;
        Function<? super T, ? extends R> function;
        Preconditions.checkNotNull(rowFunction, "rowFunction");
        Preconditions.checkNotNull(columnFunction, "columnFunction");
        Preconditions.checkNotNull(valueFunction, "valueFunction");
        Preconditions.checkNotNull(mergeFunction, "mergeFunction");
        return Collector.of(() -> new ImmutableTableCollectorState(), (arg_0, arg_1) -> TableCollectors.lambda$toImmutableTable$2(function, (Function)var1_1, (Function)var2_2, mergeFunction, arg_0, arg_1), (arg_0, arg_1) -> TableCollectors.lambda$toImmutableTable$3((BinaryOperator)var3_3, arg_0, arg_1), state -> state.toTable(), new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    static <T, R, C, V, I extends Table<R, C, V>> Collector<T, ?, I> toTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction, Supplier<I> tableSupplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TableCollectors.toTable(rowFunction, var1_1, var2_2, (v1, v2) -> {
            String string;
            Object object;
            object = String.valueOf(object);
            string = String.valueOf(string);
            throw new IllegalStateException(new StringBuilder(24 + String.valueOf(object).length() + String.valueOf(string).length()).append("Conflicting values ").append((String)object).append(" and ").append(string).toString());
        }, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static <T, R, C, V, I extends Table<R, C, V>> Collector<T, ?, I> toTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction, Supplier<I> tableSupplier) {
        void var3_3;
        void var2_2;
        void var1_1;
        Function<? super T, ? extends R> function;
        Preconditions.checkNotNull(rowFunction);
        Preconditions.checkNotNull(columnFunction);
        Preconditions.checkNotNull(valueFunction);
        Preconditions.checkNotNull(mergeFunction);
        Preconditions.checkNotNull(tableSupplier);
        return Collector.of(tableSupplier, (arg_0, arg_1) -> TableCollectors.lambda$toTable$6(function, (Function)var1_1, (Function)var2_2, mergeFunction, arg_0, arg_1), (arg_0, arg_1) -> TableCollectors.lambda$toTable$7((BinaryOperator)var3_3, arg_0, arg_1), new Collector.Characteristics[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static <R, C, V> void mergeTables(Table<R, C, V> table, @ParametricNullness R row, @ParametricNullness C column, @ParametricNullness V value, BinaryOperator<V> mergeFunction) {
        void var3_3;
        void var2_2;
        void var1_1;
        Table<void, void, void> table2;
        Preconditions.checkNotNull(value);
        V oldValue = table.get(row, column);
        if (oldValue == null) {
            table.put(row, column, value);
            return;
        }
        Object newValue = mergeFunction.apply(oldValue, value);
        if (newValue == null) {
            table.remove(row, column);
            return;
        }
        table2.put(var1_1, var2_2, var3_3);
    }

    private TableCollectors() {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Table lambda$toTable$7(BinaryOperator mergeFunction, Table table1, Table table2) {
        void var1_1;
        for (Table.Cell cell2 : table2.cellSet()) {
            void var3_3;
            TableCollectors.mergeTables(table1, cell2.getRowKey(), cell2.getColumnKey(), var3_3.getValue(), mergeFunction);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toTable$6(Function rowFunction, Function columnFunction, Function valueFunction, BinaryOperator mergeFunction, Table table, Object input) {
        void var3_3;
        void var2_2;
        void var1_1;
        Function function;
        TableCollectors.mergeTables(table, function.apply(input), var1_1.apply(input), var2_2.apply(input), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ ImmutableTableCollectorState lambda$toImmutableTable$3(BinaryOperator mergeFunction, ImmutableTableCollectorState s1, ImmutableTableCollectorState s2) {
        BinaryOperator binaryOperator;
        void var2_2;
        return s1.combine(var2_2, binaryOperator);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableTable$2(Function rowFunction, Function columnFunction, Function valueFunction, BinaryOperator mergeFunction, ImmutableTableCollectorState state, Object input) {
        void var3_3;
        void var2_2;
        void var1_1;
        Function function;
        state.put(function.apply(input), var1_1.apply(input), var2_2.apply(input), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableTable$0(Function rowFunction, Function columnFunction, Function valueFunction, ImmutableTable.Builder builder, Object t) {
        void var2_2;
        void var1_1;
        Function function;
        builder.put(function.apply(t), var1_1.apply(t), var2_2.apply(t));
    }

    private static final class MutableCell<R, C, V>
    extends Tables.AbstractCell<R, C, V> {
        private final R row;
        private final C column;
        private V value;

        /*
         * WARNING - void declaration
         */
        MutableCell(R row, C column, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.row = Preconditions.checkNotNull(var1_1, "row");
            this.column = Preconditions.checkNotNull(var2_2, "column");
            this.value = Preconditions.checkNotNull(var3_3, "value");
        }

        @Override
        public final R getRowKey() {
            return this.row;
        }

        @Override
        public final C getColumnKey() {
            return this.column;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        final void merge(V value, BinaryOperator<V> mergeFunction) {
            void var1_1;
            void var2_2;
            Preconditions.checkNotNull(value, "value");
            this.value = Preconditions.checkNotNull(var2_2.apply(this.value, var1_1), "mergeFunction.apply");
        }
    }

    private static final class ImmutableTableCollectorState<R, C, V> {
        final List<MutableCell<R, C, V>> insertionOrder = new ArrayList<MutableCell<R, C, V>>();
        final Table<R, C, MutableCell<R, C, V>> table = HashBasedTable.create();

        private ImmutableTableCollectorState() {
        }

        /*
         * WARNING - void declaration
         */
        final void put(R row, C column, V value, BinaryOperator<V> merger) {
            void var3_3;
            MutableCell<R, C, void> oldCell = this.table.get(row, column);
            if (oldCell == null) {
                void var2_2;
                void var1_1;
                MutableCell<R, C, V> cell = new MutableCell<R, C, V>(row, column, value);
                this.insertionOrder.add(cell);
                this.table.put(var1_1, var2_2, (MutableCell<void, void, void>)var3_3);
                return;
            }
            oldCell.merge(var3_3, merger);
        }

        /*
         * WARNING - void declaration
         */
        final ImmutableTableCollectorState<R, C, V> combine(ImmutableTableCollectorState<R, C, V> other, BinaryOperator<V> merger) {
            for (MutableCell<R, C, V> cell : other.insertionOrder) {
                void var3_3;
                this.put(cell.getRowKey(), cell.getColumnKey(), var3_3.getValue(), merger);
            }
            return this;
        }

        final ImmutableTable<R, C, V> toTable() {
            return ImmutableTable.copyOf(this.insertionOrder);
        }
    }
}

