/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.BaseImmutableMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TransformedIterator;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Synchronized {
    private Synchronized() {
    }

    /*
     * WARNING - void declaration
     */
    private static <E> Collection<E> collection(Collection<E> collection, Object mutex) {
        void var1_1;
        Collection<E> collection2;
        return new SynchronizedCollection(collection2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static <E> Set<E> set(Set<E> set, Object mutex) {
        void var1_1;
        Set<E> set2;
        return new SynchronizedSet<E>(set2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> SortedSet<E> sortedSet(SortedSet<E> set, Object mutex) {
        void var1_1;
        SortedSet<E> sortedSet;
        return new SynchronizedSortedSet<E>(sortedSet, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> List<E> list(List<E> list, Object mutex) {
        void var1_1;
        List<E> list2;
        if (list instanceof RandomAccess) {
            return new SynchronizedRandomAccessList<E>(list, mutex);
        }
        return new SynchronizedList<E>(list2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <E> Multiset<E> multiset(Multiset<E> multiset, Object mutex) {
        void var1_1;
        Multiset<E> multiset2;
        if (multiset instanceof SynchronizedMultiset || multiset instanceof ImmutableMultiset) {
            return multiset;
        }
        return new SynchronizedMultiset<E>(multiset2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Multimap<K, V> multimap(Multimap<K, V> multimap, Object mutex) {
        void var1_1;
        Multimap<K, V> multimap2;
        if (multimap instanceof SynchronizedMultimap || multimap instanceof BaseImmutableMultimap) {
            return multimap;
        }
        return new SynchronizedMultimap<K, V>(multimap2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ListMultimap<K, V> listMultimap(ListMultimap<K, V> multimap, Object mutex) {
        void var1_1;
        ListMultimap<K, V> listMultimap;
        if (multimap instanceof SynchronizedListMultimap || multimap instanceof BaseImmutableMultimap) {
            return multimap;
        }
        return new SynchronizedListMultimap<K, V>(listMultimap, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> SetMultimap<K, V> setMultimap(SetMultimap<K, V> multimap, Object mutex) {
        void var1_1;
        SetMultimap<K, V> setMultimap;
        if (multimap instanceof SynchronizedSetMultimap || multimap instanceof BaseImmutableMultimap) {
            return multimap;
        }
        return new SynchronizedSetMultimap<K, V>(setMultimap, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> SortedSetMultimap<K, V> sortedSetMultimap(SortedSetMultimap<K, V> multimap, Object mutex) {
        void var1_1;
        SortedSetMultimap<K, V> sortedSetMultimap;
        if (multimap instanceof SynchronizedSortedSetMultimap) {
            return multimap;
        }
        return new SynchronizedSortedSetMultimap<K, V>(sortedSetMultimap, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> Collection<E> typePreservingCollection(Collection<E> collection, Object mutex) {
        void var1_1;
        Collection<E> collection2;
        if (collection instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)collection, mutex);
        }
        if (collection instanceof Set) {
            return Synchronized.set((Set)collection, mutex);
        }
        if (collection instanceof List) {
            return Synchronized.list((List)collection, mutex);
        }
        return Synchronized.collection(collection2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> Set<E> typePreservingSet(Set<E> set, Object mutex) {
        void var1_1;
        Set<E> set2;
        if (set instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)set, mutex);
        }
        return Synchronized.set(set2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static <K, V> Map<K, V> map(Map<K, V> map, Object mutex) {
        void var1_1;
        Map<K, V> map2;
        return new SynchronizedMap<K, V>(map2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> SortedMap<K, V> sortedMap(SortedMap<K, V> sortedMap, Object mutex) {
        void var1_1;
        SortedMap<K, V> sortedMap2;
        return new SynchronizedSortedMap<K, V>(sortedMap2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> BiMap<K, V> biMap(BiMap<K, V> bimap, Object mutex) {
        void var1_1;
        BiMap<K, V> biMap;
        if (bimap instanceof SynchronizedBiMap || bimap instanceof ImmutableBiMap) {
            return bimap;
        }
        return new SynchronizedBiMap(biMap, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static <E> NavigableSet<E> navigableSet(NavigableSet<E> navigableSet, Object mutex) {
        void var1_1;
        NavigableSet<E> navigableSet2;
        return new SynchronizedNavigableSet<E>(navigableSet2, (Object)var1_1);
    }

    @GwtIncompatible
    static <E> NavigableSet<E> navigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet, null);
    }

    @GwtIncompatible
    static <K, V> NavigableMap<K, V> navigableMap(NavigableMap<K, V> navigableMap) {
        return Synchronized.navigableMap(navigableMap, null);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static <K, V> NavigableMap<K, V> navigableMap(NavigableMap<K, V> navigableMap, Object mutex) {
        void var1_1;
        NavigableMap<K, V> navigableMap2;
        return new SynchronizedNavigableMap<K, V>(navigableMap2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static <K, V> Map.Entry<K, V> nullableSynchronizedEntry(Map.Entry<K, V> entry, Object mutex) {
        void var1_1;
        Map.Entry<K, V> entry2;
        if (entry == null) {
            return null;
        }
        return new SynchronizedEntry<K, V>(entry2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <E> Queue<E> queue(Queue<E> queue, Object mutex) {
        void var1_1;
        Queue<E> queue2;
        if (queue instanceof SynchronizedQueue) {
            return queue;
        }
        return new SynchronizedQueue<E>(queue2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <E> Deque<E> deque(Deque<E> deque, Object mutex) {
        void var1_1;
        Deque<E> deque2;
        return new SynchronizedDeque<E>(deque2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <R, C, V> Table<R, C, V> table(Table<R, C, V> table, Object mutex) {
        void var1_1;
        Table<R, C, V> table2;
        return new SynchronizedTable<R, C, V>(table2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SortedSet access$100(SortedSet x0, Object x1) {
        void var1_1;
        return Synchronized.sortedSet(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$200(List x0, Object x1) {
        void var1_1;
        return Synchronized.list(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Set access$300(Set x0, Object x1) {
        void var1_1;
        return Synchronized.typePreservingSet(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Collection access$400(Collection x0, Object x1) {
        void var1_1;
        return Synchronized.typePreservingCollection(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Collection access$500(Collection x0, Object x1) {
        void var1_1;
        return Synchronized.collection(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map.Entry access$700(Map.Entry x0, Object x1) {
        void var1_1;
        return Synchronized.nullableSynchronizedEntry(x0, var1_1);
    }

    private static final class SynchronizedTable<R, C, V>
    extends SynchronizedObject
    implements Table<R, C, V> {
        /*
         * WARNING - void declaration
         */
        SynchronizedTable(Table<R, C, V> delegate, Object mutex) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        final Table<R, C, V> delegate() {
            return (Table)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object rowKey, Object columnKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().contains(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsRow(Object rowKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsRow(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsColumn(Object columnKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsColumn(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsValue(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object rowKey, Object columnKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().get(var1_1, var2_3);
            }
        }

        @Override
        public final boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        @Override
        public final int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        @Override
        public final void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V put(R rowKey, C columnKey, V value) {
            Object object = this.mutex;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.delegate().put(var1_1, var2_3, var3_4);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().putAll(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V remove(Object rowKey, Object columnKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().remove(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<C, V> row(R rowKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.map(this.delegate().row(var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<R, V> column(C columnKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.map(this.delegate().column(var1_1), this.mutex);
            }
        }

        @Override
        public final Set<Table.Cell<R, C, V>> cellSet() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().cellSet(), this.mutex);
            }
        }

        @Override
        public final Set<R> rowKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().rowKeySet(), this.mutex);
            }
        }

        @Override
        public final Set<C> columnKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.set(this.delegate().columnKeySet(), this.mutex);
            }
        }

        @Override
        public final Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.access$500(this.delegate().values(), this.mutex);
            }
        }

        @Override
        public final Map<R, Map<C, V>> rowMap() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.map(Maps.transformValues(this.delegate().rowMap(), new Function<Map<C, V>, Map<C, V>>(this){
                    final /* synthetic */ SynchronizedTable this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public Map<C, V> apply(Map<C, V> t) {
                        return Synchronized.map(t, this.this$0.mutex);
                    }
                }), this.mutex);
            }
        }

        @Override
        public final Map<C, Map<R, V>> columnMap() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.map(Maps.transformValues(this.delegate().columnMap(), new Function<Map<R, V>, Map<R, V>>(this){
                    final /* synthetic */ SynchronizedTable this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public Map<R, V> apply(Map<R, V> t) {
                        return Synchronized.map(t, this.this$0.mutex);
                    }
                }), this.mutex);
            }
        }

        @Override
        public final int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().equals(var1_1);
            }
        }
    }

    private static final class SynchronizedDeque<E>
    extends SynchronizedQueue<E>
    implements Deque<E> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedDeque(Deque<E> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        final Deque<E> delegate() {
            return (Deque)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void addFirst(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().addFirst(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void addLast(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().addLast(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean offerFirst(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().offerFirst(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean offerLast(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().offerLast(var1_1);
            }
        }

        @Override
        public final E removeFirst() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeFirst();
            }
        }

        @Override
        public final E removeLast() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().removeLast();
            }
        }

        @Override
        public final E pollFirst() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().pollFirst();
            }
        }

        @Override
        public final E pollLast() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().pollLast();
            }
        }

        @Override
        public final E getFirst() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().getFirst();
            }
        }

        @Override
        public final E getLast() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().getLast();
            }
        }

        @Override
        public final E peekFirst() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().peekFirst();
            }
        }

        @Override
        public final E peekLast() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().peekLast();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeFirstOccurrence(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeFirstOccurrence(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeLastOccurrence(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeLastOccurrence(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void push(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().push(var1_1);
                return;
            }
        }

        @Override
        public final E pop() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().pop();
            }
        }

        @Override
        public final Iterator<E> descendingIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().descendingIterator();
            }
        }
    }

    private static class SynchronizedQueue<E>
    extends SynchronizedCollection<E>
    implements Queue<E> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedQueue(Queue<E> delegate, Object mutex) {
            super((Collection)var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Queue<E> delegate() {
            return (Queue)super.delegate();
        }

        @Override
        public E element() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().element();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean offer(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().offer(var1_1);
            }
        }

        @Override
        public E peek() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().peek();
            }
        }

        @Override
        public E poll() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().poll();
            }
        }

        @Override
        public E remove() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().remove();
            }
        }
    }

    @GwtIncompatible
    private static class SynchronizedEntry<K, V>
    extends SynchronizedObject
    implements Map.Entry<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedEntry(Map.Entry<K, V> delegate, Object mutex) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Map.Entry<K, V> delegate() {
            return (Map.Entry)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().equals(var1_1);
            }
        }

        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }

        @Override
        public K getKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().getKey();
            }
        }

        @Override
        public V getValue() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().getValue();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V setValue(V value) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().setValue(var1_1);
            }
        }
    }

    @GwtIncompatible
    @VisibleForTesting
    static class SynchronizedNavigableMap<K, V>
    extends SynchronizedSortedMap<K, V>
    implements NavigableMap<K, V> {
        transient NavigableSet<K> descendingKeySet;
        transient NavigableMap<K, V> descendingMap;
        transient NavigableSet<K> navigableKeySet;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedNavigableMap(NavigableMap<K, V> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        NavigableMap<K, V> delegate() {
            return (NavigableMap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$700(this.delegate().ceilingEntry(var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceilingKey(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().ceilingKey(var1_1);
            }
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.descendingKeySet == null) {
                    this.descendingKeySet = Synchronized.navigableSet(this.delegate().descendingKeySet(), this.mutex);
                    return this.descendingKeySet;
                }
                return this.descendingKeySet;
            }
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.descendingMap == null) {
                    this.descendingMap = Synchronized.navigableMap(this.delegate().descendingMap(), this.mutex);
                    return this.descendingMap;
                }
                return this.descendingMap;
            }
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.access$700(this.delegate().firstEntry(), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$700(this.delegate().floorEntry(var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floorKey(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().floorKey(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return Synchronized.navigableMap(this.delegate().headMap(var1_1, (boolean)var2_3), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(K toKey) {
            void var1_1;
            return this.headMap(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$700(this.delegate().higherEntry(var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higherKey(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().higherKey(var1_1);
            }
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.access$700(this.delegate().lastEntry(), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$700(this.delegate().lowerEntry(var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lowerKey(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().lowerKey(var1_1);
            }
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.navigableKeySet == null) {
                    this.navigableKeySet = Synchronized.navigableSet(this.delegate().navigableKeySet(), this.mutex);
                    return this.navigableKeySet;
                }
                return this.navigableKeySet;
            }
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.access$700(this.delegate().pollFirstEntry(), this.mutex);
            }
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return Synchronized.access$700(this.delegate().pollLastEntry(), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            Object object = this.mutex;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                return Synchronized.navigableMap(this.delegate().subMap(var1_1, (boolean)var2_3, var3_4, toInclusive), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            void var2_2;
            void var1_1;
            return this.subMap(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return Synchronized.navigableMap(this.delegate().tailMap(var1_1, (boolean)var2_3), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            void var1_1;
            return this.tailMap(var1_1, true);
        }
    }

    @GwtIncompatible
    @VisibleForTesting
    static class SynchronizedNavigableSet<E>
    extends SynchronizedSortedSet<E>
    implements NavigableSet<E> {
        transient NavigableSet<E> descendingSet;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedNavigableSet(NavigableSet<E> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        NavigableSet<E> delegate() {
            return (NavigableSet)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E ceiling(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().ceiling(var1_1);
            }
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.delegate().descendingIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> descendingSet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.descendingSet == null) {
                    void var2_2;
                    NavigableSet dS = Synchronized.navigableSet(this.delegate().descendingSet(), this.mutex);
                    this.descendingSet = dS;
                    return var2_2;
                }
                return this.descendingSet;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E floor(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().floor(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return Synchronized.navigableSet(this.delegate().headSet(var1_1, (boolean)var2_3), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> headSet(E toElement) {
            void var1_1;
            return this.headSet(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E higher(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().higher(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E lower(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().lower(var1_1);
            }
        }

        @Override
        public E pollFirst() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().pollFirst();
            }
        }

        @Override
        public E pollLast() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().pollLast();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            Object object = this.mutex;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                return Synchronized.navigableSet(this.delegate().subSet(var1_1, (boolean)var2_3, var3_4, toInclusive), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            void var2_2;
            void var1_1;
            return this.subSet(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return Synchronized.navigableSet(this.delegate().tailSet(var1_1, (boolean)var2_3), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> tailSet(E fromElement) {
            void var1_1;
            return this.tailSet(var1_1, true);
        }
    }

    private static class SynchronizedAsMapValues<V>
    extends SynchronizedCollection<Collection<V>> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedAsMapValues(Collection<Collection<V>> delegate, Object mutex) {
            super((Collection)var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public Iterator<Collection<V>> iterator() {
            SynchronizedAsMapValues synchronizedAsMapValues = this;
            return new TransformedIterator<Collection<V>, Collection<V>>(synchronizedAsMapValues, super.iterator()){
                final /* synthetic */ SynchronizedAsMapValues this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                @Override
                Collection<V> transform(Collection<V> from) {
                    return Synchronized.access$400(from, this.this$0.mutex);
                }
            };
        }
    }

    private static class SynchronizedAsMap<K, V>
    extends SynchronizedMap<K, Collection<V>> {
        transient Set<Map.Entry<K, Collection<V>>> asMapEntrySet;
        transient Collection<Collection<V>> asMapValues;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedAsMap(Map<K, Collection<V>> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                Collection collection = (Collection)super.get(key);
                return collection == null ? null : Synchronized.access$400((Collection)var1_1, this.mutex);
            }
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.asMapEntrySet == null) {
                    this.asMapEntrySet = new SynchronizedAsMapEntries(this.delegate().entrySet(), this.mutex);
                }
                return this.asMapEntrySet;
            }
        }

        @Override
        public Collection<Collection<V>> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.asMapValues == null) {
                    this.asMapValues = new SynchronizedAsMapValues(this.delegate().values(), this.mutex);
                }
                return this.asMapValues;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsValue(Object o) {
            void var1_1;
            return this.values().contains(var1_1);
        }
    }

    @VisibleForTesting
    static class SynchronizedBiMap<K, V>
    extends SynchronizedMap<K, V>
    implements BiMap<K, V>,
    Serializable {
        private transient Set<V> valueSet;
        private transient BiMap<V, K> inverse;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private SynchronizedBiMap(BiMap<K, V> delegate, Object mutex, BiMap<V, K> inverse) {
            super(var1_1, (Object)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.inverse = var3_3;
        }

        @Override
        BiMap<K, V> delegate() {
            return (BiMap)super.delegate();
        }

        @Override
        public Set<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.valueSet == null) {
                    this.valueSet = Synchronized.set(this.delegate().values(), this.mutex);
                }
                return this.valueSet;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V forcePut(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().forcePut(var1_1, var2_3);
            }
        }

        @Override
        public BiMap<V, K> inverse() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.inverse == null) {
                    this.inverse = new SynchronizedBiMap<K, V>(this.delegate().inverse(), this.mutex, this);
                }
                return this.inverse;
            }
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedSortedMap(SortedMap<K, V> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        SortedMap<K, V> delegate() {
            return (SortedMap)super.delegate();
        }

        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().comparator();
            }
        }

        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().firstKey();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.sortedMap(this.delegate().headMap(var1_1), this.mutex);
            }
        }

        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().lastKey();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return Synchronized.sortedMap(this.delegate().subMap(var1_1, var2_3), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.sortedMap(this.delegate().tailMap(var1_1), this.mutex);
            }
        }
    }

    private static class SynchronizedMap<K, V>
    extends SynchronizedObject
    implements Map<K, V> {
        transient Set<K> keySet;
        transient Collection<V> values;
        transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedMap(Map<K, V> delegate, Object mutex) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Map<K, V> delegate() {
            return (Map)super.delegate();
        }

        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsKey(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsValue(var1_1);
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.set(this.delegate().entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().forEach(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().get(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getOrDefault(Object key, V defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().getOrDefault(var1_1, var2_3);
            }
        }

        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Synchronized.set(this.delegate().keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().put(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V putIfAbsent(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().putIfAbsent(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.delegate().replace(var1_1, var2_3, var3_4);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V replace(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().replace(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V computeIfAbsent(K key, java.util.function.Function<? super K, ? extends V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().computeIfAbsent(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().computeIfPresent(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().compute(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.delegate().merge(var1_1, var2_3, var3_4);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().putAll(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().replaceAll(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().remove(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().remove(var1_1, var2_3);
            }
        }

        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = Synchronized.access$500(this.delegate().values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().equals(var1_1);
            }
        }

        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    private static class SynchronizedAsMapEntries<K, V>
    extends SynchronizedSet<Map.Entry<K, Collection<V>>> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedAsMapEntries(Set<Map.Entry<K, Collection<V>>> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            SynchronizedAsMapEntries synchronizedAsMapEntries = this;
            return new TransformedIterator<Map.Entry<K, Collection<V>>, Map.Entry<K, Collection<V>>>(synchronizedAsMapEntries, super.iterator()){
                final /* synthetic */ SynchronizedAsMapEntries this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                Map.Entry<K, Collection<V>> transform(Map.Entry<K, Collection<V>> entry) {
                    void var1_1;
                    return new ForwardingMapEntry<K, Collection<V>>(this, (Map.Entry)var1_1){
                        final /* synthetic */ Map.Entry val$entry;
                        final /* synthetic */ 1 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                            this.val$entry = entry;
                        }

                        @Override
                        protected Map.Entry<K, Collection<V>> delegate() {
                            return this.val$entry;
                        }

                        @Override
                        public Collection<V> getValue() {
                            return Synchronized.access$400((Collection)this.val$entry.getValue(), this.this$1.this$0.mutex);
                        }
                    };
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                Object[] objectArray = ObjectArrays.toArrayImpl(this.delegate());
                return objectArray;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] array) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return ObjectArrays.toArrayImpl(this.delegate(), var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Maps.containsEntryImpl(this.delegate(), var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Collections2.containsAllImpl(this.delegate(), var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Sets.equalsImpl(this.delegate(), var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Maps.removeEntryImpl(this.delegate(), var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Iterators.removeAll(this.delegate().iterator(), var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Iterators.retainAll(this.delegate().iterator(), var1_1);
            }
        }
    }

    private static class SynchronizedSortedSetMultimap<K, V>
    extends SynchronizedSetMultimap<K, V>
    implements SortedSetMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedSortedSetMultimap(SortedSetMultimap<K, V> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        SortedSetMultimap<K, V> delegate() {
            return (SortedSetMultimap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<V> get(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$100((SortedSet)this.delegate().get((Object)var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<V> removeAll(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeAll(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<V> replaceValues(K key, Iterable<? extends V> values) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().replaceValues((Object)var1_1, (Iterable)var2_3);
            }
        }

        @Override
        public Comparator<? super V> valueComparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().valueComparator();
            }
        }
    }

    private static class SynchronizedSetMultimap<K, V>
    extends SynchronizedMultimap<K, V>
    implements SetMultimap<K, V> {
        transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedSetMultimap(SetMultimap<K, V> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        SetMultimap<K, V> delegate() {
            return (SetMultimap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<V> get(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.set(this.delegate().get((Object)var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<V> removeAll(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeAll(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<V> replaceValues(K key, Iterable<? extends V> values) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().replaceValues((Object)var1_1, (Iterable)var2_3);
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entries() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.set(this.delegate().entries(), this.mutex);
                }
                return this.entrySet;
            }
        }
    }

    private static class SynchronizedListMultimap<K, V>
    extends SynchronizedMultimap<K, V>
    implements ListMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedListMultimap(ListMultimap<K, V> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        ListMultimap<K, V> delegate() {
            return (ListMultimap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<V> get(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$200((List)this.delegate().get((Object)var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<V> removeAll(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeAll(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<V> replaceValues(K key, Iterable<? extends V> values) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().replaceValues((Object)var1_1, (Iterable)var2_3);
            }
        }
    }

    private static class SynchronizedMultimap<K, V>
    extends SynchronizedObject
    implements Multimap<K, V> {
        transient Set<K> keySet;
        transient Collection<V> valuesCollection;
        transient Collection<Map.Entry<K, V>> entries;
        transient Map<K, Collection<V>> asMap;
        transient Multiset<K> keys;
        private static final long serialVersionUID = 0L;

        @Override
        Multimap<K, V> delegate() {
            return (Multimap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        SynchronizedMultimap(Multimap<K, V> delegate, Object mutex) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsKey(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsValue(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsEntry(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().containsEntry(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> get(K key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$400(this.delegate().get(var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().put(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean putAll(K key, Iterable<? extends V> values) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().putAll(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().putAll(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().replaceValues(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().remove(var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> removeAll(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeAll(var1_1);
            }
        }

        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Synchronized.access$300(this.delegate().keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.valuesCollection == null) {
                    this.valuesCollection = Synchronized.access$500(this.delegate().values(), this.mutex);
                }
                return this.valuesCollection;
            }
        }

        @Override
        public Collection<Map.Entry<K, V>> entries() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entries == null) {
                    this.entries = Synchronized.access$400(this.delegate().entries(), this.mutex);
                }
                return this.entries;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().forEach(var1_1);
                return;
            }
        }

        @Override
        public Map<K, Collection<V>> asMap() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.asMap == null) {
                    this.asMap = new SynchronizedAsMap(this.delegate().asMap(), this.mutex);
                }
                return this.asMap;
            }
        }

        @Override
        public Multiset<K> keys() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keys == null) {
                    this.keys = Synchronized.multiset(this.delegate().keys(), this.mutex);
                }
                return this.keys;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().equals(var1_1);
            }
        }

        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    private static class SynchronizedMultiset<E>
    extends SynchronizedCollection<E>
    implements Multiset<E> {
        transient Set<E> elementSet;
        transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedMultiset(Multiset<E> delegate, Object mutex) {
            super((Collection)var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Multiset<E> delegate() {
            return (Multiset)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int count(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().count(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int add(E e, int n) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().add(var1_1, (int)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int remove(Object o, int n) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().remove(var1_1, (int)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int setCount(E element, int count) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().setCount(var1_1, (int)var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean setCount(E element, int oldCount, int newCount) {
            Object object = this.mutex;
            synchronized (object) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.delegate().setCount(var1_1, (int)var2_3, (int)var3_4);
            }
        }

        @Override
        public Set<E> elementSet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.elementSet == null) {
                    this.elementSet = Synchronized.access$300(this.delegate().elementSet(), this.mutex);
                }
                return this.elementSet;
            }
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.access$300(this.delegate().entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().equals(var1_1);
            }
        }

        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    private static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedRandomAccessList(List<E> list, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    private static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedList(List<E> delegate, Object mutex) {
            super((Collection)var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        List<E> delegate() {
            return (List)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(int index, E element) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                this.delegate().add((int)var1_1, var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().addAll((int)var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().get((int)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().indexOf(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().lastIndexOf(var1_1);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.delegate().listIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ListIterator<E> listIterator(int index) {
            void var1_1;
            return this.delegate().listIterator((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().remove((int)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E set(int index, E element) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return this.delegate().set((int)var1_1, var2_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().replaceAll(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void sort(Comparator<? super E> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().sort(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return Synchronized.access$200(this.delegate().subList((int)var1_1, (int)var2_3), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().equals(var1_1);
            }
        }

        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedSortedSet(SortedSet<E> delegate, Object mutex) {
            super(var1_1, (Object)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        SortedSet<E> delegate() {
            return (SortedSet)super.delegate();
        }

        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().comparator();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            Object object = this.mutex;
            synchronized (object) {
                void var2_3;
                void var1_1;
                return Synchronized.access$100(this.delegate().subSet(var1_1, var2_3), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> headSet(E toElement) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$100(this.delegate().headSet(var1_1), this.mutex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> tailSet(E fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return Synchronized.access$100(this.delegate().tailSet(var1_1), this.mutex);
            }
        }

        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().first();
            }
        }

        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().last();
            }
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedSet(Set<E> delegate, Object mutex) {
            super((Collection)var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Set<E> delegate() {
            return (Set)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().equals(var1_1);
            }
        }

        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().hashCode();
            }
        }
    }

    @VisibleForTesting
    static class SynchronizedCollection<E>
    extends SynchronizedObject
    implements Collection<E> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private SynchronizedCollection(Collection<E> delegate, Object mutex) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        Collection<E> delegate() {
            return (Collection)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().add(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().addAll(var1_1);
            }
        }

        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.delegate().clear();
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().contains(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().containsAll((Collection<?>)var1_1);
            }
        }

        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().isEmpty();
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate().iterator();
        }

        @Override
        public Spliterator<E> spliterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().spliterator();
            }
        }

        @Override
        public Stream<E> stream() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().stream();
            }
        }

        @Override
        public Stream<E> parallelStream() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().parallelStream();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(Consumer<? super E> action) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                this.delegate().forEach(var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().remove(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeAll((Collection<?>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().retainAll((Collection<?>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().removeIf(var1_1);
            }
        }

        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().size();
            }
        }

        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate().toArray();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                return this.delegate().toArray((T[])var1_1);
            }
        }
    }

    static class SynchronizedObject
    implements Serializable {
        final Object delegate;
        final Object mutex;
        @GwtIncompatible
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SynchronizedObject(Object delegate, Object mutex) {
            void var2_2;
            void var1_1;
            this.delegate = Preconditions.checkNotNull(var1_1);
            this.mutex = mutex == null ? this : var2_2;
        }

        Object delegate() {
            return this.delegate;
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.delegate.toString();
            }
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                void var1_1;
                var1_1.defaultWriteObject();
                return;
            }
        }
    }
}

