/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.math.LongMath;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Streams {
    public static <T> Stream<T> stream(Iterable<T> iterable) {
        Iterable<T> iterable2;
        if (iterable instanceof Collection) {
            return ((Collection)iterable).stream();
        }
        return StreamSupport.stream(iterable2.spliterator(), false);
    }

    @Deprecated
    @Beta
    public static <T> Stream<T> stream(Collection<T> collection) {
        return collection.stream();
    }

    @Beta
    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    @Beta
    public static <T> Stream<T> stream(com.google.common.base.Optional<T> optional) {
        if (optional.isPresent()) {
            com.google.common.base.Optional<T> optional2;
            return Stream.of(optional2.get());
        }
        return Stream.empty();
    }

    @Beta
    public static <T> Stream<T> stream(Optional<T> optional) {
        if (optional.isPresent()) {
            Optional<T> optional2;
            return Stream.of(optional2.get());
        }
        return Stream.empty();
    }

    @Beta
    public static IntStream stream(OptionalInt optional) {
        if (optional.isPresent()) {
            OptionalInt optionalInt;
            return IntStream.of(optionalInt.getAsInt());
        }
        return IntStream.empty();
    }

    @Beta
    public static LongStream stream(OptionalLong optional) {
        if (optional.isPresent()) {
            OptionalLong optionalLong;
            return LongStream.of(optionalLong.getAsLong());
        }
        return LongStream.empty();
    }

    @Beta
    public static DoubleStream stream(OptionalDouble optional) {
        if (optional.isPresent()) {
            OptionalDouble optionalDouble;
            return DoubleStream.of(optionalDouble.getAsDouble());
        }
        return DoubleStream.empty();
    }

    private static void closeAll(BaseStream<?, ?>[] toClose) {
        BaseStream<?, ?>[] baseStreamArray = toClose;
        int n = toClose.length;
        for (int i = 0; i < n; ++i) {
            BaseStream<?, ?> baseStream = baseStreamArray[i];
            baseStream.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        Stream<? extends T>[] streamArray;
        void var1_1;
        void var3_3;
        void var2_2;
        boolean isParallel = false;
        int characteristics = 336;
        long estimatedSize = 0L;
        ImmutableList.Builder splitrsBuilder = new ImmutableList.Builder(streams.length);
        Stream<? extends T>[] streamArray2 = streams;
        int n = streams.length;
        for (int i = 0; i < n; ++i) {
            Stream<T> stream = streamArray2[i];
            isParallel |= stream.isParallel();
            Spliterator splitr2 = stream.spliterator();
            splitrsBuilder.add(splitr2);
            characteristics &= splitr2.characteristics();
            estimatedSize = LongMath.saturatedAdd(estimatedSize, splitr2.estimateSize());
        }
        return (Stream)StreamSupport.stream(CollectSpliterators.flatMap(splitrsBuilder.build().spliterator(), splitr -> splitr, (int)var2_2, (long)var3_3), (boolean)var1_1).onClose(() -> Streams.closeAll(streamArray));
    }

    /*
     * WARNING - void declaration
     */
    public static IntStream concat(IntStream ... streams) {
        IntStream[] intStreamArray;
        void var1_1;
        void var3_3;
        void var2_2;
        boolean isParallel = false;
        int characteristics = 336;
        long estimatedSize = 0L;
        ImmutableList.Builder splitrsBuilder = new ImmutableList.Builder(streams.length);
        IntStream[] intStreamArray2 = streams;
        int n = streams.length;
        for (int i = 0; i < n; ++i) {
            IntStream stream = intStreamArray2[i];
            isParallel |= stream.isParallel();
            Spliterator.OfInt splitr2 = stream.spliterator();
            splitrsBuilder.add(splitr2);
            characteristics &= splitr2.characteristics();
            estimatedSize = LongMath.saturatedAdd(estimatedSize, splitr2.estimateSize());
        }
        return (IntStream)StreamSupport.intStream(CollectSpliterators.flatMapToInt(splitrsBuilder.build().spliterator(), splitr -> splitr, (int)var2_2, (long)var3_3), (boolean)var1_1).onClose(() -> Streams.closeAll(intStreamArray));
    }

    /*
     * WARNING - void declaration
     */
    public static LongStream concat(LongStream ... streams) {
        LongStream[] longStreamArray;
        void var1_1;
        void var3_3;
        void var2_2;
        boolean isParallel = false;
        int characteristics = 336;
        long estimatedSize = 0L;
        ImmutableList.Builder splitrsBuilder = new ImmutableList.Builder(streams.length);
        LongStream[] longStreamArray2 = streams;
        int n = streams.length;
        for (int i = 0; i < n; ++i) {
            LongStream stream = longStreamArray2[i];
            isParallel |= stream.isParallel();
            Spliterator.OfLong splitr2 = stream.spliterator();
            splitrsBuilder.add(splitr2);
            characteristics &= splitr2.characteristics();
            estimatedSize = LongMath.saturatedAdd(estimatedSize, splitr2.estimateSize());
        }
        return (LongStream)StreamSupport.longStream(CollectSpliterators.flatMapToLong(splitrsBuilder.build().spliterator(), splitr -> splitr, (int)var2_2, (long)var3_3), (boolean)var1_1).onClose(() -> Streams.closeAll(longStreamArray));
    }

    /*
     * WARNING - void declaration
     */
    public static DoubleStream concat(DoubleStream ... streams) {
        DoubleStream[] doubleStreamArray;
        void var1_1;
        void var3_3;
        void var2_2;
        boolean isParallel = false;
        int characteristics = 336;
        long estimatedSize = 0L;
        ImmutableList.Builder splitrsBuilder = new ImmutableList.Builder(streams.length);
        DoubleStream[] doubleStreamArray2 = streams;
        int n = streams.length;
        for (int i = 0; i < n; ++i) {
            DoubleStream stream = doubleStreamArray2[i];
            isParallel |= stream.isParallel();
            Spliterator.OfDouble splitr2 = stream.spliterator();
            splitrsBuilder.add(splitr2);
            characteristics &= splitr2.characteristics();
            estimatedSize = LongMath.saturatedAdd(estimatedSize, splitr2.estimateSize());
        }
        return (DoubleStream)StreamSupport.doubleStream(CollectSpliterators.flatMapToDouble(splitrsBuilder.build().spliterator(), splitr -> splitr, (int)var2_2, (long)var3_3), (boolean)var1_1).onClose(() -> Streams.closeAll(doubleStreamArray));
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <A, B, R> Stream<R> zip(Stream<A> streamA, Stream<B> streamB, BiFunction<? super A, ? super B, R> function) {
        void var1_1;
        Stream<A> stream;
        void var3_3;
        void var2_2;
        Preconditions.checkNotNull(streamA);
        Preconditions.checkNotNull(streamB);
        Preconditions.checkNotNull(function);
        boolean isParallel = streamA.isParallel() || streamB.isParallel();
        Spliterator splitrA = streamA.spliterator();
        Spliterator splitrB = streamB.spliterator();
        int characteristics = splitrA.characteristics() & splitrB.characteristics() & 0x50;
        final Iterator itrA = Spliterators.iterator(splitrA);
        final Iterator itrB = Spliterators.iterator(splitrB);
        return (Stream)((Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(Math.min(splitrA.estimateSize(), splitrB.estimateSize()), characteristics, (BiFunction)var2_2){
            final /* synthetic */ BiFunction val$function;
            {
                void var3_2;
                void var1_1;
                this.val$function = biFunction;
                super((long)var1_1, (int)var3_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                if (itrA.hasNext() && itrB.hasNext()) {
                    void var1_1;
                    var1_1.accept(this.val$function.apply(itrA.next(), itrB.next()));
                    return true;
                }
                return false;
            }
        }, (boolean)var3_3).onClose(stream::close)).onClose(((Stream)var1_1)::close);
    }

    @Beta
    public static <A, B> void forEachPair(Stream<A> streamA, Stream<B> streamB, BiConsumer<? super A, ? super B> consumer) {
        Preconditions.checkNotNull(consumer);
        if (streamA.isParallel() || streamB.isParallel()) {
            Streams.zip(streamA, streamB, TemporaryPair::new).forEach(pair -> {
                void var1_1;
                consumer.accept(pair.a, var1_1.b);
            });
            return;
        }
        Iterator iterA = streamA.iterator();
        Iterator iterB = streamB.iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            consumer.accept(iterA.next(), iterB.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> Stream<R> mapWithIndex(Stream<T> stream, final FunctionWithIndex<? super T, ? extends R> function) {
        Stream<T> stream2;
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(function);
        boolean isParallel = stream.isParallel();
        Spliterator fromSpliterator = stream.spliterator();
        if (!fromSpliterator.hasCharacteristics(16384)) {
            final Iterator fromIterator = Spliterators.iterator(fromSpliterator);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(fromSpliterator.estimateSize(), fromSpliterator.characteristics() & 0x50){
                long index;
                {
                    void var3_2;
                    void var1_1;
                    super((long)var1_1, (int)var3_2);
                    this.index = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (fromIterator.hasNext()) {
                        void var1_1;
                        var1_1.accept(function.apply(fromIterator.next(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, isParallel).onClose(stream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator<T>, R, Splitr>
        implements Consumer<T> {
            T holder;
            final /* synthetic */ FunctionWithIndex val$function;

            /*
             * WARNING - void declaration
             */
            Splitr(Spliterator<T> splitr, long index) {
                void var2_2;
                void var1_1;
                this.val$function = var4_3;
                super(var1_1, (long)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void accept(@ParametricNullness T t) {
                void var1_1;
                this.holder = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                if (this.fromSpliterator.tryAdvance(this)) {
                    try {
                        void var1_1;
                        var1_1.accept(this.val$function.apply(NullnessCasts.uncheckedCastNullableTToT(this.holder), this.index++));
                        return true;
                    }
                    finally {
                        this.holder = null;
                    }
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Splitr createSplit(Spliterator<T> from, long i) {
                void var2_2;
                void var1_1;
                return new Splitr((Spliterator)var1_1, (long)var2_2, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr((Spliterator)var3_3, 0L, (FunctionWithIndex)var1_1), (boolean)var2_2).onClose(stream2::close);
    }

    /*
     * WARNING - void declaration
     */
    public static <R> Stream<R> mapWithIndex(IntStream stream, final IntFunctionWithIndex<R> function) {
        IntStream intStream;
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(function);
        boolean isParallel = stream.isParallel();
        Spliterator.OfInt fromSpliterator = stream.spliterator();
        if (!fromSpliterator.hasCharacteristics(16384)) {
            final PrimitiveIterator.OfInt fromIterator = Spliterators.iterator(fromSpliterator);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(fromSpliterator.estimateSize(), fromSpliterator.characteristics() & 0x50){
                long index;
                {
                    void var3_2;
                    void var1_1;
                    super((long)var1_1, (int)var3_2);
                    this.index = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (fromIterator.hasNext()) {
                        void var1_1;
                        var1_1.accept(function.apply(fromIterator.nextInt(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, isParallel).onClose(stream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator.OfInt, R, Splitr>
        implements Spliterator<R>,
        IntConsumer {
            int holder;
            final /* synthetic */ IntFunctionWithIndex val$function;

            /*
             * WARNING - void declaration
             */
            Splitr(Spliterator.OfInt splitr, long index) {
                void var2_2;
                void var1_1;
                this.val$function = var4_3;
                super(var1_1, (long)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void accept(int t) {
                void var1_1;
                this.holder = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                if (((Spliterator.OfInt)this.fromSpliterator).tryAdvance(this)) {
                    void var1_1;
                    var1_1.accept(this.val$function.apply(this.holder, this.index++));
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Splitr createSplit(Spliterator.OfInt from, long i) {
                void var2_2;
                void var1_1;
                return new Splitr((Spliterator.OfInt)var1_1, (long)var2_2, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr((Spliterator.OfInt)var3_3, 0L, (IntFunctionWithIndex)var1_1), (boolean)var2_2).onClose(intStream::close);
    }

    /*
     * WARNING - void declaration
     */
    public static <R> Stream<R> mapWithIndex(LongStream stream, final LongFunctionWithIndex<R> function) {
        LongStream longStream;
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(function);
        boolean isParallel = stream.isParallel();
        Spliterator.OfLong fromSpliterator = stream.spliterator();
        if (!fromSpliterator.hasCharacteristics(16384)) {
            final PrimitiveIterator.OfLong fromIterator = Spliterators.iterator(fromSpliterator);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(fromSpliterator.estimateSize(), fromSpliterator.characteristics() & 0x50){
                long index;
                {
                    void var3_2;
                    void var1_1;
                    super((long)var1_1, (int)var3_2);
                    this.index = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (fromIterator.hasNext()) {
                        void var1_1;
                        var1_1.accept(function.apply(fromIterator.nextLong(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, isParallel).onClose(stream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator.OfLong, R, Splitr>
        implements Spliterator<R>,
        LongConsumer {
            long holder;
            final /* synthetic */ LongFunctionWithIndex val$function;

            /*
             * WARNING - void declaration
             */
            Splitr(Spliterator.OfLong splitr, long index) {
                void var2_2;
                void var1_1;
                this.val$function = var4_3;
                super(var1_1, (long)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void accept(long t) {
                void var1_1;
                this.holder = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                if (((Spliterator.OfLong)this.fromSpliterator).tryAdvance(this)) {
                    void var1_1;
                    var1_1.accept(this.val$function.apply(this.holder, this.index++));
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Splitr createSplit(Spliterator.OfLong from, long i) {
                void var2_2;
                void var1_1;
                return new Splitr((Spliterator.OfLong)var1_1, (long)var2_2, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr((Spliterator.OfLong)var3_3, 0L, (LongFunctionWithIndex)var1_1), (boolean)var2_2).onClose(longStream::close);
    }

    /*
     * WARNING - void declaration
     */
    public static <R> Stream<R> mapWithIndex(DoubleStream stream, final DoubleFunctionWithIndex<R> function) {
        DoubleStream doubleStream;
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(function);
        boolean isParallel = stream.isParallel();
        Spliterator.OfDouble fromSpliterator = stream.spliterator();
        if (!fromSpliterator.hasCharacteristics(16384)) {
            final PrimitiveIterator.OfDouble fromIterator = Spliterators.iterator(fromSpliterator);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(fromSpliterator.estimateSize(), fromSpliterator.characteristics() & 0x50){
                long index;
                {
                    void var3_2;
                    void var1_1;
                    super((long)var1_1, (int)var3_2);
                    this.index = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    if (fromIterator.hasNext()) {
                        void var1_1;
                        var1_1.accept(function.apply(fromIterator.nextDouble(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, isParallel).onClose(stream::close);
        }
        class Splitr
        extends MapWithIndexSpliterator<Spliterator.OfDouble, R, Splitr>
        implements Spliterator<R>,
        DoubleConsumer {
            double holder;
            final /* synthetic */ DoubleFunctionWithIndex val$function;

            /*
             * WARNING - void declaration
             */
            Splitr(Spliterator.OfDouble splitr, long index) {
                void var2_2;
                void var1_1;
                this.val$function = var4_3;
                super(var1_1, (long)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void accept(double t) {
                void var1_1;
                this.holder = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                if (((Spliterator.OfDouble)this.fromSpliterator).tryAdvance(this)) {
                    void var1_1;
                    var1_1.accept(this.val$function.apply(this.holder, this.index++));
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Splitr createSplit(Spliterator.OfDouble from, long i) {
                void var2_2;
                void var1_1;
                return new Splitr((Spliterator.OfDouble)var1_1, (long)var2_2, this.val$function);
            }
        }
        return (Stream)StreamSupport.stream(new Splitr((Spliterator.OfDouble)var3_3, 0L, (DoubleFunctionWithIndex)var1_1), (boolean)var2_2).onClose(doubleStream::close);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Optional<T> findLast(Stream<T> stream) {
        class OptionalState {
            boolean set = false;
            T value = null;

            OptionalState() {
            }

            /*
             * WARNING - void declaration
             */
            void set(T value) {
                void var1_1;
                this.set = true;
                this.value = var1_1;
            }

            T get() {
                return Objects.requireNonNull(this.value);
            }
        }
        OptionalState state = new OptionalState();
        ArrayDeque<Object> splits = new ArrayDeque<Object>();
        splits.addLast(stream.spliterator());
        while (!splits.isEmpty()) {
            Spliterator spliterator;
            void var3_3;
            block7: {
                Spliterator spliterator2;
                block6: {
                    Spliterator prefix;
                    spliterator2 = (Spliterator)splits.removeLast();
                    if (spliterator2.getExactSizeIfKnown() == 0L) continue;
                    if (spliterator2.hasCharacteristics(16384)) {
                        while ((prefix = spliterator2.trySplit()) != null && prefix.getExactSizeIfKnown() != 0L) {
                            if (spliterator2.getExactSizeIfKnown() != 0L) continue;
                            spliterator2 = prefix;
                            break;
                        }
                        spliterator2.forEachRemaining(state::set);
                        return Optional.of(state.get());
                    }
                    prefix = spliterator2.trySplit();
                    if (prefix == null) break block6;
                    if (prefix.getExactSizeIfKnown() != 0L) break block7;
                }
                spliterator2.forEachRemaining(state::set);
                if (!state.set) continue;
                return Optional.of(state.get());
            }
            splits.addLast(var3_3);
            splits.addLast(spliterator);
        }
        return Optional.empty();
    }

    public static OptionalInt findLast(IntStream stream) {
        Optional<Integer> optional = Streams.findLast(stream.boxed());
        return optional.map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public static OptionalLong findLast(LongStream stream) {
        Optional<Long> optional = Streams.findLast(stream.boxed());
        return optional.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    public static OptionalDouble findLast(DoubleStream stream) {
        Optional<Double> optional = Streams.findLast(stream.boxed());
        return optional.map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    private Streams() {
    }

    public static interface DoubleFunctionWithIndex<R> {
        @ParametricNullness
        public R apply(double var1, long var3);
    }

    public static interface LongFunctionWithIndex<R> {
        @ParametricNullness
        public R apply(long var1, long var3);
    }

    public static interface IntFunctionWithIndex<R> {
        @ParametricNullness
        public R apply(int var1, long var2);
    }

    private static abstract class MapWithIndexSpliterator<F extends Spliterator<?>, R, S extends MapWithIndexSpliterator<F, R, S>>
    implements Spliterator<R> {
        final F fromSpliterator;
        long index;

        /*
         * WARNING - void declaration
         */
        MapWithIndexSpliterator(F fromSpliterator, long index) {
            void var2_2;
            void var1_1;
            this.fromSpliterator = var1_1;
            this.index = var2_2;
        }

        abstract S createSplit(F var1, long var2);

        /*
         * WARNING - void declaration
         */
        public S trySplit() {
            void var2_2;
            void var1_1;
            void split;
            Spliterator splitOrNull = this.fromSpliterator.trySplit();
            if (splitOrNull == null) {
                return null;
            }
            S result = this.createSplit(split, this.index);
            this.index += var1_1.getExactSizeIfKnown();
            return var2_2;
        }

        @Override
        public long estimateSize() {
            return this.fromSpliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.fromSpliterator.characteristics() & 0x4050;
        }
    }

    public static interface FunctionWithIndex<T, R> {
        @ParametricNullness
        public R apply(@ParametricNullness T var1, long var2);
    }

    private static class TemporaryPair<A, B> {
        @ParametricNullness
        final A a;
        @ParametricNullness
        final B b;

        /*
         * WARNING - void declaration
         */
        TemporaryPair(@ParametricNullness A a, @ParametricNullness B b) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }
    }
}

