/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.GwtTransient;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class StandardTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    @GwtTransient
    final Map<R, Map<C, V>> backingMap;
    @GwtTransient
    final Supplier<? extends Map<C, V>> factory;
    private transient Set<C> columnKeySet;
    private transient Map<R, Map<C, V>> rowMap;
    private transient ColumnMap columnMap;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    StandardTable(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        void var2_2;
        void var1_1;
        this.backingMap = var1_1;
        this.factory = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        return rowKey != null && columnKey != null && super.contains(var1_1, var2_2);
    }

    @Override
    public boolean containsColumn(Object columnKey) {
        if (columnKey == null) {
            return false;
        }
        for (Map<C, V> map : this.backingMap.values()) {
            if (!Maps.safeContainsKey(map, columnKey)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsRow(Object rowKey) {
        void var1_1;
        return rowKey != null && Maps.safeContainsKey(this.backingMap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return value != null && super.containsValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        if (rowKey == null || columnKey == null) {
            return null;
        }
        return super.get(var1_1, var2_2);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        void var1_1;
        int size = 0;
        for (Map<C, V> map : this.backingMap.values()) {
            void var3_3;
            size += var3_3.size();
        }
        return (int)var1_1;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    private Map<C, V> getOrCreate(R rowKey) {
        void var2_2;
        Map<C, V> map = this.backingMap.get(rowKey);
        if (map == null) {
            void var1_1;
            map = this.factory.get();
            this.backingMap.put(var1_1, map);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(R rowKey, C columnKey, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(columnKey);
        Preconditions.checkNotNull(value);
        return this.getOrCreate(var1_1).put(var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object rowKey, Object columnKey) {
        void var2_2;
        void var3_3;
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, rowKey);
        if (map == null) {
            return null;
        }
        V value = map.remove(columnKey);
        if (var3_3.isEmpty()) {
            void var1_1;
            this.backingMap.remove(var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<R, V> removeColumn(Object column) {
        void var2_2;
        LinkedHashMap<R, V> output = new LinkedHashMap<R, V>();
        Iterator<Map.Entry<R, Map<C, V>>> iterator = this.backingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<R, Map<C, V>> entry = iterator.next();
            V value = entry.getValue().remove(column);
            if (value == null) continue;
            output.put(entry.getKey(), value);
            if (!entry.getValue().isEmpty()) continue;
            iterator.remove();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean containsMapping(Object rowKey, Object columnKey, Object value) {
        void var2_2;
        void var1_1;
        void var3_3;
        return value != null && var3_3.equals(this.get(var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private boolean removeMapping(Object rowKey, Object columnKey, Object value) {
        void var3_3;
        if (this.containsMapping(rowKey, columnKey, var3_3)) {
            void var2_2;
            void var1_1;
            this.remove(var1_1, var2_2);
            return true;
        }
        return false;
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new CellIterator();
    }

    @Override
    Spliterator<Table.Cell<R, C, V>> cellSpliterator() {
        return CollectSpliterators.flatMap(this.backingMap.entrySet().spliterator(), rowEntry -> {
            Map.Entry entry;
            return CollectSpliterators.map(((Map)rowEntry.getValue()).entrySet().spliterator(), columnEntry -> {
                void var1_1;
                return Tables.immutableCell(entry.getKey(), columnEntry.getKey(), var1_1.getValue());
            });
        }, 65, this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<C, V> row(R rowKey) {
        void var1_1;
        return new Row(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<R, V> column(C columnKey) {
        void var1_1;
        return new Column(var1_1);
    }

    @Override
    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<C> columnKeySet() {
        void var1_1;
        Set<C> result = this.columnKeySet;
        if (result == null) {
            this.columnKeySet = new ColumnKeySet();
            return this.columnKeySet;
        }
        return var1_1;
    }

    Iterator<C> createColumnKeyIterator() {
        return new ColumnKeyIterator();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<R, Map<C, V>> rowMap() {
        void var1_1;
        Map<R, Map<C, V>> result = this.rowMap;
        if (result == null) {
            this.rowMap = this.createRowMap();
            return this.rowMap;
        }
        return var1_1;
    }

    Map<R, Map<C, V>> createRowMap() {
        return new RowMap(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<C, Map<R, V>> columnMap() {
        void var1_1;
        ColumnMap result = this.columnMap;
        if (result == null) {
            this.columnMap = new ColumnMap();
            return this.columnMap;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$300(StandardTable x0, Object x1, Object x2, Object x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.containsMapping(var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$400(StandardTable x0, Object x1, Object x2, Object x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.removeMapping(var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$900(StandardTable x0, Object x1) {
        void var1_1;
        return x0.removeColumn(var1_1);
    }

    private class ColumnMap
    extends Maps.ViewCachingAbstractMap<C, Map<R, V>> {
        private ColumnMap() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<R, V> get(Object key) {
            if (StandardTable.this.containsColumn(key)) {
                void var1_1;
                return StandardTable.this.column(Objects.requireNonNull(var1_1));
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return StandardTable.this.containsColumn(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<R, V> remove(Object key) {
            if (StandardTable.this.containsColumn(key)) {
                void var1_1;
                return StandardTable.access$900(StandardTable.this, var1_1);
            }
            return null;
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> createEntrySet() {
            return new ColumnMapEntrySet();
        }

        @Override
        public Set<C> keySet() {
            return StandardTable.this.columnKeySet();
        }

        @Override
        Collection<Map<R, V>> createValues() {
            return new ColumnMapValues();
        }

        private class ColumnMapValues
        extends Maps.Values<C, Map<R, V>> {
            ColumnMapValues() {
                super(ColumnMap.this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object obj) {
                for (Map.Entry entry : ColumnMap.this.entrySet()) {
                    void var3_3;
                    if (!((Map)entry.getValue()).equals(obj)) continue;
                    StandardTable.access$900(StandardTable.this, var3_3.getKey());
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean removeAll(Collection<?> c) {
                void var2_2;
                Preconditions.checkNotNull(c);
                boolean changed = false;
                for (Object columnKey : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (!c.contains(StandardTable.this.column(columnKey))) continue;
                    StandardTable.access$900(StandardTable.this, columnKey);
                    changed = true;
                }
                return (boolean)var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean retainAll(Collection<?> c) {
                void var2_2;
                Preconditions.checkNotNull(c);
                boolean changed = false;
                for (Object columnKey : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (c.contains(StandardTable.this.column(columnKey))) continue;
                    StandardTable.access$900(StandardTable.this, columnKey);
                    changed = true;
                }
                return (boolean)var2_2;
            }
        }

        class ColumnMapEntrySet
        extends TableSet<Map.Entry<C, Map<R, V>>> {
            /*
             * WARNING - void declaration
             */
            ColumnMapEntrySet() {
                void var1_1;
            }

            @Override
            public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
                return Maps.asMapEntryIterator(StandardTable.this.columnKeySet(), new Function<C, Map<R, V>>(this){
                    final /* synthetic */ ColumnMapEntrySet this$2;
                    {
                        void var1_1;
                        this.this$2 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Map<R, V> apply(C columnKey) {
                        void var1_1;
                        return this.this$2.StandardTable.this.column(var1_1);
                    }
                });
            }

            @Override
            public int size() {
                return StandardTable.this.columnKeySet().size();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                Map.Entry entry;
                if (obj instanceof Map.Entry && StandardTable.this.containsColumn((entry = (Map.Entry)obj).getKey())) {
                    void var1_1;
                    return ((Map)Objects.requireNonNull(ColumnMap.this.get(entry.getKey()))).equals(var1_1.getValue());
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object obj) {
                if (this.contains(obj) && obj instanceof Map.Entry) {
                    void var1_1;
                    Map.Entry entry = (Map.Entry)obj;
                    StandardTable.access$900(StandardTable.this, var1_1.getKey());
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean removeAll(Collection<?> c) {
                void var1_1;
                Preconditions.checkNotNull(c);
                return Sets.removeAllImpl(this, var1_1.iterator());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean retainAll(Collection<?> c) {
                void var2_2;
                Preconditions.checkNotNull(c);
                boolean changed = false;
                for (Object columnKey : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (c.contains(Maps.immutableEntry(columnKey, StandardTable.this.column(columnKey)))) continue;
                    StandardTable.access$900(StandardTable.this, columnKey);
                    changed = true;
                }
                return (boolean)var2_2;
            }
        }
    }

    class RowMap
    extends Maps.ViewCachingAbstractMap<R, Map<C, V>> {
        final /* synthetic */ StandardTable this$0;

        /*
         * WARNING - void declaration
         */
        RowMap(StandardTable this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.this$0.containsRow(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<C, V> get(Object key) {
            if (this.this$0.containsRow(key)) {
                void var1_1;
                return this.this$0.row(Objects.requireNonNull(var1_1));
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<C, V> remove(Object key) {
            void var1_1;
            if (key == null) {
                return null;
            }
            return this.this$0.backingMap.remove(var1_1);
        }

        @Override
        protected Set<Map.Entry<R, Map<C, V>>> createEntrySet() {
            return new EntrySet();
        }

        class EntrySet
        extends TableSet<Map.Entry<R, Map<C, V>>> {
            /*
             * WARNING - void declaration
             */
            EntrySet() {
                void var1_1;
            }

            @Override
            public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
                return Maps.asMapEntryIterator(RowMap.this.this$0.backingMap.keySet(), new Function<R, Map<C, V>>(this){
                    final /* synthetic */ EntrySet this$2;
                    {
                        void var1_1;
                        this.this$2 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Map<C, V> apply(R rowKey) {
                        void var1_1;
                        return this.this$2.RowMap.this.this$0.row(var1_1);
                    }
                });
            }

            @Override
            public int size() {
                return RowMap.this.this$0.backingMap.size();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                if (obj instanceof Map.Entry) {
                    void var1_1;
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && Collections2.safeContains(RowMap.this.this$0.backingMap.entrySet(), var1_1);
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object obj) {
                if (obj instanceof Map.Entry) {
                    void var1_1;
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && RowMap.this.this$0.backingMap.entrySet().remove(var1_1);
                }
                return false;
            }
        }
    }

    private class ColumnKeyIterator
    extends AbstractIterator<C> {
        final Map<C, V> seen;
        final Iterator<Map<C, V>> mapIterator;
        Iterator<Map.Entry<C, V>> entryIterator;

        private ColumnKeyIterator() {
            this.seen = StandardTable.this.factory.get();
            this.mapIterator = StandardTable.this.backingMap.values().iterator();
            this.entryIterator = Iterators.emptyIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    void var1_1;
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return var1_1.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return this.endOfData();
        }
    }

    private class ColumnKeySet
    extends TableSet<C> {
        private ColumnKeySet() {
        }

        @Override
        public Iterator<C> iterator() {
            return StandardTable.this.createColumnKeyIterator();
        }

        @Override
        public int size() {
            return Iterators.size(this.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object obj) {
            void var2_2;
            if (obj == null) {
                return false;
            }
            boolean changed = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!map.keySet().remove(obj)) continue;
                changed = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var2_2;
            Preconditions.checkNotNull(c);
            boolean changed = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!Iterators.removeAll(map.keySet().iterator(), c)) continue;
                changed = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var2_2;
            Preconditions.checkNotNull(c);
            boolean changed = false;
            Iterator iterator = StandardTable.this.backingMap.values().iterator();
            while (iterator.hasNext()) {
                Map map = iterator.next();
                if (!map.keySet().retainAll(c)) continue;
                changed = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object obj) {
            void var1_1;
            return StandardTable.this.containsColumn(var1_1);
        }
    }

    private class Column
    extends Maps.ViewCachingAbstractMap<R, V> {
        final C columnKey;

        /*
         * WARNING - void declaration
         */
        Column(C columnKey) {
            void var2_2;
            this.columnKey = Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(R key, V value) {
            void var2_2;
            void var1_1;
            return StandardTable.this.put(var1_1, this.columnKey, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            return StandardTable.this.get(var1_1, this.columnKey);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return StandardTable.this.contains(var1_1, this.columnKey);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object key) {
            void var1_1;
            return StandardTable.this.remove(var1_1, this.columnKey);
        }

        /*
         * WARNING - void declaration
         */
        boolean removeFromColumnIf(Predicate<? super Map.Entry<R, V>> predicate) {
            void var2_2;
            boolean changed = false;
            Iterator iterator = StandardTable.this.backingMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map map = entry.getValue();
                Object value = map.get(this.columnKey);
                if (value == null || !predicate.apply(Maps.immutableEntry(entry.getKey(), value))) continue;
                map.remove(this.columnKey);
                changed = true;
                if (!map.isEmpty()) continue;
                iterator.remove();
            }
            return (boolean)var2_2;
        }

        @Override
        Set<Map.Entry<R, V>> createEntrySet() {
            return new EntrySet();
        }

        @Override
        Set<R> createKeySet() {
            return new KeySet();
        }

        @Override
        Collection<V> createValues() {
            return new Values();
        }

        private class Values
        extends Maps.Values<R, V> {
            Values() {
                super(Column.this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object obj) {
                void var1_1;
                return obj != null && Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.equalTo(var1_1)));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean removeAll(Collection<?> c) {
                void var1_1;
                return Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.in(var1_1)));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean retainAll(Collection<?> c) {
                void var1_1;
                return Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.not(Predicates.in(var1_1))));
            }
        }

        private class KeySet
        extends Maps.KeySet<R, V> {
            KeySet() {
                super(Column.this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object obj) {
                void var1_1;
                return StandardTable.this.contains(var1_1, Column.this.columnKey);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object obj) {
                void var1_1;
                return StandardTable.this.remove(var1_1, Column.this.columnKey) != null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean retainAll(Collection<?> c) {
                void var1_1;
                return Column.this.removeFromColumnIf(Maps.keyPredicateOnEntries(Predicates.not(Predicates.in(var1_1))));
            }
        }

        private class EntrySetIterator
        extends AbstractIterator<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            private EntrySetIterator() {
                this.iterator = StandardTable.this.backingMap.entrySet().iterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    void var1_1;
                    Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    class EntryImpl
                    extends AbstractMapEntry<R, V> {
                        final /* synthetic */ Map.Entry val$entry;
                        final /* synthetic */ EntrySetIterator this$2;

                        /*
                         * WARNING - void declaration
                         */
                        EntryImpl() {
                            void var1_1;
                            this.this$2 = var1_1;
                            this.val$entry = entry;
                        }

                        @Override
                        public R getKey() {
                            return this.val$entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((Map)this.val$entry.getValue()).get(this.this$2.Column.this.columnKey);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public V setValue(V value) {
                            void var1_1;
                            return NullnessCasts.uncheckedCastNullableTToT(((Map)this.val$entry.getValue()).put(this.this$2.Column.this.columnKey, Preconditions.checkNotNull(var1_1)));
                        }
                    }
                    return new EntryImpl();
                }
                return (Map.Entry)this.endOfData();
            }
        }

        private class EntrySet
        extends Sets.ImprovedAbstractSet<Map.Entry<R, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                int size = 0;
                for (Map map : StandardTable.this.backingMap.values()) {
                    if (!map.containsKey(Column.this.columnKey)) continue;
                    ++size;
                }
                return (int)var1_1;
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public void clear() {
                Column.this.removeFromColumnIf(Predicates.alwaysTrue());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    void var1_1;
                    Map.Entry entry = (Map.Entry)o;
                    return StandardTable.access$300(StandardTable.this, entry.getKey(), Column.this.columnKey, var1_1.getValue());
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object obj) {
                if (obj instanceof Map.Entry) {
                    void var1_1;
                    Map.Entry entry = (Map.Entry)obj;
                    return StandardTable.access$400(StandardTable.this, entry.getKey(), Column.this.columnKey, var1_1.getValue());
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean retainAll(Collection<?> c) {
                void var1_1;
                return Column.this.removeFromColumnIf(Predicates.not(Predicates.in(var1_1)));
            }
        }
    }

    class Row
    extends Maps.IteratorBasedAbstractMap<C, V> {
        final R rowKey;
        Map<C, V> backingRowMap;
        final /* synthetic */ StandardTable this$0;

        /*
         * WARNING - void declaration
         */
        Row(StandardTable this$0, R rowKey) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.rowKey = Preconditions.checkNotNull(var2_2);
        }

        final void updateBackingRowMapField() {
            if (this.backingRowMap == null || this.backingRowMap.isEmpty() && this.this$0.backingMap.containsKey(this.rowKey)) {
                this.backingRowMap = this.computeBackingRowMap();
            }
        }

        Map<C, V> computeBackingRowMap() {
            return this.this$0.backingMap.get(this.rowKey);
        }

        void maintainEmptyInvariant() {
            this.updateBackingRowMapField();
            if (this.backingRowMap != null && this.backingRowMap.isEmpty()) {
                this.this$0.backingMap.remove(this.rowKey);
                this.backingRowMap = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            this.updateBackingRowMapField();
            return key != null && this.backingRowMap != null && Maps.safeContainsKey(this.backingRowMap, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            this.updateBackingRowMapField();
            if (key != null && this.backingRowMap != null) {
                void var1_1;
                return Maps.safeGet(this.backingRowMap, var1_1);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(C key, V value) {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            if (this.backingRowMap != null && !this.backingRowMap.isEmpty()) {
                return this.backingRowMap.put(key, value);
            }
            return this.this$0.put(this.rowKey, var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object key) {
            void var1_1;
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                return null;
            }
            Object result = Maps.safeRemove(this.backingRowMap, key);
            this.maintainEmptyInvariant();
            return var1_1;
        }

        @Override
        public void clear() {
            this.updateBackingRowMapField();
            if (this.backingRowMap != null) {
                this.backingRowMap.clear();
            }
            this.maintainEmptyInvariant();
        }

        @Override
        public int size() {
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                return 0;
            }
            return this.backingRowMap.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Iterator<Map.Entry<C, V>> entryIterator() {
            void var1_1;
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                return Iterators.emptyModifiableIterator();
            }
            Iterator iterator = this.backingRowMap.entrySet().iterator();
            return new Iterator<Map.Entry<C, V>>(this, (Iterator)var1_1){
                final /* synthetic */ Iterator val$iterator;
                final /* synthetic */ Row this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$iterator = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                @Override
                public Map.Entry<C, V> next() {
                    return this.this$1.wrapEntry((Map.Entry)this.val$iterator.next());
                }

                @Override
                public void remove() {
                    this.val$iterator.remove();
                    this.this$1.maintainEmptyInvariant();
                }
            };
        }

        @Override
        Spliterator<Map.Entry<C, V>> entrySpliterator() {
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                return Spliterators.emptySpliterator();
            }
            return CollectSpliterators.map(this.backingRowMap.entrySet().spliterator(), this::wrapEntry);
        }

        /*
         * WARNING - void declaration
         */
        Map.Entry<C, V> wrapEntry(Map.Entry<C, V> entry) {
            void var1_1;
            return new ForwardingMapEntry<C, V>(this, (Map.Entry)var1_1){
                final /* synthetic */ Map.Entry val$entry;
                {
                    this.val$entry = entry;
                }

                @Override
                protected Map.Entry<C, V> delegate() {
                    return this.val$entry;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public V setValue(V value) {
                    void var1_1;
                    return super.setValue(Preconditions.checkNotNull(var1_1));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean equals(Object object) {
                    void var1_1;
                    return this.standardEquals(var1_1);
                }
            };
        }
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        Map.Entry<R, Map<C, V>> rowEntry;
        Iterator<Map.Entry<C, V>> columnIterator;

        private CellIterator() {
            this.rowIterator = StandardTable.this.backingMap.entrySet().iterator();
            this.columnIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Table.Cell<R, C, V> next() {
            void var1_1;
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Objects.requireNonNull(this.rowEntry);
            Map.Entry columnEntry = this.columnIterator.next();
            return Tables.immutableCell(this.rowEntry.getKey(), columnEntry.getKey(), var1_1.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (Objects.requireNonNull(this.rowEntry).getValue().isEmpty()) {
                this.rowIterator.remove();
                this.rowEntry = null;
            }
        }
    }

    private abstract class TableSet<T>
    extends Sets.ImprovedAbstractSet<T> {
        private TableSet() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }
}

