/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.Table;
import java.util.AbstractCollection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class SparseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    static final ImmutableTable<Object, Object, Object> EMPTY = new SparseImmutableTable<Object, Object, Object>(ImmutableList.of(), ImmutableSet.of(), ImmutableSet.of());
    private final ImmutableMap<R, ImmutableMap<C, V>> rowMap;
    private final ImmutableMap<C, ImmutableMap<R, V>> columnMap;
    private final int[] cellRowIndices;
    private final int[] cellColumnInRowIndices;

    /*
     * WARNING - void declaration
     */
    SparseImmutableTable(ImmutableList<Table.Cell<R, C, V>> cellList, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
        void var2_2;
        void var3_3;
        ImmutableMap rowIndex = Maps.indexMap(rowSpace);
        LinkedHashMap rows = Maps.newLinkedHashMap();
        rowSpace = ((ImmutableCollection)rowSpace).iterator();
        while (rowSpace.hasNext()) {
            Object row = rowSpace.next();
            rows.put(row, new LinkedHashMap());
        }
        LinkedHashMap columns = Maps.newLinkedHashMap();
        for (Object col : columnSpace) {
            columns.put(col, new LinkedHashMap());
        }
        int[] cellRowIndices = new int[cellList.size()];
        int[] cellColumnInRowIndices = new int[cellList.size()];
        for (int i = 0; i < cellList.size(); ++i) {
            Table.Cell cell = (Table.Cell)cellList.get(i);
            Object r = cell.getRowKey();
            Object columnKey = cell.getColumnKey();
            Object value = cell.getValue();
            cellRowIndices[i] = Objects.requireNonNull((Integer)rowIndex.get(r));
            Map thisRow = Objects.requireNonNull((Map)rows.get(r));
            cellColumnInRowIndices[i] = thisRow.size();
            Object oldValue = thisRow.put(columnKey, value);
            this.checkNoDuplicate(r, columnKey, oldValue, value);
            Objects.requireNonNull((Map)columns.get(columnKey)).put(r, value);
        }
        this.cellRowIndices = cellRowIndices;
        this.cellColumnInRowIndices = var3_3;
        ImmutableMap.Builder rowBuilder = new ImmutableMap.Builder(rows.size());
        for (Map.Entry entry : rows.entrySet()) {
            rowBuilder.put(entry.getKey(), ImmutableMap.copyOf((Map)entry.getValue()));
        }
        this.rowMap = rowBuilder.buildOrThrow();
        ImmutableMap.Builder columnBuilder = new ImmutableMap.Builder(columns.size());
        for (Map.Entry col : var2_2.entrySet()) {
            columnBuilder.put(col.getKey(), ImmutableMap.copyOf((Map)col.getValue()));
        }
        this.columnMap = columnBuilder.buildOrThrow();
    }

    @Override
    public final ImmutableMap<C, Map<R, V>> columnMap() {
        ImmutableMap<C, ImmutableMap<R, V>> immutableMap = this.columnMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    @Override
    public final ImmutableMap<R, Map<C, V>> rowMap() {
        ImmutableMap<R, ImmutableMap<C, V>> immutableMap = this.rowMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    @Override
    public final int size() {
        return this.cellRowIndices.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Table.Cell<R, C, V> getCell(int index) {
        void var1_2;
        void var2_4;
        void var3_5;
        int rowIndex = this.cellRowIndices[index];
        Map.Entry rowEntry = (Map.Entry)((ImmutableCollection)((Object)this.rowMap.entrySet())).asList().get(rowIndex);
        ImmutableMap row = (ImmutableMap)rowEntry.getValue();
        int columnIndex = this.cellColumnInRowIndices[index];
        Map.Entry colEntry = (Map.Entry)((ImmutableCollection)((Object)var3_5.entrySet())).asList().get(columnIndex);
        return SparseImmutableTable.cellOf(var2_4.getKey(), colEntry.getKey(), var1_2.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final V getValue(int index) {
        void var1_1;
        void var2_3;
        int rowIndex = this.cellRowIndices[index];
        ImmutableMap row = (ImmutableMap)((ImmutableCollection)this.rowMap.values()).asList().get(rowIndex);
        int columnIndex = this.cellColumnInRowIndices[index];
        return (V)((ImmutableCollection)var2_3.values()).asList().get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableTable.SerializedForm createSerializedForm() {
        void var2_2;
        ImmutableMap columnKeyToIndex = Maps.indexMap(this.columnKeySet());
        int[] cellColumnIndices = new int[((AbstractCollection)((Object)this.cellSet())).size()];
        int i = 0;
        for (Table.Cell cell : this.cellSet()) {
            cellColumnIndices[i++] = Objects.requireNonNull((Integer)columnKeyToIndex.get(cell.getColumnKey()));
        }
        SparseImmutableTable sparseImmutableTable = this;
        return ImmutableTable.SerializedForm.create(sparseImmutableTable, sparseImmutableTable.cellRowIndices, (int[])var2_2);
    }
}

