/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SortedMultiset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class SortedMultisets {
    private SortedMultisets() {
    }

    private static <E> E getElementOrThrow(Multiset.Entry<E> entry) {
        Multiset.Entry<E> entry2;
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry2.getElement();
    }

    private static <E> E getElementOrNull(Multiset.Entry<E> entry) {
        Multiset.Entry<E> entry2;
        if (entry == null) {
            return null;
        }
        return entry2.getElement();
    }

    @GwtIncompatible
    static class NavigableElementSet<E>
    extends ElementSet<E>
    implements NavigableSet<E> {
        /*
         * WARNING - void declaration
         */
        NavigableElementSet(SortedMultiset<E> multiset) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E lower(@ParametricNullness E e) {
            void var1_1;
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(var1_1, BoundType.OPEN).lastEntry());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E floor(@ParametricNullness E e) {
            void var1_1;
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(var1_1, BoundType.CLOSED).lastEntry());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E ceiling(@ParametricNullness E e) {
            void var1_1;
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(var1_1, BoundType.CLOSED).firstEntry());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E higher(@ParametricNullness E e) {
            void var1_1;
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(var1_1, BoundType.OPEN).firstEntry());
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new NavigableElementSet(this.multiset().descendingMultiset());
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public E pollFirst() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollFirstEntry());
        }

        @Override
        public E pollLast() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollLastEntry());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new NavigableElementSet<void>(this.multiset().subMultiset(var1_1, BoundType.forBoolean((boolean)var2_2), var3_3, BoundType.forBoolean(toInclusive)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return new NavigableElementSet<void>(this.multiset().headMultiset(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return new NavigableElementSet<void>(this.multiset().tailMultiset(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }
    }

    static class ElementSet<E>
    extends Multisets.ElementSet<E>
    implements SortedSet<E> {
        private final SortedMultiset<E> multiset;

        /*
         * WARNING - void declaration
         */
        ElementSet(SortedMultiset<E> multiset) {
            void var1_1;
            this.multiset = var1_1;
        }

        @Override
        final SortedMultiset<E> multiset() {
            return this.multiset;
        }

        @Override
        public Iterator<E> iterator() {
            return Multisets.elementIterator(this.multiset().entrySet().iterator());
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.multiset().comparator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
            void var2_2;
            void var1_1;
            return this.multiset().subMultiset(var1_1, BoundType.CLOSED, var2_2, BoundType.OPEN).elementSet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> headSet(@ParametricNullness E toElement) {
            void var1_1;
            return this.multiset().headMultiset(var1_1, BoundType.OPEN).elementSet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
            void var1_1;
            return this.multiset().tailMultiset(var1_1, BoundType.CLOSED).elementSet();
        }

        @Override
        @ParametricNullness
        public E first() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().firstEntry());
        }

        @Override
        @ParametricNullness
        public E last() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().lastEntry());
        }
    }
}

