/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible
@Beta
final class SortedLists {
    private SortedLists() {
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable> int binarySearch(List<? extends E> list, E e, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        void var3_3;
        void var2_2;
        void var1_1;
        List<? extends E> list2;
        Preconditions.checkNotNull(e);
        return SortedLists.binarySearch(list2, var1_1, Ordering.natural(), (KeyPresentBehavior)var2_2, (KeyAbsentBehavior)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <E, K extends Comparable> int binarySearch(List<E> list, Function<? super E, K> keyFunction, K key, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        void var3_3;
        void var2_2;
        void var1_1;
        List<E> list2;
        Preconditions.checkNotNull(key);
        return SortedLists.binarySearch(list2, var1_1, var2_2, Ordering.natural(), (KeyPresentBehavior)var3_3, absentBehavior);
    }

    /*
     * WARNING - void declaration
     */
    public static <E, K> int binarySearch(List<E> list, Function<? super E, K> keyFunction, @ParametricNullness K key, Comparator<? super K> keyComparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SortedLists.binarySearch(Lists.transform(list, var1_1), var2_2, var3_3, presentBehavior, absentBehavior);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> int binarySearch(List<? extends E> list, @ParametricNullness E key, Comparator<? super E> comparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(presentBehavior);
        Preconditions.checkNotNull(absentBehavior);
        if (!(list instanceof RandomAccess)) {
            list = Lists.newArrayList(list);
        }
        int lower = 0;
        int upper = list.size() - 1;
        while (lower <= upper) {
            List<E> list2;
            void var1_1;
            void var2_2;
            void var3_3;
            int middle = lower + upper >>> 1;
            int c = comparator.compare(key, list.get(middle));
            if (c < 0) {
                upper = middle - 1;
                continue;
            }
            if (c > 0) {
                lower = middle + 1;
                continue;
            }
            return lower + var3_3.resultIndex(var2_2, var1_1, list2.subList(lower, upper + 1), middle - lower);
        }
        return absentBehavior.resultIndex(lower);
    }

    static enum KeyAbsentBehavior {
        NEXT_LOWER{

            @Override
            final int resultIndex(int higherIndex) {
                return higherIndex - 1;
            }
        }
        ,
        NEXT_HIGHER{

            @Override
            public final int resultIndex(int higherIndex) {
                return higherIndex;
            }
        }
        ,
        INVERTED_INSERTION_INDEX{

            @Override
            public final int resultIndex(int higherIndex) {
                return ~higherIndex;
            }
        };


        abstract int resultIndex(int var1);
    }

    static enum KeyPresentBehavior {
        ANY_PRESENT{

            @Override
            final <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                return foundIndex;
            }
        }
        ,
        LAST_PRESENT{

            @Override
            final <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                int lower = foundIndex;
                int upper = list.size() - 1;
                while (lower < upper) {
                    int middle = lower + upper + 1 >>> 1;
                    int n = comparator.compare(list.get(middle), key);
                    if (n > 0) {
                        upper = middle - 1;
                        continue;
                    }
                    lower = middle;
                }
                return lower;
            }
        }
        ,
        FIRST_PRESENT{

            @Override
            final <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                int lower = 0;
                int upper = foundIndex;
                while (lower < upper) {
                    int middle = lower + upper >>> 1;
                    int n = comparator.compare(list.get(middle), key);
                    if (n < 0) {
                        lower = middle + 1;
                        continue;
                    }
                    upper = middle;
                }
                return lower;
            }
        }
        ,
        FIRST_AFTER{

            /*
             * WARNING - void declaration
             */
            @Override
            public final <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                return LAST_PRESENT.resultIndex(var1_1, var2_2, var3_3, foundIndex) + 1;
            }
        }
        ,
        LAST_BEFORE{

            /*
             * WARNING - void declaration
             */
            @Override
            public final <E> int resultIndex(Comparator<? super E> comparator, @ParametricNullness E key, List<? extends E> list, int foundIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                return FIRST_PRESENT.resultIndex(var1_1, var2_2, var3_3, foundIndex) - 1;
            }
        };


        abstract <E> int resultIndex(Comparator<? super E> var1, @ParametricNullness E var2, List<? extends E> var3, int var4);
    }
}

