/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedIterable;
import java.util.Comparator;
import java.util.SortedSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements) {
        void var1_1;
        Comparator<?> comparator2;
        Comparator<Object> comparator22;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            comparator22 = SortedIterables.comparator((SortedSet)elements);
        } else if (comparator22 instanceof SortedIterable) {
            comparator22 = ((SortedIterable)((Object)comparator22)).comparator();
        } else {
            return false;
        }
        return comparator2.equals(var1_1);
    }

    public static <E> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Comparator<Object> comparator;
        Comparator<Object> result = sortedSet.comparator();
        if (result == null) {
            result = Ordering.natural();
        }
        return comparator;
    }
}

