/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class SingletonImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    final R singleRowKey;
    final C singleColumnKey;
    final V singleValue;

    /*
     * WARNING - void declaration
     */
    SingletonImmutableTable(R rowKey, C columnKey, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.singleRowKey = Preconditions.checkNotNull(var1_1);
        this.singleColumnKey = Preconditions.checkNotNull(var2_2);
        this.singleValue = Preconditions.checkNotNull(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    SingletonImmutableTable(Table.Cell<R, C, V> cell) {
        this(cell.getRowKey(), cell.getColumnKey(), var1_1.getValue());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<R, V> column(C columnKey) {
        void var1_1;
        Preconditions.checkNotNull(columnKey);
        if (this.containsColumn(var1_1)) {
            return ImmutableMap.of(this.singleRowKey, this.singleValue);
        }
        return ImmutableMap.of();
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        return ImmutableMap.of(this.singleColumnKey, ImmutableMap.of(this.singleRowKey, this.singleValue));
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        return ImmutableMap.of(this.singleRowKey, ImmutableMap.of(this.singleColumnKey, this.singleValue));
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    ImmutableSet<Table.Cell<R, C, V>> createCellSet() {
        return ImmutableSet.of(SingletonImmutableTable.cellOf(this.singleRowKey, this.singleColumnKey, this.singleValue));
    }

    @Override
    ImmutableCollection<V> createValues() {
        return ImmutableSet.of(this.singleValue);
    }

    @Override
    ImmutableTable.SerializedForm createSerializedForm() {
        return ImmutableTable.SerializedForm.create(this, new int[]{0}, new int[]{0});
    }
}

