/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    /*
     * WARNING - void declaration
     */
    SingletonImmutableSet(E element) {
        void var1_1;
        this.element = Preconditions.checkNotNull(var1_1);
    }

    @Override
    public final int size() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object target) {
        void var1_1;
        return this.element.equals(var1_1);
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public final ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        dst[offset] = this.element;
        return (int)(var2_2 + true);
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public final String toString() {
        String string = this.element.toString();
        return new StringBuilder(2 + String.valueOf(string).length()).append('[').append(string).append(']').toString();
    }
}

