/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Spliterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    /*
     * WARNING - void declaration
     */
    SingletonImmutableList(E element) {
        void var1_1;
        this.element = Preconditions.checkNotNull(var1_1);
    }

    @Override
    public final E get(int index) {
        Preconditions.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public final Spliterator<E> spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    @Override
    public final int size() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableList<E> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        Preconditions.checkPositionIndexes(fromIndex, toIndex, 1);
        if (var1_1 == var2_2) {
            return ImmutableList.of();
        }
        return this;
    }

    @Override
    public final String toString() {
        String string = this.element.toString();
        return new StringBuilder(2 + String.valueOf(string).length()).append('[').append(string).append(']').toString();
    }

    @Override
    final boolean isPartialView() {
        return false;
    }
}

