/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    private final transient ImmutableBiMap<V, K> inverse;
    private transient ImmutableBiMap<V, K> lazyInverse;

    /*
     * WARNING - void declaration
     */
    SingletonImmutableBiMap(K singleKey, V singleValue) {
        void var2_2;
        void var1_1;
        CollectPreconditions.checkEntryNotNull(singleKey, singleValue);
        this.singleKey = var1_1;
        this.singleValue = var2_2;
        this.inverse = null;
    }

    /*
     * WARNING - void declaration
     */
    private SingletonImmutableBiMap(K singleKey, V singleValue, ImmutableBiMap<V, K> inverse) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.singleKey = var1_1;
        this.singleValue = var2_2;
        this.inverse = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_1;
        if (this.singleKey.equals(var1_1)) {
            return this.singleValue;
        }
        return null;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action).accept(this.singleKey, this.singleValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(Object key) {
        void var1_1;
        return this.singleKey.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsValue(Object value) {
        void var1_1;
        return this.singleValue.equals(var1_1);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableBiMap<V, K> inverse() {
        void var1_1;
        if (this.inverse != null) {
            return this.inverse;
        }
        ImmutableBiMap<V, K> result = this.lazyInverse;
        if (result == null) {
            this.lazyInverse = new SingletonImmutableBiMap<K, V>(this.singleValue, this.singleKey, this);
            return this.lazyInverse;
        }
        return var1_1;
    }
}

