/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.CartesianList;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.common.collect.Range;
import com.google.common.collect.Synchronized;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.IntMath;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Sets {
    private Sets() {
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(E anElement, E ... otherElements) {
        void var1_1;
        return ImmutableEnumSet.asImmutable(EnumSet.of(anElement, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(Iterable<E> elements) {
        Iterator<E> collection;
        if (elements instanceof ImmutableEnumSet) {
            return (ImmutableEnumSet)elements;
        }
        if (elements instanceof Collection) {
            collection = (Collection)elements;
            if (collection.isEmpty()) {
                return ImmutableSet.of();
            }
            return ImmutableEnumSet.asImmutable(EnumSet.copyOf(collection));
        }
        Iterator<E> itr = collection.iterator();
        if (itr.hasNext()) {
            void var1_1;
            Iterator<E> iterator;
            EnumSet<Enum> enumSet = EnumSet.of((Enum)itr.next());
            Iterators.addAll(enumSet, iterator);
            return ImmutableEnumSet.asImmutable((EnumSet)var1_1);
        }
        return ImmutableSet.of();
    }

    public static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
        return CollectCollectors.toImmutableEnumSet();
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> elementType) {
        void var1_1;
        Iterable<E> iterable2;
        EnumSet<E> set = EnumSet.noneOf(elementType);
        Iterables.addAll(set, iterable2);
        return var1_1;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> HashSet<E> newHashSet(E ... elements) {
        void var1_1;
        E[] EArray;
        HashSet<E> set = Sets.newHashSetWithExpectedSize(elements.length);
        Collections.addAll(set, EArray);
        return var1_1;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        Iterable<E> iterable;
        if (elements instanceof Collection) {
            return new HashSet((Collection)elements);
        }
        return Sets.newHashSet(iterable.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        void var1_1;
        Iterator<? extends E> iterator;
        HashSet<E> set = Sets.newHashSet();
        Iterators.addAll(set, iterator);
        return var1_1;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        int n;
        return new HashSet(Maps.capacity(n));
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return Platform.newConcurrentHashSet();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Set<E> newConcurrentHashSet(Iterable<? extends E> elements) {
        void var1_1;
        Iterable<? extends E> iterable;
        Set<E> set = Sets.newConcurrentHashSet();
        Iterables.addAll(set, iterable);
        return var1_1;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> elements) {
        void var1_1;
        Iterable<? extends E> iterable;
        if (elements instanceof Collection) {
            return new LinkedHashSet((Collection)elements);
        }
        LinkedHashSet<E> set = Sets.newLinkedHashSet();
        Iterables.addAll(set, iterable);
        return var1_1;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        int n;
        return new LinkedHashSet(Maps.capacity(n));
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        void var1_1;
        Iterable<? extends E> iterable;
        TreeSet<E> set = Sets.newTreeSet();
        Iterables.addAll(set, iterable);
        return var1_1;
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        Comparator<? super E> comparator2;
        return new TreeSet<E>(Preconditions.checkNotNull(comparator2));
    }

    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(Maps.newIdentityHashMap());
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet(Iterable<? extends E> elements) {
        Iterable<? extends E> iterable;
        Iterable<? extends E> elementsCollection = elements instanceof Collection ? (ArrayList<? extends E>)elements : Lists.newArrayList(elements);
        return new CopyOnWriteArraySet<E>(iterable);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection) {
        void var1_1;
        Collection<E> collection2;
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection);
        }
        Preconditions.checkArgument(!collection.isEmpty(), "collection is empty; use the other version of this method");
        Class type = ((Enum)collection.iterator().next()).getDeclaringClass();
        return Sets.makeComplementByHand(collection2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection, Class<E> type) {
        void var1_1;
        Collection<E> collection2;
        Preconditions.checkNotNull(collection);
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection);
        }
        return Sets.makeComplementByHand(collection2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection, Class<E> type) {
        void var1_1;
        Collection<E> collection2;
        EnumSet<E> result = EnumSet.allOf(type);
        result.removeAll(collection2);
        return var1_1;
    }

    @Deprecated
    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> SetView<E> union(Set<? extends E> set1, Set<? extends E> set2) {
        void var1_1;
        Set<? extends E> set;
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>((Set)var1_1){
            final /* synthetic */ Set val$set2;
            {
                this.val$set2 = set2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                int size = set.size();
                for (Object e : this.val$set2) {
                    void var3_3;
                    if (set.contains(var3_3)) continue;
                    ++size;
                }
                return (int)var1_1;
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty() && this.val$set2.isEmpty();
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(this){
                    final Iterator<? extends E> itr1;
                    final Iterator<? extends E> itr2;
                    final /* synthetic */ 1 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.itr1 = this.this$0.set.iterator();
                        this.itr2 = this.this$0.val$set2.iterator();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected E computeNext() {
                        if (this.itr1.hasNext()) {
                            return this.itr1.next();
                        }
                        while (this.itr2.hasNext()) {
                            void var1_1;
                            Object e = this.itr2.next();
                            if (this.this$0.set.contains(e)) continue;
                            return var1_1;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return Stream.concat(set.stream(), this.val$set2.stream().filter(e -> {
                    void var1_1;
                    return !set.contains(var1_1);
                }));
            }

            @Override
            public Stream<E> parallelStream() {
                return (Stream)this.stream().parallel();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object object) {
                void var1_1;
                return set.contains(object) || this.val$set2.contains(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <S extends Set<E>> S copyInto(S set2) {
                void var1_1;
                set2.addAll(set);
                set2.addAll(this.val$set2);
                return var1_1;
            }

            @Override
            public ImmutableSet<E> immutableCopy() {
                return ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)set)).addAll((Iterable)this.val$set2)).build();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <E> SetView<E> intersection(Set<E> set1, Set<?> set2) {
        void var1_1;
        Set<E> set;
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>((Set)var1_1){
            final /* synthetic */ Set val$set2;
            {
                this.val$set2 = set2;
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(this){
                    final Iterator<E> itr;
                    final /* synthetic */ 2 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.itr = this.this$0.set.iterator();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            void var1_1;
                            Object e = this.itr.next();
                            if (!this.this$0.val$set2.contains(e)) continue;
                            return var1_1;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set.stream().filter(this.val$set2::contains);
            }

            @Override
            public Stream<E> parallelStream() {
                return set.parallelStream().filter(this.val$set2::contains);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                int size = 0;
                for (Object e : set) {
                    void var3_3;
                    if (!this.val$set2.contains(var3_3)) continue;
                    ++size;
                }
                return (int)var1_1;
            }

            @Override
            public boolean isEmpty() {
                return Collections.disjoint(this.val$set2, set);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object object) {
                void var1_1;
                return set.contains(object) && this.val$set2.contains(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean containsAll(Collection<?> collection) {
                void var1_1;
                return set.containsAll(collection) && this.val$set2.containsAll((Collection<?>)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <E> SetView<E> difference(Set<E> set1, Set<?> set2) {
        void var1_1;
        Set<E> set;
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>((Set)var1_1){
            final /* synthetic */ Set val$set2;
            {
                this.val$set2 = set2;
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(this){
                    final Iterator<E> itr;
                    final /* synthetic */ 3 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.itr = this.this$0.set.iterator();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            void var1_1;
                            Object e = this.itr.next();
                            if (this.this$0.val$set2.contains(e)) continue;
                            return var1_1;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set.stream().filter(e -> {
                    void var1_1;
                    return !this.val$set2.contains(var1_1);
                });
            }

            @Override
            public Stream<E> parallelStream() {
                return set.parallelStream().filter(e -> {
                    void var1_1;
                    return !this.val$set2.contains(var1_1);
                });
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                int size = 0;
                for (Object e : set) {
                    void var3_3;
                    if (this.val$set2.contains(var3_3)) continue;
                    ++size;
                }
                return (int)var1_1;
            }

            @Override
            public boolean isEmpty() {
                return this.val$set2.containsAll(set);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object element) {
                void var1_1;
                return set.contains(element) && !this.val$set2.contains(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <E> SetView<E> symmetricDifference(Set<? extends E> set1, Set<? extends E> set2) {
        void var1_1;
        Set<? extends E> set;
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>((Set)var1_1){
            final /* synthetic */ Set val$set2;
            {
                this.val$set2 = set2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public UnmodifiableIterator<E> iterator() {
                void var2_2;
                void var1_1;
                Iterator itr1 = set.iterator();
                Iterator itr2 = this.val$set2.iterator();
                return new AbstractIterator<E>(this, (Iterator)var1_1, (Iterator)var2_2){
                    final /* synthetic */ Iterator val$itr1;
                    final /* synthetic */ Iterator val$itr2;
                    final /* synthetic */ 4 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$itr1 = iterator;
                        this.val$itr2 = iterator2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public E computeNext() {
                        while (this.val$itr1.hasNext()) {
                            Object elem1 = this.val$itr1.next();
                            if (this.this$0.val$set2.contains(elem1)) continue;
                            return elem1;
                        }
                        while (this.val$itr2.hasNext()) {
                            void var1_1;
                            Object elem2 = this.val$itr2.next();
                            if (this.this$0.set.contains(elem2)) continue;
                            return var1_1;
                        }
                        return this.endOfData();
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                int size = 0;
                for (Object e : set) {
                    if (this.val$set2.contains(e)) continue;
                    ++size;
                }
                for (Object e : this.val$set2) {
                    void var3_3;
                    if (set.contains(var3_3)) continue;
                    ++size;
                }
                return (int)var1_1;
            }

            @Override
            public boolean isEmpty() {
                return set.equals(this.val$set2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object element) {
                void var1_1;
                return set.contains(element) ^ this.val$set2.contains(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Set<E> filter(Set<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
        void var1_1;
        FilteredSet filteredSet;
        if (unfiltered instanceof SortedSet) {
            return Sets.filter((SortedSet)unfiltered, predicate);
        }
        if (unfiltered instanceof FilteredSet) {
            FilteredSet filtered = (FilteredSet)unfiltered;
            com.google.common.base.Predicate<? super E> combinedPredicate = Predicates.and(filtered.predicate, predicate);
            return new FilteredSet((Set)filteredSet.unfiltered, var1_1);
        }
        return new FilteredSet(Preconditions.checkNotNull(filteredSet), (com.google.common.base.Predicate)Preconditions.checkNotNull(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <E> SortedSet<E> filter(SortedSet<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
        void var1_1;
        Set<E> set;
        if (unfiltered instanceof FilteredSet) {
            Set<E> filtered = (FilteredSet)((Object)unfiltered);
            com.google.common.base.Predicate<? super E> combinedPredicate = Predicates.and(((Collections2.FilteredCollection)((Object)filtered)).predicate, predicate);
            return new FilteredSortedSet((SortedSet)((Collections2.FilteredCollection)((Object)set)).unfiltered, var1_1);
        }
        return new FilteredSortedSet<E>(Preconditions.checkNotNull(set), (com.google.common.base.Predicate)Preconditions.checkNotNull(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <E> NavigableSet<E> filter(NavigableSet<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
        void var1_1;
        Set<E> set;
        if (unfiltered instanceof FilteredSet) {
            Set<E> filtered = (FilteredSet)((Object)unfiltered);
            com.google.common.base.Predicate<? super E> combinedPredicate = Predicates.and(((Collections2.FilteredCollection)((Object)filtered)).predicate, predicate);
            return new FilteredNavigableSet((NavigableSet)((Collections2.FilteredCollection)((Object)set)).unfiltered, var1_1);
        }
        return new FilteredNavigableSet<E>(Preconditions.checkNotNull(set), (com.google.common.base.Predicate)Preconditions.checkNotNull(var1_1));
    }

    public static <B> Set<List<B>> cartesianProduct(List<? extends Set<? extends B>> sets) {
        return CartesianSet.create(sets);
    }

    @SafeVarargs
    public static <B> Set<List<B>> cartesianProduct(Set<? extends B> ... sets) {
        return Sets.cartesianProduct(Arrays.asList(sets));
    }

    @GwtCompatible(serializable=false)
    public static <E> Set<Set<E>> powerSet(Set<E> set) {
        Set<E> set2;
        return new PowerSet<E>(set2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <E> Set<Set<E>> combinations(Set<E> set, int size) {
        ImmutableMap<E, Integer> immutableMap;
        void var1_1;
        ImmutableMap<E, Integer> index = Maps.indexMap(set);
        CollectPreconditions.checkNonnegative(size, "size");
        Preconditions.checkArgument(size <= index.size(), "size (%s) must be <= set.size() (%s)", size, index.size());
        if (size == 0) {
            return ImmutableSet.of(ImmutableSet.of());
        }
        if (size == index.size()) {
            return ImmutableSet.of(index.keySet());
        }
        return new AbstractSet<Set<E>>((int)var1_1, immutableMap){
            final /* synthetic */ int val$size;
            final /* synthetic */ ImmutableMap val$index;
            {
                this.val$size = n;
                this.val$index = immutableMap;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object o) {
                if (o instanceof Set) {
                    void var1_1;
                    Set s = (Set)o;
                    return s.size() == this.val$size && ((AbstractCollection)((Object)this.val$index.keySet())).containsAll((Collection<?>)var1_1);
                }
                return false;
            }

            @Override
            public Iterator<Set<E>> iterator() {
                return new AbstractIterator<Set<E>>(this){
                    final BitSet bits;
                    final /* synthetic */ 5 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.bits = new BitSet(this.this$0.val$index.size());
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Set<E> computeNext() {
                        void var1_2;
                        if (this.bits.isEmpty()) {
                            this.bits.set(0, this.this$0.val$size);
                        } else {
                            void var2_3;
                            int firstSetBit = this.bits.nextSetBit(0);
                            int bitToFlip = this.bits.nextClearBit(firstSetBit);
                            if (bitToFlip == this.this$0.val$index.size()) {
                                return (Set)this.endOfData();
                            }
                            this.bits.set(0, bitToFlip - firstSetBit - 1);
                            this.bits.clear(bitToFlip - firstSetBit - 1, bitToFlip);
                            this.bits.set((int)var2_3);
                        }
                        BitSet copy = (BitSet)this.bits.clone();
                        return new AbstractSet<E>(this, (BitSet)var1_2){
                            final /* synthetic */ BitSet val$copy;
                            final /* synthetic */ 1 this$1;
                            {
                                void var1_1;
                                this.this$1 = var1_1;
                                this.val$copy = bitSet;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public boolean contains(Object o) {
                                void var1_1;
                                Integer i = (Integer)this.this$1.this$0.val$index.get(o);
                                return i != null && this.val$copy.get(var1_1.intValue());
                            }

                            @Override
                            public Iterator<E> iterator() {
                                return new AbstractIterator<E>(this){
                                    int i = -1;
                                    final /* synthetic */ 1 this$2;
                                    {
                                        void var1_1;
                                        this.this$2 = var1_1;
                                    }

                                    @Override
                                    protected E computeNext() {
                                        this.i = this.this$2.val$copy.nextSetBit(this.i + 1);
                                        if (this.i == -1) {
                                            return this.endOfData();
                                        }
                                        return ((ImmutableCollection)((Object)this.this$2.this$1.this$0.val$index.keySet())).asList().get(this.i);
                                    }
                                };
                            }

                            @Override
                            public int size() {
                                return this.this$1.this$0.val$size;
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return IntMath.binomial(this.val$index.size(), this.val$size);
            }

            @Override
            public String toString() {
                String string = String.valueOf(this.val$index.keySet());
                int n = this.val$size;
                return new StringBuilder(32 + String.valueOf(string).length()).append("Sets.combinations(").append(string).append(", ").append(n).append(")").toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static int hashCodeImpl(Set<?> s) {
        void var1_1;
        Iterator<?> iterator;
        int hashCode = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object o = iterator.next();
            hashCode += o != null ? var2_2.hashCode() : 0;
            hashCode = ~(~hashCode);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Set<?> s, Object object) {
        if (s == object) {
            return true;
        }
        if (object instanceof Set) {
            Set o = (Set)object;
            try {
                void var1_1;
                Set<?> set;
                return s.size() == o.size() && set.containsAll((Collection<?>)var1_1);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }
        return false;
    }

    public static <E> NavigableSet<E> unmodifiableNavigableSet(NavigableSet<E> set) {
        NavigableSet<E> navigableSet;
        if (set instanceof ImmutableCollection || set instanceof UnmodifiableNavigableSet) {
            return set;
        }
        return new UnmodifiableNavigableSet<E>(navigableSet);
    }

    @GwtIncompatible
    public static <E> NavigableSet<E> synchronizedNavigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet);
    }

    /*
     * WARNING - void declaration
     */
    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        void var2_2;
        boolean changed = false;
        while (iterator.hasNext()) {
            changed |= set.remove(iterator.next());
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        void var1_1;
        Set<?> set2;
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection);
        }
        return Sets.removeAllImpl(set2, var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static <K extends Comparable<? super K>> NavigableSet<K> subSet(NavigableSet<K> set, Range<K> range) {
        NavigableSet<K> navigableSet;
        if (set.comparator() != null && set.comparator() != Ordering.natural() && range.hasLowerBound() && range.hasUpperBound()) {
            Preconditions.checkArgument(set.comparator().compare(range.lowerEndpoint(), range.upperEndpoint()) <= 0, "set is using a custom comparator which is inconsistent with the natural ordering.");
        }
        if (range.hasLowerBound() && range.hasUpperBound()) {
            return set.subSet(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED, range.upperEndpoint(), range.upperBoundType() == BoundType.CLOSED);
        }
        if (range.hasLowerBound()) {
            return set.tailSet(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED);
        }
        if (range.hasUpperBound()) {
            void var1_1;
            return set.headSet(range.upperEndpoint(), var1_1.upperBoundType() == BoundType.CLOSED);
        }
        return Preconditions.checkNotNull(navigableSet);
    }

    @GwtIncompatible
    static class DescendingSet<E>
    extends ForwardingNavigableSet<E> {
        private final NavigableSet<E> forward;

        /*
         * WARNING - void declaration
         */
        DescendingSet(NavigableSet<E> forward) {
            void var1_1;
            this.forward = var1_1;
        }

        @Override
        protected NavigableSet<E> delegate() {
            return this.forward;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E lower(@ParametricNullness E e) {
            void var1_1;
            return this.forward.higher(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E floor(@ParametricNullness E e) {
            void var1_1;
            return this.forward.ceiling(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E ceiling(@ParametricNullness E e) {
            void var1_1;
            return this.forward.floor(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E higher(@ParametricNullness E e) {
            void var1_1;
            return this.forward.lower(var1_1);
        }

        @Override
        public E pollFirst() {
            return this.forward.pollLast();
        }

        @Override
        public E pollLast() {
            return this.forward.pollFirst();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return this.forward;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.forward.iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            void var2_2;
            void var1_1;
            void var3_3;
            return this.forward.subSet(var3_3, toInclusive, var1_1, (boolean)var2_2).descendingSet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
            void var2_2;
            void var1_1;
            return this.standardSubSet(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward.tailSet(var1_1, (boolean)var2_2).descendingSet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> headSet(@ParametricNullness E toElement) {
            void var1_1;
            return this.standardHeadSet(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward.headSet(var1_1, (boolean)var2_2).descendingSet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
            void var1_1;
            return this.standardTailSet(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Comparator<? super E> comparator() {
            void var1_1;
            Comparator forwardComparator = this.forward.comparator();
            if (forwardComparator == null) {
                return Ordering.natural().reverse();
            }
            return DescendingSet.reverse(var1_1);
        }

        private static <T> Ordering<T> reverse(Comparator<T> forward) {
            return Ordering.from(forward).reverse();
        }

        @Override
        @ParametricNullness
        public E first() {
            return this.forward.last();
        }

        @Override
        @ParametricNullness
        public E last() {
            return this.forward.first();
        }

        @Override
        public Iterator<E> iterator() {
            return this.forward.descendingIterator();
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] array) {
            void var1_1;
            return this.standardToArray((T[])var1_1);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    static final class UnmodifiableNavigableSet<E>
    extends ForwardingSortedSet<E>
    implements Serializable,
    NavigableSet<E> {
        private final NavigableSet<E> delegate;
        private final SortedSet<E> unmodifiableDelegate;
        private transient UnmodifiableNavigableSet<E> descendingSet;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableNavigableSet(NavigableSet<E> delegate) {
            void var1_1;
            this.delegate = Preconditions.checkNotNull(delegate);
            this.unmodifiableDelegate = Collections.unmodifiableSortedSet(var1_1);
        }

        @Override
        protected final SortedSet<E> delegate() {
            return this.unmodifiableDelegate;
        }

        @Override
        public final boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Stream<E> stream() {
            return this.delegate.stream();
        }

        @Override
        public final Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void forEach(Consumer<? super E> action) {
            void var1_1;
            this.delegate.forEach(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E lower(@ParametricNullness E e) {
            void var1_1;
            return this.delegate.lower(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E floor(@ParametricNullness E e) {
            void var1_1;
            return this.delegate.floor(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E ceiling(@ParametricNullness E e) {
            void var1_1;
            return this.delegate.ceiling(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E higher(@ParametricNullness E e) {
            void var1_1;
            return this.delegate.higher(var1_1);
        }

        @Override
        public final E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final E pollLast() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<E> descendingSet() {
            void var1_1;
            UnmodifiableNavigableSet<E> result = this.descendingSet;
            if (result == null) {
                result = this.descendingSet = new UnmodifiableNavigableSet<E>(this.delegate.descendingSet());
                this.descendingSet.descendingSet = this;
            }
            return var1_1;
        }

        @Override
        public final Iterator<E> descendingIterator() {
            return Iterators.unmodifiableIterator(this.delegate.descendingIterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return Sets.unmodifiableNavigableSet(this.delegate.subSet(var1_1, (boolean)var2_2, var3_3, toInclusive));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Sets.unmodifiableNavigableSet(this.delegate.headSet(var1_1, (boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Sets.unmodifiableNavigableSet(this.delegate.tailSet(var1_1, (boolean)var2_2));
        }
    }

    private static final class PowerSet<E>
    extends AbstractSet<Set<E>> {
        final ImmutableMap<E, Integer> inputSet;

        /*
         * WARNING - void declaration
         */
        PowerSet(Set<E> input) {
            void var1_1;
            Preconditions.checkArgument(input.size() <= 30, "Too many elements to create power set: %s > 30", input.size());
            this.inputSet = Maps.indexMap(var1_1);
        }

        @Override
        public final int size() {
            return 1 << this.inputSet.size();
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        @Override
        public final Iterator<Set<E>> iterator() {
            PowerSet powerSet = this;
            return new AbstractIndexedListIterator<Set<E>>(powerSet, powerSet.size()){
                final /* synthetic */ PowerSet this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((int)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected Set<E> get(int setBits) {
                    void var1_1;
                    return new SubSet(this.this$0.inputSet, (int)var1_1);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object obj) {
            if (obj instanceof Set) {
                void var1_1;
                Set set = (Set)obj;
                return ((AbstractCollection)((Object)this.inputSet.keySet())).containsAll((Collection<?>)var1_1);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object obj) {
            void var1_1;
            if (obj instanceof PowerSet) {
                PowerSet that = (PowerSet)obj;
                return ((ImmutableSet)this.inputSet.keySet()).equals(var1_1.inputSet.keySet());
            }
            return super.equals(var1_1);
        }

        @Override
        public final int hashCode() {
            return ((ImmutableSet)this.inputSet.keySet()).hashCode() << this.inputSet.size() - 1;
        }

        @Override
        public final String toString() {
            String string = String.valueOf(this.inputSet);
            return new StringBuilder(10 + String.valueOf(string).length()).append("powerSet(").append(string).append(")").toString();
        }
    }

    private static final class SubSet<E>
    extends AbstractSet<E> {
        private final ImmutableMap<E, Integer> inputSet;
        private final int mask;

        /*
         * WARNING - void declaration
         */
        SubSet(ImmutableMap<E, Integer> inputSet, int mask) {
            void var2_2;
            void var1_1;
            this.inputSet = var1_1;
            this.mask = var2_2;
        }

        @Override
        public final Iterator<E> iterator() {
            return new UnmodifiableIterator<E>(this){
                final ImmutableList<E> elements;
                int remainingSetBits;
                final /* synthetic */ SubSet this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.elements = ((ImmutableCollection)((Object)this.this$0.inputSet.keySet())).asList();
                    this.remainingSetBits = this.this$0.mask;
                }

                @Override
                public boolean hasNext() {
                    return this.remainingSetBits != 0;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public E next() {
                    void var1_1;
                    int index = Integer.numberOfTrailingZeros(this.remainingSetBits);
                    if (index == 32) {
                        throw new NoSuchElementException();
                    }
                    this.remainingSetBits &= ~(1 << index);
                    return this.elements.get((int)var1_1);
                }
            };
        }

        @Override
        public final int size() {
            return Integer.bitCount(this.mask);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            Integer index = this.inputSet.get(o);
            return index != null && (this.mask & 1 << var1_1.intValue()) != 0;
        }
    }

    private static final class CartesianSet<E>
    extends ForwardingCollection<List<E>>
    implements Set<List<E>> {
        private final transient ImmutableList<ImmutableSet<E>> axes;
        private final transient CartesianList<E> delegate;

        /*
         * WARNING - void declaration
         */
        static <E> Set<List<E>> create(List<? extends Set<? extends E>> sets) {
            Collection<Set<Object>> collection;
            void var1_1;
            Set set;
            ImmutableList.Builder axesBuilder = new ImmutableList.Builder(sets.size());
            sets = sets.iterator();
            while (sets.hasNext()) {
                set = (Set)sets.next();
                ImmutableSet copy = ImmutableSet.copyOf(set);
                if (copy.isEmpty()) {
                    return ImmutableSet.of();
                }
                axesBuilder.add(copy);
            }
            Collection<Set<Object>> axes = var1_1.build();
            ImmutableList listAxes = new ImmutableList<List<E>>((ImmutableList)axes){
                final /* synthetic */ ImmutableList val$axes;
                {
                    this.val$axes = immutableList;
                }

                @Override
                public int size() {
                    return this.val$axes.size();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public List<E> get(int index) {
                    void var1_1;
                    return ((ImmutableSet)this.val$axes.get((int)var1_1)).asList();
                }

                @Override
                boolean isPartialView() {
                    return true;
                }
            };
            return new CartesianSet(collection, new CartesianList(set));
        }

        /*
         * WARNING - void declaration
         */
        private CartesianSet(ImmutableList<ImmutableSet<E>> axes, CartesianList<E> delegate) {
            void var2_2;
            void var1_1;
            this.axes = var1_1;
            this.delegate = var2_2;
        }

        @Override
        protected final Collection<List<E>> delegate() {
            return this.delegate;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            Iterator iterator;
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (list.size() != this.axes.size()) {
                return false;
            }
            int i = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object o = iterator.next();
                if (!((ImmutableSet)this.axes.get(i)).contains(var3_3)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            void var1_1;
            if (object instanceof CartesianSet) {
                CartesianSet that = (CartesianSet)object;
                return this.axes.equals(var1_1.axes);
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int hashCode() {
            void var1_1;
            int adjust = this.size() - 1;
            for (int i = 0; i < this.axes.size(); ++i) {
                adjust *= 31;
                adjust = ~(~adjust);
            }
            int hash = 1;
            for (Set set : this.axes) {
                hash = hash * 31 + this.size() / set.size() * set.hashCode();
                hash = ~(~hash);
            }
            return ~(~(var2_2 += var1_1));
        }
    }

    @GwtIncompatible
    private static class FilteredNavigableSet<E>
    extends FilteredSortedSet<E>
    implements NavigableSet<E> {
        /*
         * WARNING - void declaration
         */
        FilteredNavigableSet(NavigableSet<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        NavigableSet<E> unfiltered() {
            return (NavigableSet)this.unfiltered;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E lower(@ParametricNullness E e) {
            void var1_1;
            return Iterators.find(this.unfiltered().headSet(var1_1, false).descendingIterator(), this.predicate, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E floor(@ParametricNullness E e) {
            void var1_1;
            return Iterators.find(this.unfiltered().headSet(var1_1, true).descendingIterator(), this.predicate, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E ceiling(@ParametricNullness E e) {
            void var1_1;
            return Iterables.find(this.unfiltered().tailSet(var1_1, true), this.predicate, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E higher(@ParametricNullness E e) {
            void var1_1;
            return Iterables.find(this.unfiltered().tailSet(var1_1, false), this.predicate, null);
        }

        @Override
        public E pollFirst() {
            return Iterables.removeFirstMatching(this.unfiltered(), this.predicate);
        }

        @Override
        public E pollLast() {
            return Iterables.removeFirstMatching(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return Sets.filter(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.filter(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        @ParametricNullness
        public E last() {
            return Iterators.find(this.unfiltered().descendingIterator(), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return Sets.filter(this.unfiltered().subSet(var1_1, (boolean)var2_2, var3_3, toInclusive), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Sets.filter(this.unfiltered().headSet(var1_1, (boolean)var2_2), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Sets.filter(this.unfiltered().tailSet(var1_1, (boolean)var2_2), this.predicate);
        }
    }

    private static class FilteredSortedSet<E>
    extends FilteredSet<E>
    implements SortedSet<E> {
        /*
         * WARNING - void declaration
         */
        FilteredSortedSet(SortedSet<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.unfiltered).comparator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
            void var2_2;
            void var1_1;
            return new FilteredSortedSet(((SortedSet)this.unfiltered).subSet(var1_1, var2_2), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> headSet(@ParametricNullness E toElement) {
            void var1_1;
            return new FilteredSortedSet(((SortedSet)this.unfiltered).headSet(var1_1), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
            void var1_1;
            return new FilteredSortedSet(((SortedSet)this.unfiltered).tailSet(var1_1), this.predicate);
        }

        @Override
        @ParametricNullness
        public E first() {
            return Iterators.find(this.unfiltered.iterator(), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public E last() {
            SortedSet<void> sortedUnfiltered = (SortedSet<void>)this.unfiltered;
            Object element;
            while (!this.predicate.apply(element = sortedUnfiltered.last())) {
                void var2_2;
                sortedUnfiltered = sortedUnfiltered.headSet(var2_2);
            }
            return element;
        }
    }

    private static class FilteredSet<E>
    extends Collections2.FilteredCollection<E>
    implements Set<E> {
        /*
         * WARNING - void declaration
         */
        FilteredSet(Set<E> unfiltered, com.google.common.base.Predicate<? super E> predicate) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            return Sets.equalsImpl(this, var1_1);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        public ImmutableSet<E> immutableCopy() {
            return ImmutableSet.copyOf(this);
        }

        /*
         * WARNING - void declaration
         */
        public <S extends Set<E>> S copyInto(S set) {
            void var1_1;
            set.addAll(this);
            return var1_1;
        }

        @Override
        @Deprecated
        public final boolean add(@ParametricNullness E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean addAll(Collection<? extends E> newElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean removeAll(Collection<?> oldElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final boolean retainAll(Collection<?> elementsToKeep) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract UnmodifiableIterator<E> iterator();
    }

    static abstract class ImprovedAbstractSet<E>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_1;
            return Sets.removeAllImpl(this, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var1_1;
            return super.retainAll((Collection)Preconditions.checkNotNull(var1_1));
        }
    }
}

