/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class Serialization {
    private Serialization() {
    }

    static int readCount(ObjectInputStream stream) throws IOException {
        return stream.readInt();
    }

    static <K, V> void writeMap(Map<K, V> map, ObjectOutputStream stream) throws IOException {
        Object object;
        stream.writeInt(map.size());
        for (Map.Entry entry : object.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void populateMap(Map<K, V> map, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        void var1_1;
        Map<K, V> map2;
        int size = stream.readInt();
        Serialization.populateMap(map2, (ObjectInputStream)var1_1, (int)var2_2);
    }

    static <K, V> void populateMap(Map<K, V> map, ObjectInputStream stream, int size) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            map.put(key, value);
        }
    }

    static <E> void writeMultiset(Multiset<E> multiset, ObjectOutputStream stream) throws IOException {
        Object object;
        int n = multiset.entrySet().size();
        stream.writeInt(n);
        for (Multiset.Entry entry : object.entrySet()) {
            stream.writeObject(entry.getElement());
            stream.writeInt(entry.getCount());
        }
    }

    /*
     * WARNING - void declaration
     */
    static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        void var1_1;
        Multiset<E> multiset2;
        int distinctElements = stream.readInt();
        Serialization.populateMultiset(multiset2, (ObjectInputStream)var1_1, (int)var2_2);
    }

    static <E> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream, int distinctElements) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctElements; ++i) {
            Object element = stream.readObject();
            int count = stream.readInt();
            multiset.add(element, count);
        }
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void writeMultimap(Multimap<K, V> multimap, ObjectOutputStream stream) throws IOException {
        Object object;
        stream.writeInt(multimap.asMap().size());
        for (Map.Entry entry : object.asMap().entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeInt(((Collection)entry.getValue()).size());
            for (Object value : (Collection)entry.getValue()) {
                void var3_4;
                stream.writeObject(var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        void var1_1;
        Multimap<K, V> multimap2;
        int distinctKeys = stream.readInt();
        Serialization.populateMultimap(multimap2, (ObjectInputStream)var1_1, (int)var2_2);
    }

    static <K, V> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream, int distinctKeys) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = stream.readObject();
            Collection<V> values = multimap.get(key);
            int valueCount = stream.readInt();
            for (int j = 0; j < valueCount; ++j) {
                Object value = stream.readObject();
                values.add(value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static <T> FieldSetter<T> getFieldSetter(Class<T> clazz, String fieldName) {
        try {
            void var1_2;
            AnnotatedElement field = clazz.getDeclaredField((String)var1_2);
            return new FieldSetter((Field)field);
        }
        catch (NoSuchFieldException e) {
            void var0_1;
            throw new AssertionError(var0_1);
        }
    }

    static final class FieldSetter<T> {
        private final Field field;

        /*
         * WARNING - void declaration
         */
        private FieldSetter(Field field) {
            void var1_1;
            this.field = field;
            var1_1.setAccessible(true);
        }

        /*
         * WARNING - void declaration
         */
        final void set(T instance, Object value) {
            try {
                void var2_3;
                this.field.set(instance, var2_3);
                return;
            }
            catch (IllegalAccessException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        final void set(T instance, int value) {
            try {
                void var2_3;
                this.field.set(instance, (int)var2_3);
                return;
            }
            catch (IllegalAccessException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }
    }
}

