/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import java.io.Serializable;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ReverseOrdering<T>
extends Ordering<T>
implements Serializable {
    final Ordering<? super T> forwardOrder;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    ReverseOrdering(Ordering<? super T> forwardOrder) {
        void var1_1;
        this.forwardOrder = (Ordering)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compare(@ParametricNullness T a, @ParametricNullness T b) {
        void var1_1;
        void var2_2;
        return this.forwardOrder.compare(var2_2, var1_1);
    }

    @Override
    public final <S extends T> Ordering<S> reverse() {
        return this.forwardOrder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b) {
        void var2_2;
        void var1_1;
        return this.forwardOrder.max(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.forwardOrder.max(var1_1, var2_2, var3_3, rest);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E min(Iterator<E> iterator) {
        void var1_1;
        return this.forwardOrder.max(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E min(Iterable<E> iterable) {
        void var1_1;
        return this.forwardOrder.max(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b) {
        void var2_2;
        void var1_1;
        return this.forwardOrder.min(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.forwardOrder.min(var1_1, var2_2, var3_3, rest);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E max(Iterator<E> iterator) {
        void var1_1;
        return this.forwardOrder.min(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <E extends T> E max(Iterable<E> iterable) {
        void var1_1;
        return this.forwardOrder.min(var1_1);
    }

    public final int hashCode() {
        return -this.forwardOrder.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ReverseOrdering) {
            void var1_1;
            ReverseOrdering that = (ReverseOrdering)object;
            return this.forwardOrder.equals(var1_1.forwardOrder);
        }
        return false;
    }

    public final String toString() {
        String string = String.valueOf(this.forwardOrder);
        return new StringBuilder(10 + String.valueOf(string).length()).append(string).append(".reverse()").toString();
    }
}

