/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.DenseImmutableTable;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class RegularImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    RegularImmutableTable() {
    }

    abstract Table.Cell<R, C, V> getCell(int var1);

    @Override
    final ImmutableSet<Table.Cell<R, C, V>> createCellSet() {
        if (this.isEmpty()) {
            return ImmutableSet.of();
        }
        return new CellSet();
    }

    abstract V getValue(int var1);

    @Override
    final ImmutableCollection<V> createValues() {
        if (this.isEmpty()) {
            return ImmutableList.of();
        }
        return new Values();
    }

    /*
     * WARNING - void declaration
     */
    static <R, C, V> RegularImmutableTable<R, C, V> forCells(List<Table.Cell<R, C, V>> cells, Comparator<? super R> rowComparator, Comparator<? super C> columnComparator) {
        void var2_2;
        void var1_1;
        List<Table.Cell<R, C, V>> list;
        Preconditions.checkNotNull(cells);
        if (rowComparator != null || columnComparator != null) {
            void var3_3;
            Comparator comparator = (cell1, cell2) -> {
                void var3_4;
                void var2_3;
                void var1_2;
                int rowCompare = rowComparator == null ? 0 : rowComparator.compare((Object)cell1.getRowKey(), (Object)cell2.getRowKey());
                if (rowCompare != 0) {
                    void var0_1;
                    return (int)var0_1;
                }
                if (columnComparator == null) {
                    return 0;
                }
                return var1_2.compare(var2_3.getColumnKey(), var3_4.getColumnKey());
            };
            Collections.sort(cells, var3_3);
        }
        return RegularImmutableTable.forCellsInternal(list, var1_1, var2_2);
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forCells(Iterable<Table.Cell<R, C, V>> cells) {
        return RegularImmutableTable.forCellsInternal(cells, null, null);
    }

    /*
     * WARNING - void declaration
     */
    private static <R, C, V> RegularImmutableTable<R, C, V> forCellsInternal(Iterable<Table.Cell<R, C, V>> cells, Comparator<? super R> rowComparator, Comparator<? super C> columnComparator) {
        Iterable<Table.Cell<R, C, V>> iterable;
        void var2_2;
        void var3_3;
        void var1_1;
        LinkedHashSet rowSpaceBuilder = new LinkedHashSet();
        LinkedHashSet columnSpaceBuilder = new LinkedHashSet();
        ImmutableList<Table.Cell<R, C, V>> cellList = ImmutableList.copyOf(cells);
        cells = cells.iterator();
        while (cells.hasNext()) {
            Table.Cell cell = (Table.Cell)cells.next();
            rowSpaceBuilder.add(cell.getRowKey());
            columnSpaceBuilder.add(cell.getColumnKey());
        }
        Iterable<Table.Cell<R, C, V>> rowSpace = rowComparator == null ? ImmutableSet.copyOf(rowSpaceBuilder) : ImmutableSet.copyOf(ImmutableList.sortedCopyOf(var1_1, var3_3));
        ImmutableSet columnSpace = columnComparator == null ? ImmutableSet.copyOf(columnSpaceBuilder) : ImmutableSet.copyOf(ImmutableList.sortedCopyOf(var2_2, columnSpaceBuilder));
        return RegularImmutableTable.forOrderedComponents(cellList, iterable, columnSpace);
    }

    /*
     * WARNING - void declaration
     */
    static <R, C, V> RegularImmutableTable<R, C, V> forOrderedComponents(ImmutableList<Table.Cell<R, C, V>> cellList, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
        void var2_2;
        void var1_1;
        ImmutableList<Table.Cell<R, C, V>> immutableList;
        if ((long)cellList.size() > (long)rowSpace.size() * (long)columnSpace.size() / 2L) {
            return new DenseImmutableTable<R, C, V>(cellList, rowSpace, columnSpace);
        }
        return new SparseImmutableTable<R, C, V>(immutableList, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void checkNoDuplicate(R rowKey, C columnKey, V existingValue, V newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(existingValue == null, "Duplicate key: (row=%s, column=%s), values: [%s, %s].", (Object)var1_1, (Object)var2_2, newValue, (Object)var3_3);
    }

    private final class Values
    extends ImmutableList<V> {
        private Values() {
        }

        @Override
        public final int size() {
            return RegularImmutableTable.this.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(int index) {
            void var1_1;
            return RegularImmutableTable.this.getValue((int)var1_1);
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }

    private final class CellSet
    extends IndexedImmutableSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public final int size() {
            return RegularImmutableTable.this.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Table.Cell<R, C, V> get(int index) {
            void var1_1;
            return RegularImmutableTable.this.getCell((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            if (object instanceof Table.Cell) {
                void var1_1;
                void var2_2;
                Table.Cell cell = (Table.Cell)object;
                Object value = RegularImmutableTable.this.get(cell.getRowKey(), cell.getColumnKey());
                return value != null && var2_2.equals(var1_1.getValue());
            }
            return false;
        }

        @Override
        final boolean isPartialView() {
            return false;
        }
    }
}

