/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedAsList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    static final RegularImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new RegularImmutableSortedSet(ImmutableList.of(), Ordering.natural());
    private final transient ImmutableList<E> elements;

    /*
     * WARNING - void declaration
     */
    RegularImmutableSortedSet(ImmutableList<E> elements, Comparator<? super E> comparator) {
        super(var2_2);
        void var1_1;
        void var2_2;
        this.elements = var1_1;
    }

    @Override
    final Object[] internalArray() {
        return this.elements.internalArray();
    }

    @Override
    final int internalArrayStart() {
        return this.elements.internalArrayStart();
    }

    @Override
    final int internalArrayEnd() {
        return this.elements.internalArrayEnd();
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return ((ImmutableCollection)this.elements).iterator();
    }

    @Override
    @GwtIncompatible
    public final UnmodifiableIterator<E> descendingIterator() {
        return ((ImmutableCollection)this.elements.reverse()).iterator();
    }

    @Override
    public final Spliterator<E> spliterator() {
        return ((ImmutableCollection)((ImmutableCollection)this).asList()).spliterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void forEach(Consumer<? super E> action) {
        void var1_1;
        this.elements.forEach((Consumer<E>)var1_1);
    }

    @Override
    public final int size() {
        return this.elements.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object o) {
        try {
            void var1_1;
            return o != null && this.unsafeBinarySearch(var1_1) >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public final boolean containsAll(Collection<?> targets) {
        if (targets instanceof Multiset) {
            targets = ((Multiset)targets).elementSet();
        }
        if (!SortedIterables.hasSameComparator(this.comparator(), targets) || targets.size() <= 1) {
            return super.containsAll(targets);
        }
        Iterator thisIterator = ((ImmutableCollection)this).iterator();
        Iterator<?> thatIterator = targets.iterator();
        if (!thisIterator.hasNext()) {
            return false;
        }
        Object target = thatIterator.next();
        Object current = thisIterator.next();
        try {
            while (true) {
                int cmp;
                if ((cmp = this.unsafeCompare(current, target)) < 0) {
                    if (!thisIterator.hasNext()) {
                        return false;
                    }
                    current = thisIterator.next();
                    continue;
                }
                if (cmp == 0) {
                    if (!thatIterator.hasNext()) {
                        return true;
                    }
                    target = thatIterator.next();
                    continue;
                }
                if (cmp > 0) break;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int unsafeBinarySearch(Object key) throws ClassCastException {
        void var1_1;
        return Collections.binarySearch(this.elements, var1_1, this.unsafeComparator());
    }

    @Override
    final boolean isPartialView() {
        return this.elements.isPartialView();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        void var1_1;
        return this.elements.copyIntoArray((Object[])var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set that = (Set)object;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (SortedIterables.hasSameComparator(this.comparator, that)) {
            Iterator otherIterator = that.iterator();
            try {
                for (Object element : this) {
                    void var3_3;
                    Object otherElement = otherIterator.next();
                    if (otherElement != null && this.unsafeCompare(var3_3, otherElement) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll((Collection<?>)var1_1);
    }

    @Override
    public final E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(0);
    }

    @Override
    public final E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(this.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E lower(E element) {
        void var1_2;
        int index = this.headIndex(element, false) - 1;
        if (index == -1) {
            return null;
        }
        return this.elements.get((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E floor(E element) {
        void var1_2;
        int index = this.headIndex(element, true) - 1;
        if (index == -1) {
            return null;
        }
        return this.elements.get((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E ceiling(E element) {
        void var1_2;
        int index = this.tailIndex(element, true);
        if (index == this.size()) {
            return null;
        }
        return this.elements.get((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E higher(E element) {
        void var1_2;
        int index = this.tailIndex(element, false);
        if (index == this.size()) {
            return null;
        }
        return this.elements.get((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableSortedSet<E> headSetImpl(E toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.getSubSet(0, this.headIndex(var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    final int headIndex(E toElement, boolean inclusive) {
        void var1_2;
        int index = Collections.binarySearch(this.elements, Preconditions.checkNotNull(toElement), this.comparator());
        if (index >= 0) {
            void var2_3;
            if (var2_3 != false) {
                return index + 1;
            }
            return index;
        }
        return (int)(~var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableSortedSet<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.tailSetImpl(var1_1, (boolean)var2_2).headSetImpl(var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableSortedSet<E> tailSetImpl(E fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        RegularImmutableSortedSet regularImmutableSortedSet = this;
        return regularImmutableSortedSet.getSubSet(regularImmutableSortedSet.tailIndex(var1_1, (boolean)var2_2), this.size());
    }

    /*
     * WARNING - void declaration
     */
    final int tailIndex(E fromElement, boolean inclusive) {
        void var1_2;
        int index = Collections.binarySearch(this.elements, Preconditions.checkNotNull(fromElement), this.comparator());
        if (index >= 0) {
            void var2_3;
            if (var2_3 != false) {
                return index;
            }
            return index + 1;
        }
        return (int)(~var1_2);
    }

    final Comparator<Object> unsafeComparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    final RegularImmutableSortedSet<E> getSubSet(int newFromIndex, int newToIndex) {
        if (newFromIndex == 0 && newToIndex == this.size()) {
            return this;
        }
        if (newFromIndex < newToIndex) {
            void var2_2;
            void var1_1;
            return new RegularImmutableSortedSet(this.elements.subList((int)var1_1, (int)var2_2), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int indexOf(Object target) {
        int position;
        if (target == null) {
            return -1;
        }
        try {
            position = Collections.binarySearch(this.elements, target, this.unsafeComparator());
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        if (position >= 0) {
            void var1_2;
            return (int)var1_2;
        }
        return -1;
    }

    @Override
    final ImmutableList<E> createAsList() {
        if (this.size() <= 1) {
            return this.elements;
        }
        RegularImmutableSortedSet regularImmutableSortedSet = this;
        return new ImmutableSortedAsList<E>(regularImmutableSortedSet, regularImmutableSortedSet.elements);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableSortedSet<E> createDescendingSet() {
        void var1_1;
        Comparator reversedOrder = Collections.reverseOrder(this.comparator);
        if (this.isEmpty()) {
            return RegularImmutableSortedSet.emptySet(reversedOrder);
        }
        return new RegularImmutableSortedSet<E>(this.elements.reverse(), var1_1);
    }
}

