/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.function.ObjIntConsumer;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class RegularImmutableSortedMultiset<E>
extends ImmutableSortedMultiset<E> {
    private static final long[] ZERO_CUMULATIVE_COUNTS = new long[]{0L};
    static final ImmutableSortedMultiset<Comparable> NATURAL_EMPTY_MULTISET = new RegularImmutableSortedMultiset(Ordering.natural());
    @VisibleForTesting
    final transient RegularImmutableSortedSet<E> elementSet;
    private final transient long[] cumulativeCounts;
    private final transient int offset;
    private final transient int length;

    /*
     * WARNING - void declaration
     */
    RegularImmutableSortedMultiset(Comparator<? super E> comparator) {
        void var1_1;
        this.elementSet = ImmutableSortedSet.emptySet(var1_1);
        this.cumulativeCounts = ZERO_CUMULATIVE_COUNTS;
        this.offset = 0;
        this.length = 0;
    }

    /*
     * WARNING - void declaration
     */
    RegularImmutableSortedMultiset(RegularImmutableSortedSet<E> elementSet, long[] cumulativeCounts, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.elementSet = var1_1;
        this.cumulativeCounts = var2_2;
        this.offset = var3_3;
        this.length = length;
    }

    /*
     * WARNING - void declaration
     */
    private int getCount(int index) {
        void var1_1;
        return (int)(this.cumulativeCounts[this.offset + index + 1] - this.cumulativeCounts[this.offset + var1_1]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Multiset.Entry<E> getEntry(int index) {
        void var1_1;
        return Multisets.immutableEntry(((ImmutableCollection)this.elementSet).asList().get(index), this.getCount((int)var1_1));
    }

    @Override
    public final void forEachEntry(ObjIntConsumer<? super E> action) {
        Preconditions.checkNotNull(action);
        for (int i = 0; i < this.length; ++i) {
            action.accept(((ImmutableCollection)this.elementSet).asList().get(i), this.getCount(i));
        }
    }

    @Override
    public final Multiset.Entry<E> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getEntry(0);
    }

    @Override
    public final Multiset.Entry<E> lastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        RegularImmutableSortedMultiset regularImmutableSortedMultiset = this;
        return regularImmutableSortedMultiset.getEntry(regularImmutableSortedMultiset.length - 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int count(Object element) {
        int index = this.elementSet.indexOf(element);
        if (index >= 0) {
            void var1_2;
            return this.getCount((int)var1_2);
        }
        return 0;
    }

    @Override
    public final int size() {
        long l = this.cumulativeCounts[this.offset + this.length] - this.cumulativeCounts[this.offset];
        return Ints.saturatedCast(l);
    }

    @Override
    public final ImmutableSortedSet<E> elementSet() {
        return this.elementSet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        return this.getSubMultiset(0, this.elementSet.headIndex(var1_1, Preconditions.checkNotNull(var2_2) == BoundType.CLOSED));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        RegularImmutableSortedMultiset regularImmutableSortedMultiset = this;
        return regularImmutableSortedMultiset.getSubMultiset(regularImmutableSortedMultiset.elementSet.tailIndex(var1_1, Preconditions.checkNotNull(var2_2) == BoundType.CLOSED), this.length);
    }

    /*
     * WARNING - void declaration
     */
    final ImmutableSortedMultiset<E> getSubMultiset(int from, int to) {
        void var1_1;
        void var2_2;
        void var3_3;
        Preconditions.checkPositionIndexes(from, to, this.length);
        if (from == to) {
            return RegularImmutableSortedMultiset.emptyMultiset(this.comparator());
        }
        if (from == 0 && to == this.length) {
            return this;
        }
        RegularImmutableSortedSet<E> subElementSet = this.elementSet.getSubSet(from, to);
        return new RegularImmutableSortedMultiset<E>(var3_3, this.cumulativeCounts, this.offset + from, (int)(var2_2 - var1_1));
    }

    @Override
    final boolean isPartialView() {
        return this.offset > 0 || this.length < this.cumulativeCounts.length - 1;
    }
}

