/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.JdkBackedImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true, serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private static final Multisets.ImmutableEntry<?>[] EMPTY_ARRAY = new Multisets.ImmutableEntry[0];
    static final ImmutableMultiset<Object> EMPTY = RegularImmutableMultiset.create(ImmutableList.of());
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.0;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 9;
    private final transient Multisets.ImmutableEntry<E>[] entries;
    private final transient Multisets.ImmutableEntry<?>[] hashTable;
    private final transient int size;
    private final transient int hashCode;
    private transient ImmutableSet<E> elementSet;

    /*
     * WARNING - void declaration
     */
    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries) {
        void var1_2;
        void var2_3;
        Iterator<? extends Multiset.Entry<? extends E>> iterator;
        int distinct = entries.size();
        Object[] entryArray = new Multisets.ImmutableEntry[distinct];
        if (distinct == 0) {
            return new RegularImmutableMultiset((Multisets.ImmutableEntry<E>[])entryArray, EMPTY_ARRAY, 0, 0, ImmutableSet.of());
        }
        int tableSize = Hashing.closedTableSize(distinct, 1.0);
        int mask = tableSize - 1;
        Multisets.ImmutableEntry[] hashTable = new Multisets.ImmutableEntry[tableSize];
        int index = 0;
        int hashCode = 0;
        long size = 0L;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Multisets.ImmutableEntry newEntry;
            Multiset.Entry entry;
            Multiset.Entry entry2 = entry = (Multiset.Entry)iterator.next();
            Object element = Preconditions.checkNotNull(entry.getElement());
            int count = entry2.getCount();
            int hash = element.hashCode();
            int bucket = Hashing.smear(hash) & mask;
            Multisets.ImmutableEntry bucketHead2 = hashTable[bucket];
            if (bucketHead2 == null) {
                boolean bucketHead2 = entry2 instanceof Multisets.ImmutableEntry && !(entry2 instanceof NonTerminalEntry);
                newEntry = bucketHead2 ? (Multisets.ImmutableEntry)entry2 : new Multisets.ImmutableEntry(element, count);
            } else {
                newEntry = new NonTerminalEntry(element, count, bucketHead2);
            }
            hashCode += hash ^ count;
            entryArray[index++] = newEntry;
            hashTable[bucket] = newEntry;
            size += (long)count;
        }
        if (RegularImmutableMultiset.hashFloodingDetected(hashTable)) {
            return JdkBackedImmutableMultiset.create(ImmutableList.asImmutableList(entryArray));
        }
        return new RegularImmutableMultiset<E>((Multisets.ImmutableEntry<E>[])var2_3, (Multisets.ImmutableEntry<?>[])var1_2, Ints.saturatedCast(size), hashCode, null);
    }

    private static boolean hashFloodingDetected(Multisets.ImmutableEntry<?>[] hashTable) {
        for (int i = 0; i < hashTable.length; ++i) {
            int bucketLength = 0;
            for (Multisets.ImmutableEntry<?> entry = hashTable[i]; entry != null; entry = entry.nextInBucket()) {
                if (++bucketLength <= 9) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private RegularImmutableMultiset(Multisets.ImmutableEntry<E>[] entries, Multisets.ImmutableEntry<?>[] hashTable, int size, int hashCode, ImmutableSet<E> elementSet) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.entries = var1_1;
        this.hashTable = var2_2;
        this.size = var3_3;
        this.hashCode = hashCode;
        this.elementSet = elementSet;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(Object element) {
        Multisets.ImmutableEntry<?>[] hashTable = this.hashTable;
        if (element == null || hashTable.length == 0) {
            return 0;
        }
        int hash = Hashing.smearedHash(element);
        int mask = hashTable.length - 1;
        for (Multisets.ImmutableEntry<?> entry = hashTable[var3_3 & mask]; entry != null; entry = entry.nextInBucket()) {
            if (!Objects.equal(element, entry.getElement())) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<E> elementSet() {
        void var1_1;
        ImmutableSet<E> result = this.elementSet;
        if (result == null) {
            this.elementSet = new ImmutableMultiset.ElementSet(Arrays.asList(this.entries), this);
            return this.elementSet;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Multiset.Entry<E> getEntry(int index) {
        void var1_1;
        return this.entries[var1_1];
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private static final class NonTerminalEntry<E>
    extends Multisets.ImmutableEntry<E> {
        private final Multisets.ImmutableEntry<E> nextInBucket;

        /*
         * WARNING - void declaration
         */
        NonTerminalEntry(E element, int count, Multisets.ImmutableEntry<E> nextInBucket) {
            super(var1_1, (int)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.nextInBucket = var3_3;
        }

        @Override
        public final Multisets.ImmutableEntry<E> nextInBucket() {
            return this.nextInBucket;
        }
    }
}

