/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.JdkBackedImmutableMap;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.2;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 8;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    private static final long serialVersionUID = 0L;

    static <K, V> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        Map.Entry<K, V>[] entryArray;
        return RegularImmutableMap.fromEntryArray(entries.length, entryArray, true);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableMap<K, V> fromEntryArray(int n2, Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) {
        Preconditions.checkPositionIndex(n2, entryArray.length);
        if (n2 == 0) {
            ImmutableMap<Object, Object> n2 = EMPTY;
            return n2;
        }
        try {
            int n2;
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(n2, entryArray, throwIfDuplicateKeys);
        }
        catch (BucketOverflowException bucketOverflowException) {
            void var2_3;
            void var1_2;
            int n3;
            return JdkBackedImmutableMap.create(n3, var1_2, (boolean)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableMap<K, V> fromEntryArrayCheckingBucketOverflow(int n, Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) throws BucketOverflowException {
        void var3_3;
        int mask;
        ImmutableMapEntry<K, V>[] table;
        while (true) {
            Map.Entry<K, V>[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
            int tableSize = Hashing.closedTableSize(n, 1.2);
            table = ImmutableMapEntry.createEntryArray(tableSize);
            mask = tableSize - 1;
            IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean> duplicates = null;
            int dupCount = 0;
            for (int entryIndex = n - 1; entryIndex >= 0; --entryIndex) {
                Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[entryIndex]);
                K key = entry.getKey();
                V value = entry.getValue();
                CollectPreconditions.checkEntryNotNull(key, value);
                int tableIndex = Hashing.smear(key.hashCode()) & mask;
                ImmutableMapEntry keyBucketHead = table[tableIndex];
                ImmutableMapEntry effectiveEntry = RegularImmutableMap.checkNoConflictInKeyBucket(key, value, keyBucketHead, throwIfDuplicateKeys);
                if (effectiveEntry == null) {
                    effectiveEntry = keyBucketHead == null ? RegularImmutableMap.makeImmutable(entry, key, value) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(key, value, keyBucketHead);
                    table[tableIndex] = effectiveEntry;
                } else {
                    if (duplicates == null) {
                        duplicates = new IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean>();
                    }
                    duplicates.put((ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>)effectiveEntry, Boolean.TRUE);
                    ++dupCount;
                    if (entries == entryArray) {
                        entries = (Map.Entry[])entries.clone();
                    }
                }
                entries[entryIndex] = effectiveEntry;
            }
            if (duplicates == null) break;
            int n2 = n;
            int n3 = Hashing.closedTableSize((entries = RegularImmutableMap.removeDuplicates(entries, n2, n2 - dupCount, duplicates)).length, 1.2);
            if (n3 == tableSize) break;
            throwIfDuplicateKeys = true;
            entryArray = entries;
            n = entries.length;
        }
        return new RegularImmutableMap((Map.Entry<K, V>[])var3_3, table, mask);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Map.Entry<K, V>[] removeDuplicates(Map.Entry<K, V>[] entries, int n, int newN, IdentityHashMap<Map.Entry<K, V>, Boolean> duplicates) {
        void var2_3;
        ImmutableMapEntry<K, V>[] newEntries = ImmutableMapEntry.createEntryArray(newN);
        int out = 0;
        for (int in = 0; in < n; ++in) {
            Map.Entry<K, V> entry = entries[in];
            Boolean status = duplicates.get(entry);
            if (status != null) {
                if (!status.booleanValue()) continue;
                duplicates.put(entry, Boolean.FALSE);
            }
            newEntries[out++] = entry;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry, K key, V value) {
        void var2_2;
        void var1_1;
        boolean bl = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        if (bl) {
            Map.Entry<K, V> entry2;
            return (ImmutableMapEntry)entry2;
        }
        return new ImmutableMapEntry<void, void>(var1_1, var2_2);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry) {
        Map.Entry<K, V> entry2;
        Map.Entry<K, V> entry3 = entry;
        return RegularImmutableMap.makeImmutable(entry3, entry3.getKey(), entry2.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private RegularImmutableMap(Map.Entry<K, V>[] entries, ImmutableMapEntry<K, V>[] table, int mask) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.entries = var1_1;
        this.table = var2_2;
        this.mask = var3_3;
    }

    static <K, V> ImmutableMapEntry<K, V> checkNoConflictInKeyBucket(Object key, Object newValue, ImmutableMapEntry<K, V> keyBucketHead, boolean throwIfDuplicateKeys) throws BucketOverflowException {
        int bucketSize = 0;
        while (keyBucketHead != null) {
            if (keyBucketHead.getKey().equals(key)) {
                if (throwIfDuplicateKeys) {
                    String string = String.valueOf(key);
                    String string2 = String.valueOf(newValue);
                    RegularImmutableMap.checkNoConflict(false, "key", keyBucketHead, new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
                } else {
                    return keyBucketHead;
                }
            }
            if (++bucketSize > 8) {
                throw new BucketOverflowException();
            }
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
        return null;
    }

    @Override
    public final V get(Object key) {
        return RegularImmutableMap.get(key, this.table, this.mask);
    }

    /*
     * WARNING - void declaration
     */
    static <V> V get(Object key, ImmutableMapEntry<?, V>[] keyTable, int mask) {
        if (key == null || keyTable == null) {
            return null;
        }
        int index = Hashing.smear(key.hashCode()) & mask;
        for (ImmutableMapEntry<?, V> entry = keyTable[index]; entry != null; entry = entry.getNextInKeyBucket()) {
            void var2_3;
            Object candidateKey = entry.getKey();
            if (!key.equals(var2_3)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        Map.Entry<K, V>[] entryArray = this.entries;
        int n = this.entries.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry<K, V> entry = entryArray[i];
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final int size() {
        return this.entries.length;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        RegularImmutableMap regularImmutableMap = this;
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(regularImmutableMap, regularImmutableMap.entries);
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    final ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @GwtCompatible(emulated=true)
    private static final class Values<K, V>
    extends ImmutableList<V> {
        final RegularImmutableMap<K, V> map;

        /*
         * WARNING - void declaration
         */
        Values(RegularImmutableMap<K, V> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(int index) {
            void var1_1;
            return this.map.entries[var1_1].getValue();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        final boolean isPartialView() {
            return true;
        }

        @GwtIncompatible
        private static class SerializedForm<V>
        implements Serializable {
            final ImmutableMap<?, V> map;
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            SerializedForm(ImmutableMap<?, V> map) {
                void var1_1;
                this.map = var1_1;
            }

            Object readResolve() {
                return this.map.values();
            }
        }
    }

    @GwtCompatible(emulated=true)
    private static final class KeySet<K>
    extends IndexedImmutableSet<K> {
        private final RegularImmutableMap<K, ?> map;

        /*
         * WARNING - void declaration
         */
        KeySet(RegularImmutableMap<K, ?> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final K get(int index) {
            void var1_1;
            return this.map.entries[var1_1].getKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            void var1_1;
            return this.map.containsKey(var1_1);
        }

        @Override
        final boolean isPartialView() {
            return true;
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @GwtIncompatible
        private static class SerializedForm<K>
        implements Serializable {
            final ImmutableMap<K, ?> map;
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            SerializedForm(ImmutableMap<K, ?> map) {
                void var1_1;
                this.map = var1_1;
            }

            Object readResolve() {
                return this.map.keySet();
            }
        }
    }

    static class BucketOverflowException
    extends Exception {
        BucketOverflowException() {
        }
    }
}

