/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.JdkBackedImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap(null, null, ImmutableMap.EMPTY_ENTRY_ARRAY, 0, 0);
    static final double MAX_LOAD_FACTOR = 1.2;
    private final transient ImmutableMapEntry<K, V>[] keyTable;
    private final transient ImmutableMapEntry<K, V>[] valueTable;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    private transient ImmutableBiMap<V, K> inverse;

    static <K, V> ImmutableBiMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        Map.Entry<K, V>[] entryArray;
        return RegularImmutableBiMap.fromEntryArray(entries.length, entryArray);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableBiMap<K, V> fromEntryArray(int n, Map.Entry<K, V>[] entryArray) {
        void var3_4;
        void var2_3;
        Preconditions.checkPositionIndex(n, entryArray.length);
        int tableSize = Hashing.closedTableSize(n, 1.2);
        int mask = tableSize - 1;
        ImmutableMapEntry<K, V>[] keyTable = ImmutableMapEntry.createEntryArray(tableSize);
        ImmutableMapEntry<K, V>[] valueTable = ImmutableMapEntry.createEntryArray(tableSize);
        Map.Entry<K, V>[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int hashCode = 0;
        for (int i = 0; i < n; ++i) {
            Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[i]);
            K key = entry.getKey();
            V value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int keyHash = key.hashCode();
            int valueHash = value.hashCode();
            int keyBucket = Hashing.smear(keyHash) & mask;
            int valueBucket = Hashing.smear(valueHash) & mask;
            ImmutableMapEntry nextInKeyBucket = keyTable[keyBucket];
            ImmutableMapEntry nextInValueBucket = valueTable[valueBucket];
            try {
                RegularImmutableMap.checkNoConflictInKeyBucket(key, value, nextInKeyBucket, true);
                RegularImmutableBiMap.checkNoConflictInValueBucket(value, entry, nextInValueBucket);
            }
            catch (RegularImmutableMap.BucketOverflowException bucketOverflowException) {
                return JdkBackedImmutableBiMap.create(n, entryArray);
            }
            ImmutableMapEntry newEntry = nextInValueBucket == null && nextInKeyBucket == null ? RegularImmutableMap.makeImmutable(entry, key, value) : new ImmutableMapEntry.NonTerminalImmutableBiMapEntry<K, V>(key, value, nextInKeyBucket, nextInValueBucket);
            keyTable[keyBucket] = newEntry;
            valueTable[valueBucket] = newEntry;
            entries[i] = newEntry;
            hashCode += keyHash ^ valueHash;
        }
        return new RegularImmutableBiMap(keyTable, (ImmutableMapEntry<K, V>[])var2_3, entries, (int)var3_4, hashCode);
    }

    /*
     * WARNING - void declaration
     */
    private RegularImmutableBiMap(ImmutableMapEntry<K, V>[] keyTable, ImmutableMapEntry<K, V>[] valueTable, Map.Entry<K, V>[] entries, int mask, int hashCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.keyTable = var1_1;
        this.valueTable = var2_2;
        this.entries = var3_3;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    private static void checkNoConflictInValueBucket(Object value, Map.Entry<?, ?> entry, ImmutableMapEntry<?, ?> valueBucketHead) throws RegularImmutableMap.BucketOverflowException {
        int bucketSize = 0;
        while (valueBucketHead != null) {
            RegularImmutableBiMap.checkNoConflict(!value.equals(valueBucketHead.getValue()), "value", entry, valueBucketHead);
            if (++bucketSize > 8) {
                throw new RegularImmutableMap.BucketOverflowException();
            }
            valueBucketHead = valueBucketHead.getNextInValueBucket();
        }
    }

    @Override
    public V get(Object key) {
        return RegularImmutableMap.get(key, this.keyTable, this.mask);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        if (this.isEmpty()) {
            return ImmutableSet.of();
        }
        RegularImmutableBiMap regularImmutableBiMap = this;
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(regularImmutableBiMap, regularImmutableBiMap.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        Map.Entry<K, V>[] entryArray = this.entries;
        int n = this.entries.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry<K, V> entry = entryArray[i];
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableBiMap<V, K> inverse() {
        void var1_1;
        if (this.isEmpty()) {
            return ImmutableBiMap.of();
        }
        ImmutableBiMap<V, K> result = this.inverse;
        if (result == null) {
            this.inverse = new Inverse();
            return this.inverse;
        }
        return var1_1;
    }

    private static class InverseSerializedForm<K, V>
    implements Serializable {
        private final ImmutableBiMap<K, V> forward;
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        InverseSerializedForm(ImmutableBiMap<K, V> forward) {
            void var1_1;
            this.forward = var1_1;
        }

        Object readResolve() {
            return this.forward.inverse();
        }
    }

    private final class Inverse
    extends ImmutableBiMap<V, K> {
        private Inverse() {
        }

        @Override
        public final int size() {
            return ((ImmutableBiMap)this).inverse().size();
        }

        @Override
        public final ImmutableBiMap<K, V> inverse() {
            return RegularImmutableBiMap.this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void forEach(BiConsumer<? super V, ? super K> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            RegularImmutableBiMap.this.forEach((arg_0, arg_1) -> Inverse.lambda$forEach$0((BiConsumer)var1_1, arg_0, arg_1));
        }

        @Override
        public final K get(Object value) {
            if (value == null || RegularImmutableBiMap.this.valueTable == null) {
                return null;
            }
            int bucket = Hashing.smear(value.hashCode()) & RegularImmutableBiMap.this.mask;
            for (ImmutableMapEntry entry = RegularImmutableBiMap.this.valueTable[bucket]; entry != null; entry = entry.getNextInValueBucket()) {
                if (!value.equals(entry.getValue())) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        final ImmutableSet<V> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        final ImmutableSet<Map.Entry<V, K>> createEntrySet() {
            return new InverseEntrySet(this);
        }

        @Override
        final boolean isPartialView() {
            return false;
        }

        @Override
        final Object writeReplace() {
            return new InverseSerializedForm(RegularImmutableBiMap.this);
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEach$0(BiConsumer action, Object k, Object v) {
            void var1_1;
            void var2_2;
            action.accept(var2_2, var1_1);
        }

        final class InverseEntrySet
        extends ImmutableMapEntrySet<V, K> {
            final /* synthetic */ Inverse this$1;

            /*
             * WARNING - void declaration
             */
            InverseEntrySet(Inverse this$1) {
                void var1_1;
                this.this$1 = var1_1;
            }

            @Override
            final ImmutableMap<V, K> map() {
                return this.this$1;
            }

            @Override
            final boolean isHashCodeFast() {
                return true;
            }

            @Override
            public final int hashCode() {
                return this.this$1.RegularImmutableBiMap.this.hashCode;
            }

            @Override
            public final UnmodifiableIterator<Map.Entry<V, K>> iterator() {
                return ((ImmutableCollection)((ImmutableCollection)this).asList()).iterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void forEach(Consumer<? super Map.Entry<V, K>> action) {
                void var1_1;
                ((ImmutableCollection)this).asList().forEach(var1_1);
            }

            @Override
            final ImmutableList<Map.Entry<V, K>> createAsList() {
                return new ImmutableAsList<Map.Entry<V, K>>(this){
                    final /* synthetic */ InverseEntrySet this$2;
                    {
                        void var1_1;
                        this.this$2 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Map.Entry<V, K> get(int index) {
                        void var1_2;
                        Map.Entry entry = this.this$2.this$1.RegularImmutableBiMap.this.entries[index];
                        return Maps.immutableEntry(entry.getValue(), var1_2.getKey());
                    }

                    @Override
                    ImmutableCollection<Map.Entry<V, K>> delegateCollection() {
                        return this.this$2;
                    }
                };
            }
        }
    }
}

