/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.Collections2;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class RegularContiguousSet<C extends Comparable>
extends ContiguousSet<C> {
    private final Range<C> range;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    RegularContiguousSet(Range<C> range, DiscreteDomain<C> domain) {
        super(var2_2);
        void var1_1;
        void var2_2;
        this.range = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ContiguousSet<C> intersectionInCurrentDomain(Range<C> other) {
        if (this.range.isConnected(other)) {
            void var1_1;
            return ContiguousSet.create(this.range.intersection((Range<C>)var1_1), this.domain);
        }
        return new EmptyContiguousSet(this.domain);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ContiguousSet<C> headSetImpl(C toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.intersectionInCurrentDomain(Range.upTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ContiguousSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (fromElement.compareTo(toElement) == 0 && !fromInclusive && !toInclusive) {
            return new EmptyContiguousSet(this.domain);
        }
        return this.intersectionInCurrentDomain(Range.range(var1_1, BoundType.forBoolean((boolean)var2_2), var3_3, BoundType.forBoolean(toInclusive)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ContiguousSet<C> tailSetImpl(C fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.intersectionInCurrentDomain(Range.downTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    final int indexOf(Object target) {
        if (((ImmutableCollection)this).contains(target)) {
            void var1_1;
            return (int)this.domain.distance((Comparable)this.first(), (Comparable)Objects.requireNonNull(var1_1));
        }
        return -1;
    }

    @Override
    public final UnmodifiableIterator<C> iterator() {
        RegularContiguousSet regularContiguousSet = this;
        return new AbstractSequentialIterator<C>(regularContiguousSet, (Comparable)regularContiguousSet.first()){
            final C last;
            final /* synthetic */ RegularContiguousSet this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(var2_2);
                this.last = this.this$0.last();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected C computeNext(C previous) {
                void var1_1;
                if (RegularContiguousSet.access$000(previous, this.last)) {
                    return null;
                }
                return this.this$0.domain.next(var1_1);
            }
        };
    }

    @Override
    @GwtIncompatible
    public final UnmodifiableIterator<C> descendingIterator() {
        RegularContiguousSet regularContiguousSet = this;
        return new AbstractSequentialIterator<C>(regularContiguousSet, (Comparable)regularContiguousSet.last()){
            final C first;
            final /* synthetic */ RegularContiguousSet this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super(var2_2);
                this.first = this.this$0.first();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected C computeNext(C previous) {
                void var1_1;
                if (RegularContiguousSet.access$000(previous, this.first)) {
                    return null;
                }
                return this.this$0.domain.previous(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static boolean equalsOrThrow(Comparable<?> left, Comparable<?> right) {
        void var1_1;
        Comparable<?> comparable;
        return right != null && Range.compareOrThrow(comparable, (Comparable)var1_1) == 0;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final C first() {
        return (C)((Comparable)Objects.requireNonNull(this.range.lowerBound.leastValueAbove(this.domain)));
    }

    @Override
    public final C last() {
        return (C)((Comparable)Objects.requireNonNull(this.range.upperBound.greatestValueBelow(this.domain)));
    }

    @Override
    final ImmutableList<C> createAsList() {
        if (this.domain.supportsFastOffset) {
            return new ImmutableAsList<C>(this){
                final /* synthetic */ RegularContiguousSet this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                ImmutableSortedSet<C> delegateCollection() {
                    return this.this$0;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public C get(int i) {
                    void var1_1;
                    Preconditions.checkElementIndex(i, this.size());
                    return this.this$0.domain.offset(this.this$0.first(), (long)var1_1);
                }
            };
        }
        return super.createAsList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size() {
        void var1_1;
        long distance = this.domain.distance(this.first(), this.last());
        if (distance >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)var1_1 + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        try {
            void var1_1;
            return this.range.contains((Comparable)var1_1);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<?> targets) {
        void var1_1;
        return Collections2.containsAllImpl(this, var1_1);
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ContiguousSet<C> intersection(ContiguousSet<C> other) {
        Comparable upperEndpoint;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument(this.domain.equals(other.domain));
        if (other.isEmpty()) {
            return other;
        }
        Comparable lowerEndpoint = Ordering.natural().max(this.first(), (Comparable)other.first());
        if (lowerEndpoint.compareTo(upperEndpoint = Ordering.natural().min(this.last(), (Comparable)other.last())) <= 0) {
            void var1_1;
            void var2_2;
            return ContiguousSet.create(Range.closed(var2_2, var1_1), this.domain);
        }
        return new EmptyContiguousSet(this.domain);
    }

    @Override
    public final Range<C> range() {
        BoundType boundType = BoundType.CLOSED;
        return ((ContiguousSet)this).range(boundType, boundType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range<C> range(BoundType lowerBoundType, BoundType upperBoundType) {
        void var2_2;
        void var1_1;
        return Range.create(this.range.lowerBound.withLowerBoundType((BoundType)var1_1, this.domain), this.range.upperBound.withUpperBoundType((BoundType)var2_2, this.domain));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (object instanceof RegularContiguousSet) {
            RegularContiguousSet that = (RegularContiguousSet)object;
            if (this.domain.equals(that.domain)) {
                void var2_2;
                return this.first().equals(that.first()) && this.last().equals(var2_2.last());
            }
        }
        return super.equals(var1_1);
    }

    @Override
    public final int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    @GwtIncompatible
    final Object writeReplace() {
        return new SerializedForm(this.range, this.domain);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(Comparable x0, Comparable x1) {
        void var1_1;
        return RegularContiguousSet.equalsOrThrow(x0, var1_1);
    }

    @GwtIncompatible
    private static final class SerializedForm<C extends Comparable>
    implements Serializable {
        final Range<C> range;
        final DiscreteDomain<C> domain;

        /*
         * WARNING - void declaration
         */
        private SerializedForm(Range<C> range, DiscreteDomain<C> domain) {
            void var2_2;
            void var1_1;
            this.range = var1_1;
            this.domain = var2_2;
        }

        private Object readResolve() {
            return new RegularContiguousSet<C>(this.range, this.domain);
        }
    }
}

