/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BoundType;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeGwtSerializationDependencies;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Range<C extends Comparable>
extends RangeGwtSerializationDependencies
implements Predicate<C>,
Serializable {
    private static final Range<Comparable> ALL = new Range(Cut.belowAll(), Cut.aboveAll());
    final Cut<C> lowerBound;
    final Cut<C> upperBound;
    private static final long serialVersionUID = 0L;

    static <C extends Comparable<?>> Function<Range<C>, Cut<C>> lowerBoundFn() {
        return LowerBoundFn.INSTANCE;
    }

    static <C extends Comparable<?>> Function<Range<C>, Cut<C>> upperBoundFn() {
        return UpperBoundFn.INSTANCE;
    }

    static <C extends Comparable<?>> Ordering<Range<C>> rangeLexOrdering() {
        return RangeLexOrdering.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    static <C extends Comparable<?>> Range<C> create(Cut<C> lowerBound, Cut<C> upperBound) {
        void var1_1;
        Cut<C> cut;
        return new Range<C>(cut, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> open(C lower, C upper) {
        void var1_1;
        return Range.create(Cut.aboveValue(lower), Cut.belowValue(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> closed(C lower, C upper) {
        void var1_1;
        return Range.create(Cut.belowValue(lower), Cut.aboveValue(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> closedOpen(C lower, C upper) {
        void var1_1;
        return Range.create(Cut.belowValue(lower), Cut.belowValue(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> openClosed(C lower, C upper) {
        void var1_1;
        return Range.create(Cut.aboveValue(lower), Cut.aboveValue(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> range(C lower, BoundType lowerType, C upper, BoundType upperType) {
        void var1_1;
        Object object;
        void var2_2;
        void var3_3;
        Preconditions.checkNotNull(lowerType);
        Preconditions.checkNotNull(upperType);
        Object lowerBound = lowerType == BoundType.OPEN ? Cut.aboveValue(lower) : Cut.belowValue(lower);
        Cut<Object> upperBound = var3_3 == BoundType.OPEN ? Cut.belowValue(upper) : Cut.aboveValue(var2_2);
        return Range.create(object, var1_1);
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C endpoint) {
        C c;
        return Range.create(Cut.belowAll(), Cut.belowValue(c));
    }

    public static <C extends Comparable<?>> Range<C> atMost(C endpoint) {
        C c;
        return Range.create(Cut.belowAll(), Cut.aboveValue(c));
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> upTo(C endpoint, BoundType boundType) {
        void var1_1;
        switch (1.$SwitchMap$com$google$common$collect$BoundType[var1_1.ordinal()]) {
            case 1: {
                return Range.lessThan(endpoint);
            }
            case 2: {
                C c;
                return Range.atMost(c);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C endpoint) {
        return Range.create(Cut.aboveValue(endpoint), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C endpoint) {
        return Range.create(Cut.belowValue(endpoint), Cut.aboveAll());
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> downTo(C endpoint, BoundType boundType) {
        void var1_1;
        switch (1.$SwitchMap$com$google$common$collect$BoundType[var1_1.ordinal()]) {
            case 1: {
                return Range.greaterThan(endpoint);
            }
            case 2: {
                C c;
                return Range.atLeast(c);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return ALL;
    }

    public static <C extends Comparable<?>> Range<C> singleton(C value) {
        C c = value;
        return Range.closed(c, c);
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable<?>> Range<C> encloseAll(Iterable<C> values) {
        Object object;
        void var2_2;
        Preconditions.checkNotNull(values);
        if (values instanceof SortedSet) {
            SortedSet set = (SortedSet)values;
            Comparator comparator = set.comparator();
            if (Ordering.natural().equals(comparator) || comparator == null) {
                return Range.closed((Comparable)set.first(), (Comparable)set.last());
            }
        }
        Iterator<C> valueIterator = values.iterator();
        Comparable min = Preconditions.checkNotNull((Comparable)valueIterator.next());
        Object max = min;
        while (valueIterator.hasNext()) {
            void var3_3;
            Comparable value = Preconditions.checkNotNull((Comparable)valueIterator.next());
            min = Ordering.natural().min(min, value);
            max = (Comparable)Ordering.natural().max(max, var3_3);
        }
        return Range.closed(var2_2, object);
    }

    /*
     * WARNING - void declaration
     */
    private Range(Cut<C> lowerBound, Cut<C> upperBound) {
        this.lowerBound = Preconditions.checkNotNull(lowerBound);
        this.upperBound = Preconditions.checkNotNull(upperBound);
        if (lowerBound.compareTo(upperBound) > 0 || lowerBound == Cut.aboveAll() || upperBound == Cut.belowAll()) {
            void var2_2;
            void var1_1;
            String string = String.valueOf(Range.toString(var1_1, var2_2));
            throw new IllegalArgumentException(string.length() != 0 ? "Invalid range: ".concat(string) : new String("Invalid range: "));
        }
    }

    public final boolean hasLowerBound() {
        return this.lowerBound != Cut.belowAll();
    }

    public final C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public final BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public final boolean hasUpperBound() {
        return this.upperBound != Cut.aboveAll();
    }

    public final C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public final BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public final boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(C value) {
        void var1_1;
        Preconditions.checkNotNull(value);
        return this.lowerBound.isLessThan(value) && !this.upperBound.isLessThan(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final boolean apply(C input) {
        void var1_1;
        return this.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsAll(Iterable<? extends C> values) {
        void var1_1;
        if (Iterables.isEmpty(values)) {
            return true;
        }
        if (values instanceof SortedSet) {
            SortedSet set = (SortedSet)values;
            Comparator comparator = set.comparator();
            if (Ordering.natural().equals(comparator) || comparator == null) {
                Iterator iterator;
                return this.contains((Comparable)set.first()) && this.contains((Comparable)iterator.last());
            }
        }
        for (Comparable value : var1_1) {
            void var3_3;
            if (this.contains(var3_3)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean encloses(Range<C> other) {
        void var1_1;
        return this.lowerBound.compareTo(other.lowerBound) <= 0 && this.upperBound.compareTo(var1_1.upperBound) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isConnected(Range<C> other) {
        void var1_1;
        return this.lowerBound.compareTo(other.upperBound) <= 0 && var1_1.lowerBound.compareTo(this.upperBound) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final Range<C> intersection(Range<C> connectedRange) {
        void var3_5;
        void var2_3;
        void var1_1;
        int lowerCmp = this.lowerBound.compareTo(connectedRange.lowerBound);
        int upperCmp = this.upperBound.compareTo(connectedRange.upperBound);
        if (lowerCmp >= 0 && upperCmp <= 0) {
            return this;
        }
        if (lowerCmp <= 0 && upperCmp >= 0) {
            return connectedRange;
        }
        Cut<C> newLower = lowerCmp >= 0 ? this.lowerBound : connectedRange.lowerBound;
        Cut<C> newUpper = upperCmp <= 0 ? this.upperBound : connectedRange.upperBound;
        Preconditions.checkArgument(newLower.compareTo(newUpper) <= 0, "intersection is undefined for disconnected ranges %s and %s", (Object)this, (Object)var1_1);
        return Range.create(var2_3, var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final Range<C> gap(Range<C> otherRange) {
        void var1_1;
        void var3_5;
        void var2_3;
        if (this.lowerBound.compareTo(otherRange.upperBound) < 0 && otherRange.lowerBound.compareTo(this.upperBound) < 0) {
            String string = String.valueOf(this);
            String string2 = String.valueOf(otherRange);
            throw new IllegalArgumentException(new StringBuilder(39 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Ranges have a nonempty intersection: ").append(string).append(", ").append(string2).toString());
        }
        boolean isThisFirst = this.lowerBound.compareTo(otherRange.lowerBound) < 0;
        Range<C> firstRange = isThisFirst ? this : otherRange;
        Range<C> secondRange = var2_3 != false ? otherRange : this;
        return Range.create(var3_5.upperBound, var1_1.lowerBound);
    }

    /*
     * WARNING - void declaration
     */
    public final Range<C> span(Range<C> other) {
        void var1_1;
        void var2_3;
        void var3_4;
        int lowerCmp = this.lowerBound.compareTo(other.lowerBound);
        int upperCmp = this.upperBound.compareTo(other.upperBound);
        if (lowerCmp <= 0 && upperCmp >= 0) {
            return this;
        }
        if (lowerCmp >= 0 && upperCmp <= 0) {
            return other;
        }
        Cut<C> newLower = lowerCmp <= 0 ? this.lowerBound : other.lowerBound;
        Cut<C> newUpper = var3_4 >= 0 ? this.upperBound : other.upperBound;
        return Range.create(var2_3, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Range<C> canonical(DiscreteDomain<C> domain) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(domain);
        Cut<C> lower = this.lowerBound.canonical(domain);
        Cut<C> upper = this.upperBound.canonical(domain);
        if (lower == this.lowerBound && upper == this.upperBound) {
            return this;
        }
        return Range.create(var2_2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object instanceof Range) {
            void var1_1;
            Range other = (Range)object;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(var1_1.upperBound);
        }
        return false;
    }

    public final int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public final String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    /*
     * WARNING - void declaration
     */
    private static String toString(Cut<?> lowerBound, Cut<?> upperBound) {
        void var2_2;
        void var1_1;
        Cut<?> cut;
        StringBuilder sb = new StringBuilder(16);
        cut.describeAsLowerBound(sb);
        sb.append("..");
        var1_1.describeAsUpperBound(sb);
        return var2_2.toString();
    }

    final Object readResolve() {
        if (this.equals(ALL)) {
            return Range.all();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static int compareOrThrow(Comparable left, Comparable right) {
        void var1_1;
        return left.compareTo(var1_1);
    }

    private static class RangeLexOrdering
    extends Ordering<Range<?>>
    implements Serializable {
        static final Ordering<Range<?>> INSTANCE = new RangeLexOrdering();
        private static final long serialVersionUID = 0L;

        private RangeLexOrdering() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(Range<?> left, Range<?> right) {
            void var2_2;
            void var1_1;
            return ComparisonChain.start().compare(left.lowerBound, right.lowerBound).compare(var1_1.upperBound, var2_2.upperBound).result();
        }
    }

    static class UpperBoundFn
    implements Function<Range, Cut> {
        static final UpperBoundFn INSTANCE = new UpperBoundFn();

        UpperBoundFn() {
        }

        @Override
        public Cut apply(Range range) {
            return range.upperBound;
        }
    }

    static class LowerBoundFn
    implements Function<Range, Cut> {
        static final LowerBoundFn INSTANCE = new LowerBoundFn();

        LowerBoundFn() {
        }

        @Override
        public Cut apply(Range range) {
            return range.lowerBound;
        }
    }
}

