/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AllEqualOrdering;
import com.google.common.collect.ByFunctionOrdering;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ComparatorOrdering;
import com.google.common.collect.CompoundOrdering;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ExplicitOrdering;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.NullsFirstOrdering;
import com.google.common.collect.NullsLastOrdering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.common.collect.ReverseOrdering;
import com.google.common.collect.TopKSelector;
import com.google.common.collect.UsingToStringOrdering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Comparator<T> comparator) {
        Comparator<T> comparator2;
        if (comparator instanceof Ordering) {
            return (Ordering)comparator;
        }
        return new ComparatorOrdering<T>(comparator2);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(List<T> valuesInOrder) {
        List<T> list;
        return new ExplicitOrdering<T>(list);
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        void var1_1;
        return Ordering.explicit(Lists.asList(leastValue, var1_1));
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        void var1_1;
        return new ByFunctionOrdering(var1_1, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        void var1_1;
        return new CompoundOrdering(this, (Comparator)Preconditions.checkNotNull(var1_1));
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        Iterable<? extends Comparator<? super T>> iterable;
        return new CompoundOrdering(iterable);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @Override
    public abstract int compare(@ParametricNullness T var1, @ParametricNullness T var2);

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E min(Iterator<E> iterator) {
        void var2_2;
        E minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E min(Iterable<E> iterable) {
        void var1_1;
        return (E)this.min(var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b) {
        void var2_2;
        if (this.compare(a, b) <= 0) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        void var1_1;
        void var3_3;
        E[] EArray;
        Ordering ordering = this;
        void minSoFar = ordering.min(ordering.min(a, EArray), var3_3);
        EArray = rest;
        int n = rest.length;
        for (int i = 0; i < n; ++i) {
            E r = EArray[i];
            minSoFar = this.min(minSoFar, r);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E max(Iterator<E> iterator) {
        void var2_2;
        E maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E max(Iterable<E> iterable) {
        void var1_1;
        return (E)this.max(var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b) {
        void var2_2;
        if (this.compare(a, b) >= 0) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        void var1_1;
        void var3_3;
        E[] EArray;
        Ordering ordering = this;
        void maxSoFar = ordering.max(ordering.max(a, EArray), var3_3);
        EArray = rest;
        int n = rest.length;
        for (int i = 0; i < n; ++i) {
            E r = EArray[i];
            maxSoFar = this.max(maxSoFar, r);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public <E extends T> List<E> leastOf(Iterable<E> iterable, int k) {
        void var2_2;
        void var1_1;
        Collection collection;
        if (iterable instanceof Collection && (long)(collection = (Collection)iterable).size() <= 2L * (long)k) {
            void var3_3;
            Object[] array = var3_3.toArray();
            Arrays.sort(array, this);
            if (array.length > k) {
                array = Arrays.copyOf(array, k);
            }
            return Collections.unmodifiableList(Arrays.asList(var1_1));
        }
        return this.leastOf(var1_1.iterator(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <E extends T> List<E> leastOf(Iterator<E> iterator, int k) {
        void var3_4;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(iterator);
        CollectPreconditions.checkNonnegative(k, "k");
        if (k == 0 || !iterator.hasNext()) {
            return Collections.emptyList();
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<E> list = Lists.newArrayList(iterator);
            Collections.sort(list, this);
            if (list.size() > k) {
                list.subList(k, list.size()).clear();
            }
            list.trimToSize();
            return Collections.unmodifiableList(list);
        }
        TopKSelector selector = TopKSelector.least((int)var2_2, this);
        selector.offerAll(var1_1);
        return var3_4.topK();
    }

    /*
     * WARNING - void declaration
     */
    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int k) {
        void var2_2;
        void var1_1;
        return this.reverse().leastOf((Iterable<E>)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <E extends T> List<E> greatestOf(Iterator<E> iterator, int k) {
        void var2_2;
        void var1_1;
        return this.reverse().leastOf((Iterator<E>)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        void var1_1;
        Object[] array = Iterables.toArray(elements);
        Arrays.sort(array, this);
        return Lists.newArrayList(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        void var1_1;
        return ImmutableList.sortedCopyOf(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                void var3_3;
                T next = it.next();
                if (this.compare(prev, next) > 0) {
                    return false;
                }
                prev = var3_3;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                void var3_3;
                T next = it.next();
                if (this.compare(prev, next) >= 0) {
                    return false;
                }
                prev = var3_3;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public int binarySearch(List<? extends T> sortedList, @ParametricNullness T key) {
        void var2_2;
        return Collections.binarySearch(sortedList, var2_2, this);
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        IncomparableValueException(Object value) {
            void var1_1;
            String string = String.valueOf(value);
            super(new StringBuilder(22 + String.valueOf(string).length()).append("Cannot compare value: ").append(string).toString());
            this.value = var1_1;
        }
    }

    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final ConcurrentMap<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeMap();

        ArbitraryOrdering() {
        }

        /*
         * WARNING - void declaration
         */
        private Integer getUid(Object obj) {
            void var2_2;
            Integer alreadySet;
            Integer uid = (Integer)this.uids.get(obj);
            if (uid == null && (alreadySet = this.uids.putIfAbsent(obj, uid = Integer.valueOf(this.counter.getAndIncrement()))) != null) {
                void var1_1;
                uid = var1_1;
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(Object left, Object right) {
            void var1_2;
            void var2_3;
            int rightCode;
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int leftCode = this.identityHashCode(left);
            if (leftCode != (rightCode = this.identityHashCode(right))) {
                void var3_4;
                if (var3_4 < rightCode) {
                    return -1;
                }
                return 1;
            }
            int result = this.getUid(left).compareTo(this.getUid(var2_3));
            if (result == 0) {
                throw new AssertionError();
            }
            return (int)var1_2;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }
}

