/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <T> T[] newArray(Class<T> type, int length) {
        void var1_1;
        return (Object[])Array.newInstance(type, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] newArray(T[] reference, int length) {
        void var1_1;
        return Platform.newArray(reference, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        void var2_2;
        void var1_1;
        T[] TArray;
        T[] result = ObjectArrays.newArray(type, first.length + second.length);
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, TArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] concat(@ParametricNullness T element, T[] array) {
        void var2_2;
        void var1_1;
        T t;
        T[] TArray = ObjectArrays.newArray(array, array.length + 1);
        T[] result = TArray;
        TArray[0] = t;
        System.arraycopy(array, 0, result, 1, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] concat(T[] array, @ParametricNullness T element) {
        void var2_2;
        void var1_1;
        T[] TArray = Arrays.copyOf(array, array.length + 1);
        T[] result = TArray;
        TArray[var0.length] = var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static <T> T[] toArrayImpl(Collection<?> c, T[] array) {
        void var1_1;
        T[] TArray;
        int size = c.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, size);
        }
        ObjectArrays.fillArray(TArray, array);
        if (array.length > size) {
            TArray = array;
            array[var2_2] = null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static <T> T[] toArrayImpl(Object[] src, int offset, int len, T[] dst) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object[] objectArray;
        int n = offset;
        Preconditions.checkPositionIndexes(n, n + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            T[] TArray = dst;
            dst[len] = null;
        }
        System.arraycopy(objectArray, (int)var1_1, dst, 0, (int)var2_2);
        return var3_3;
    }

    static Object[] toArrayImpl(Collection<?> c) {
        Collection<?> collection = c;
        return ObjectArrays.fillArray(collection, new Object[collection.size()]);
    }

    /*
     * WARNING - void declaration
     */
    static Object[] copyAsObjectArray(Object[] elements, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object[] objectArray;
        int n = offset;
        Preconditions.checkPositionIndexes(n, n + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        Object[] result = new Object[length];
        System.arraycopy(objectArray, (int)var1_1, result, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        void var1_1;
        Iterator<?> iterator;
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object element = iterator.next();
            array[i++] = var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static void swap(Object[] array, int i, int j) {
        void var3_3;
        Object temp = array[i];
        array[var1_1] = array[j];
        var0[var2_2] = var3_3;
    }

    static Object[] checkElementsNotNull(Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    static Object[] checkElementsNotNull(Object[] array, int length) {
        Object[] objectArray;
        for (int i = 0; i < length; ++i) {
            ObjectArrays.checkElementNotNull(array[i], i);
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    static Object checkElementNotNull(Object element, int index) {
        Object object;
        if (element == null) {
            void var1_1;
            throw new NullPointerException(new StringBuilder(20).append("at index ").append((int)var1_1).toString());
        }
        return object;
    }
}

