/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.TransformedIterator;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class MutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements ClassToInstanceMap<B>,
Serializable {
    private final Map<Class<? extends B>, B> delegate;

    public static <B> MutableClassToInstanceMap<B> create() {
        return new MutableClassToInstanceMap(new HashMap());
    }

    public static <B> MutableClassToInstanceMap<B> create(Map<Class<? extends B>, B> backingMap) {
        Map<Class<? extends B>, B> map;
        return new MutableClassToInstanceMap<B>(map);
    }

    /*
     * WARNING - void declaration
     */
    private MutableClassToInstanceMap(Map<Class<? extends B>, B> delegate) {
        void var1_1;
        this.delegate = (Map)Preconditions.checkNotNull(var1_1);
    }

    @Override
    protected final Map<Class<? extends B>, B> delegate() {
        return this.delegate;
    }

    private static <B> Map.Entry<Class<? extends B>, B> checkedEntry(Map.Entry<Class<? extends B>, B> entry) {
        Map.Entry<Class<? extends B>, B> entry2;
        return new ForwardingMapEntry<Class<? extends B>, B>(){

            @Override
            protected Map.Entry<Class<? extends B>, B> delegate() {
                return entry2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public B setValue(B value) {
                void var1_1;
                1 v0 = this;
                return super.setValue(MutableClassToInstanceMap.access$000((Class)v0.getKey(), var1_1));
            }
        };
    }

    @Override
    public final Set<Map.Entry<Class<? extends B>, B>> entrySet() {
        return new ForwardingSet<Map.Entry<Class<? extends B>, B>>(this){
            final /* synthetic */ MutableClassToInstanceMap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            protected Set<Map.Entry<Class<? extends B>, B>> delegate() {
                return this.this$0.delegate().entrySet();
            }

            @Override
            public Spliterator<Map.Entry<Class<? extends B>, B>> spliterator() {
                return CollectSpliterators.map(this.delegate().spliterator(), x$0 -> MutableClassToInstanceMap.checkedEntry(x$0));
            }

            @Override
            public Iterator<Map.Entry<Class<? extends B>, B>> iterator() {
                2 v0 = this;
                return new TransformedIterator<Map.Entry<Class<? extends B>, B>, Map.Entry<Class<? extends B>, B>>(v0, v0.delegate().iterator()){
                    {
                        void var2_2;
                    }

                    @Override
                    Map.Entry<Class<? extends B>, B> transform(Map.Entry<Class<? extends B>, B> from) {
                        return MutableClassToInstanceMap.checkedEntry(from);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = this.standardToArray();
                return objectArray;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <T> T[] toArray(T[] array) {
                void var1_1;
                return this.standardToArray((T[])var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final B put(Class<? extends B> key, B value) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        return (B)super.put(v0, MutableClassToInstanceMap.cast(v0, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void putAll(Map<? extends Class<? extends B>, ? extends B> map) {
        void var1_1;
        LinkedHashMap<Class<B>, B> copy = new LinkedHashMap<Class<B>, B>(map);
        for (Map.Entry entry : copy.entrySet()) {
            void var3_3;
            MutableClassToInstanceMap.cast((Class)entry.getKey(), var3_3.getValue());
        }
        super.putAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends B> T putInstance(Class<T> type, T value) {
        void var2_2;
        void var1_1;
        return MutableClassToInstanceMap.cast(type, this.put((Class<? extends B>)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends B> T getInstance(Class<T> type) {
        void var1_1;
        return MutableClassToInstanceMap.cast(type, this.get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static <B, T extends B> T cast(Class<T> type, B value) {
        void var1_1;
        return Primitives.wrap(type).cast(var1_1);
    }

    private Object writeReplace() {
        return new SerializedForm(this.delegate());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$000(Class x0, Object x1) {
        void var1_1;
        return MutableClassToInstanceMap.cast(x0, var1_1);
    }

    private static final class SerializedForm<B>
    implements Serializable {
        private final Map<Class<? extends B>, B> backingMap;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(Map<Class<? extends B>, B> backingMap) {
            void var1_1;
            this.backingMap = var1_1;
        }

        final Object readResolve() {
            return MutableClassToInstanceMap.create(this.backingMap);
        }
    }
}

