/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TransformedIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableSortedMultiset;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Multisets {
    private Multisets() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T, E, M extends Multiset<E>> Collector<T, ?, M> toMultiset(Function<? super T, E> elementFunction, ToIntFunction<? super T> countFunction, Supplier<M> multisetSupplier) {
        void var2_2;
        void var1_1;
        return CollectCollectors.toMultiset(elementFunction, var1_1, var2_2);
    }

    public static <E> Multiset<E> unmodifiableMultiset(Multiset<? extends E> multiset) {
        Multiset<? extends E> multiset2;
        if (multiset instanceof UnmodifiableMultiset || multiset instanceof ImmutableMultiset) {
            return multiset;
        }
        return new UnmodifiableMultiset<E>(Preconditions.checkNotNull(multiset2));
    }

    @Deprecated
    public static <E> Multiset<E> unmodifiableMultiset(ImmutableMultiset<E> multiset) {
        return Preconditions.checkNotNull(multiset);
    }

    @Beta
    public static <E> SortedMultiset<E> unmodifiableSortedMultiset(SortedMultiset<E> sortedMultiset) {
        SortedMultiset<E> sortedMultiset2;
        return new UnmodifiableSortedMultiset<E>(Preconditions.checkNotNull(sortedMultiset2));
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Multiset.Entry<E> immutableEntry(@ParametricNullness E e, int n) {
        void var1_1;
        E e2;
        return new ImmutableEntry<E>(e2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <E> Multiset<E> filter(Multiset<E> unfiltered, Predicate<? super E> predicate) {
        void var1_1;
        FilteredMultiset filteredMultiset;
        if (unfiltered instanceof FilteredMultiset) {
            FilteredMultiset filtered = (FilteredMultiset)unfiltered;
            Predicate<? super E> combinedPredicate = Predicates.and(filtered.predicate, predicate);
            return new FilteredMultiset(filteredMultiset.unfiltered, var1_1);
        }
        return new FilteredMultiset(filteredMultiset, var1_1);
    }

    static int inferDistinctElements(Iterable<?> elements) {
        if (elements instanceof Multiset) {
            Iterable<?> iterable;
            return ((Multiset)iterable).elementSet().size();
        }
        return 11;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <E> Multiset<E> union(Multiset<? extends E> multiset1, Multiset<? extends E> multiset2) {
        void var1_1;
        Multiset<? extends E> multiset;
        Preconditions.checkNotNull(multiset1);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>((Multiset)var1_1){
            final /* synthetic */ Multiset val$multiset2;
            {
                this.val$multiset2 = multiset2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object element) {
                void var1_1;
                return multiset.contains(element) || this.val$multiset2.contains(var1_1);
            }

            @Override
            public boolean isEmpty() {
                return multiset.isEmpty() && this.val$multiset2.isEmpty();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int count(Object element) {
                void var1_1;
                return Math.max(multiset.count(element), this.val$multiset2.count(var1_1));
            }

            @Override
            Set<E> createElementSet() {
                return Sets.union(multiset.elementSet(), this.val$multiset2.elementSet());
            }

            @Override
            Iterator<E> elementIterator() {
                throw new AssertionError((Object)"should never be called");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                void var2_2;
                void var1_1;
                Iterator iterator1 = multiset.entrySet().iterator();
                Iterator iterator2 = this.val$multiset2.entrySet().iterator();
                return new AbstractIterator<Multiset.Entry<E>>(this, (Iterator)var1_1, (Iterator)var2_2){
                    final /* synthetic */ Iterator val$iterator1;
                    final /* synthetic */ Iterator val$iterator2;
                    final /* synthetic */ 1 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$iterator1 = iterator;
                        this.val$iterator2 = iterator2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        if (this.val$iterator1.hasNext()) {
                            Multiset.Entry entry1 = (Multiset.Entry)this.val$iterator1.next();
                            Object element = entry1.getElement();
                            int count = Math.max(entry1.getCount(), this.this$0.val$multiset2.count(element));
                            return Multisets.immutableEntry(element, count);
                        }
                        while (this.val$iterator2.hasNext()) {
                            void var1_3;
                            void var2_5;
                            Multiset.Entry entry2 = (Multiset.Entry)this.val$iterator2.next();
                            Object element = entry2.getElement();
                            if (this.this$0.multiset.contains(element)) continue;
                            return Multisets.immutableEntry(var2_5, var1_3.getCount());
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Multiset<E> intersection(Multiset<E> multiset1, Multiset<?> multiset2) {
        void var1_1;
        Multiset<E> multiset;
        Preconditions.checkNotNull(multiset1);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>((Multiset)var1_1){
            final /* synthetic */ Multiset val$multiset2;
            {
                this.val$multiset2 = multiset2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int count(Object element) {
                void var1_1;
                void var2_2;
                int count1 = multiset.count(element);
                if (count1 == 0) {
                    return 0;
                }
                return Math.min((int)var2_2, this.val$multiset2.count(var1_1));
            }

            @Override
            Set<E> createElementSet() {
                return Sets.intersection(multiset.elementSet(), this.val$multiset2.elementSet());
            }

            @Override
            Iterator<E> elementIterator() {
                throw new AssertionError((Object)"should never be called");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                void var1_1;
                Iterator iterator1 = multiset.entrySet().iterator();
                return new AbstractIterator<Multiset.Entry<E>>(this, (Iterator)var1_1){
                    final /* synthetic */ Iterator val$iterator1;
                    final /* synthetic */ 2 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$iterator1 = iterator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        while (this.val$iterator1.hasNext()) {
                            void var1_1;
                            void var2_3;
                            Multiset.Entry entry1 = (Multiset.Entry)this.val$iterator1.next();
                            Object element = entry1.getElement();
                            int count = Math.min(entry1.getCount(), this.this$0.val$multiset2.count(element));
                            if (count <= 0) continue;
                            return Multisets.immutableEntry(var2_3, (int)var1_1);
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <E> Multiset<E> sum(Multiset<? extends E> multiset1, Multiset<? extends E> multiset2) {
        void var1_1;
        Multiset<? extends E> multiset;
        Preconditions.checkNotNull(multiset1);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>((Multiset)var1_1){
            final /* synthetic */ Multiset val$multiset2;
            {
                this.val$multiset2 = multiset2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object element) {
                void var1_1;
                return multiset.contains(element) || this.val$multiset2.contains(var1_1);
            }

            @Override
            public boolean isEmpty() {
                return multiset.isEmpty() && this.val$multiset2.isEmpty();
            }

            @Override
            public int size() {
                return IntMath.saturatedAdd(multiset.size(), this.val$multiset2.size());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int count(Object element) {
                void var1_1;
                return multiset.count(element) + this.val$multiset2.count(var1_1);
            }

            @Override
            Set<E> createElementSet() {
                return Sets.union(multiset.elementSet(), this.val$multiset2.elementSet());
            }

            @Override
            Iterator<E> elementIterator() {
                throw new AssertionError((Object)"should never be called");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                void var2_2;
                void var1_1;
                Iterator iterator1 = multiset.entrySet().iterator();
                Iterator iterator2 = this.val$multiset2.entrySet().iterator();
                return new AbstractIterator<Multiset.Entry<E>>(this, (Iterator)var1_1, (Iterator)var2_2){
                    final /* synthetic */ Iterator val$iterator1;
                    final /* synthetic */ Iterator val$iterator2;
                    final /* synthetic */ 3 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$iterator1 = iterator;
                        this.val$iterator2 = iterator2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        if (this.val$iterator1.hasNext()) {
                            Multiset.Entry entry1 = (Multiset.Entry)this.val$iterator1.next();
                            Object element = entry1.getElement();
                            int count = entry1.getCount() + this.this$0.val$multiset2.count(element);
                            return Multisets.immutableEntry(element, count);
                        }
                        while (this.val$iterator2.hasNext()) {
                            void var1_3;
                            void var2_5;
                            Multiset.Entry entry2 = (Multiset.Entry)this.val$iterator2.next();
                            Object element = entry2.getElement();
                            if (this.this$0.multiset.contains(element)) continue;
                            return Multisets.immutableEntry(var2_5, var1_3.getCount());
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <E> Multiset<E> difference(Multiset<E> multiset1, Multiset<?> multiset2) {
        void var1_1;
        Multiset<E> multiset;
        Preconditions.checkNotNull(multiset1);
        Preconditions.checkNotNull(multiset2);
        return new ViewMultiset<E>((Multiset)var1_1){
            final /* synthetic */ Multiset val$multiset2;
            {
                this.val$multiset2 = multiset2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int count(Object element) {
                void var1_1;
                void var2_2;
                int count1 = multiset.count(element);
                if (count1 == 0) {
                    return 0;
                }
                return Math.max(0, (int)(var2_2 - this.val$multiset2.count(var1_1)));
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Iterator<E> elementIterator() {
                void var1_1;
                Iterator iterator1 = multiset.entrySet().iterator();
                return new AbstractIterator<E>(this, (Iterator)var1_1){
                    final /* synthetic */ Iterator val$iterator1;
                    final /* synthetic */ 4 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$iterator1 = iterator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected E computeNext() {
                        while (this.val$iterator1.hasNext()) {
                            void var2_2;
                            void var1_1;
                            Multiset.Entry entry1 = (Multiset.Entry)this.val$iterator1.next();
                            Object element = entry1.getElement();
                            if (var1_1.getCount() <= this.this$0.val$multiset2.count(element)) continue;
                            return var2_2;
                        }
                        return this.endOfData();
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                void var1_1;
                Iterator iterator1 = multiset.entrySet().iterator();
                return new AbstractIterator<Multiset.Entry<E>>(this, (Iterator)var1_1){
                    final /* synthetic */ Iterator val$iterator1;
                    final /* synthetic */ 4 this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$iterator1 = iterator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    protected Multiset.Entry<E> computeNext() {
                        while (this.val$iterator1.hasNext()) {
                            void var1_1;
                            void var2_3;
                            Multiset.Entry entry1 = (Multiset.Entry)this.val$iterator1.next();
                            Object element = entry1.getElement();
                            int count = entry1.getCount() - this.this$0.val$multiset2.count(element);
                            if (count <= 0) continue;
                            return Multisets.immutableEntry(var2_3, (int)var1_1);
                        }
                        return (Multiset.Entry)this.endOfData();
                    }
                };
            }

            @Override
            int distinctElements() {
                return Iterators.size(this.entryIterator());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsOccurrences(Multiset<?> superMultiset, Multiset<?> subMultiset) {
        Iterator iterator;
        Preconditions.checkNotNull(superMultiset);
        Preconditions.checkNotNull(subMultiset);
        for (Multiset.Entry entry : iterator.entrySet()) {
            void var2_2;
            int n = superMultiset.count(entry.getElement());
            if (n >= var2_2.getCount()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean retainOccurrences(Multiset<?> multisetToModify, Multiset<?> multisetToRetain) {
        void var1_1;
        return Multisets.retainOccurrencesImpl(multisetToModify, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> boolean retainOccurrencesImpl(Multiset<E> multisetToModify, Multiset<?> occurrencesToRetain) {
        void var3_3;
        Preconditions.checkNotNull(multisetToModify);
        Preconditions.checkNotNull(occurrencesToRetain);
        Iterator<Multiset.Entry<E>> entryIterator = multisetToModify.entrySet().iterator();
        boolean changed = false;
        while (entryIterator.hasNext()) {
            Multiset.Entry<E> entry = entryIterator.next();
            int retainCount = occurrencesToRetain.count(entry.getElement());
            if (retainCount == 0) {
                entryIterator.remove();
                changed = true;
                continue;
            }
            if (retainCount >= entry.getCount()) continue;
            multisetToModify.setCount(entry.getElement(), retainCount);
            changed = true;
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean removeOccurrences(Multiset<?> multisetToModify, Iterable<?> occurrencesToRemove) {
        void var2_2;
        Iterator iterator;
        if (occurrencesToRemove instanceof Multiset) {
            return Multisets.removeOccurrences(multisetToModify, (Multiset)occurrencesToRemove);
        }
        Preconditions.checkNotNull(multisetToModify);
        Preconditions.checkNotNull(occurrencesToRemove);
        boolean changed = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object o = iterator.next();
            changed |= multisetToModify.remove(var3_3);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean removeOccurrences(Multiset<?> multisetToModify, Multiset<?> occurrencesToRemove) {
        void var2_2;
        Preconditions.checkNotNull(multisetToModify);
        Preconditions.checkNotNull(occurrencesToRemove);
        boolean changed = false;
        Iterator<Multiset.Entry<?>> entryIterator = multisetToModify.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Multiset.Entry<?> entry = entryIterator.next();
            int removeCount = occurrencesToRemove.count(entry.getElement());
            if (removeCount >= entry.getCount()) {
                entryIterator.remove();
                changed = true;
                continue;
            }
            if (removeCount <= 0) continue;
            multisetToModify.remove(entry.getElement(), removeCount);
            changed = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Multiset<?> multiset, Object object) {
        if (object == multiset) {
            return true;
        }
        if (object instanceof Multiset) {
            Iterator iterator;
            Multiset that = (Multiset)object;
            if (multiset.size() != that.size() || multiset.entrySet().size() != that.entrySet().size()) {
                return false;
            }
            for (Multiset.Entry entry : iterator.entrySet()) {
                void var2_2;
                if (multiset.count(entry.getElement()) == var2_2.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static <E> boolean addAllImpl(Multiset<E> self, Collection<? extends E> elements) {
        void var1_1;
        Multiset<E> multiset;
        Preconditions.checkNotNull(self);
        Preconditions.checkNotNull(elements);
        if (elements instanceof Multiset) {
            return Multisets.addAllImpl(self, Multisets.cast(elements));
        }
        if (elements.isEmpty()) {
            return false;
        }
        return Iterators.addAll(multiset, var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    private static <E> boolean addAllImpl(Multiset<E> self, Multiset<? extends E> elements) {
        Multiset<E> multiset;
        void var1_1;
        if (elements.isEmpty()) {
            return false;
        }
        var1_1.forEachEntry(multiset::add);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static boolean removeAllImpl(Multiset<?> self, Collection<?> elementsToRemove) {
        void var1_1;
        Multiset<?> multiset;
        void collection;
        collection = elementsToRemove instanceof Multiset ? ((Multiset)elementsToRemove).elementSet() : collection;
        return multiset.elementSet().removeAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean retainAllImpl(Multiset<?> self, Collection<?> elementsToRetain) {
        void var1_1;
        Multiset<?> multiset;
        void collection;
        Preconditions.checkNotNull(elementsToRetain);
        collection = elementsToRetain instanceof Multiset ? ((Multiset)elementsToRetain).elementSet() : collection;
        return multiset.elementSet().retainAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <E> int setCountImpl(Multiset<E> self, @ParametricNullness E element, int count) {
        void var3_3;
        CollectPreconditions.checkNonnegative(count, "count");
        int oldCount = self.count(element);
        int delta = count - oldCount;
        if (delta > 0) {
            self.add(element, delta);
        } else if (delta < 0) {
            void var2_2;
            void var1_1;
            Multiset<E> multiset;
            multiset.remove(var1_1, (int)(-var2_2));
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static <E> boolean setCountImpl(Multiset<E> self, @ParametricNullness E element, int oldCount, int newCount) {
        void var2_2;
        CollectPreconditions.checkNonnegative(oldCount, "oldCount");
        CollectPreconditions.checkNonnegative(newCount, "newCount");
        if (self.count(element) == var2_2) {
            void var3_3;
            void var1_1;
            Multiset<void> multiset;
            multiset.setCount(var1_1, (int)var3_3);
            return true;
        }
        return false;
    }

    static <E> Iterator<E> elementIterator(Iterator<Multiset.Entry<E>> entryIterator) {
        Iterator<Multiset.Entry<E>> iterator;
        return new TransformedIterator<Multiset.Entry<E>, E>(iterator){
            {
                void var1_1;
            }

            @Override
            @ParametricNullness
            E transform(Multiset.Entry<E> entry) {
                return entry.getElement();
            }
        };
    }

    static <E> Iterator<E> iteratorImpl(Multiset<E> multiset) {
        Multiset<E> multiset2;
        Multiset<E> multiset3 = multiset2;
        return new MultisetIteratorImpl<E>(multiset3, multiset3.entrySet().iterator());
    }

    /*
     * WARNING - void declaration
     */
    static <E> Spliterator<E> spliteratorImpl(Multiset<E> multiset) {
        Multiset<E> multiset2;
        void var1_1;
        Spliterator<Multiset.Entry<E>> entrySpliterator = multiset.entrySet().spliterator();
        return CollectSpliterators.flatMap(entrySpliterator, entry -> {
            Multiset.Entry entry2;
            return Collections.nCopies(entry.getCount(), entry2.getElement()).spliterator();
        }, 0x40 | var1_1.characteristics() & 0x510, multiset2.size());
    }

    /*
     * WARNING - void declaration
     */
    static int linearTimeSizeImpl(Multiset<?> multiset) {
        void var1_1;
        Object object;
        long size = 0L;
        for (Multiset.Entry entry : object.entrySet()) {
            size += (long)entry.getCount();
        }
        return Ints.saturatedCast((long)var1_1);
    }

    static <T> Multiset<T> cast(Iterable<T> iterable) {
        return (Multiset)iterable;
    }

    @Beta
    public static <E> ImmutableMultiset<E> copyHighestCountFirst(Multiset<E> multiset) {
        Multiset.Entry[] entryArray;
        Multiset.Entry[] entries = multiset.entrySet().toArray(new Multiset.Entry[0]);
        Arrays.sort(entries, DecreasingCount.INSTANCE);
        return ImmutableMultiset.copyFromEntries(Arrays.asList(entryArray));
    }

    private static abstract class ViewMultiset<E>
    extends AbstractMultiset<E> {
        private ViewMultiset() {
        }

        @Override
        public int size() {
            return Multisets.linearTimeSizeImpl(this);
        }

        @Override
        public void clear() {
            this.elementSet().clear();
        }

        @Override
        public Iterator<E> iterator() {
            return Multisets.iteratorImpl(this);
        }

        @Override
        int distinctElements() {
            return this.elementSet().size();
        }
    }

    private static final class DecreasingCount
    implements Comparator<Multiset.Entry<?>> {
        static final DecreasingCount INSTANCE = new DecreasingCount();

        private DecreasingCount() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(Multiset.Entry<?> entry1, Multiset.Entry<?> entry2) {
            void var1_1;
            return entry2.getCount() - var1_1.getCount();
        }
    }

    static final class MultisetIteratorImpl<E>
    implements Iterator<E> {
        private final Multiset<E> multiset;
        private final Iterator<Multiset.Entry<E>> entryIterator;
        private Multiset.Entry<E> currentEntry;
        private int laterCount;
        private int totalCount;
        private boolean canRemove;

        /*
         * WARNING - void declaration
         */
        MultisetIteratorImpl(Multiset<E> multiset, Iterator<Multiset.Entry<E>> entryIterator) {
            void var2_2;
            void var1_1;
            this.multiset = var1_1;
            this.entryIterator = var2_2;
        }

        @Override
        public final boolean hasNext() {
            return this.laterCount > 0 || this.entryIterator.hasNext();
        }

        @Override
        @ParametricNullness
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.laterCount == 0) {
                this.currentEntry = this.entryIterator.next();
                MultisetIteratorImpl multisetIteratorImpl = this;
                multisetIteratorImpl.totalCount = multisetIteratorImpl.laterCount = this.currentEntry.getCount();
            }
            --this.laterCount;
            this.canRemove = true;
            return Objects.requireNonNull(this.currentEntry).getElement();
        }

        @Override
        public final void remove() {
            CollectPreconditions.checkRemove(this.canRemove);
            if (this.totalCount == 1) {
                this.entryIterator.remove();
            } else {
                this.multiset.remove(Objects.requireNonNull(this.currentEntry).getElement());
            }
            --this.totalCount;
            this.canRemove = false;
        }
    }

    static abstract class EntrySet<E>
    extends Sets.ImprovedAbstractSet<Multiset.Entry<E>> {
        EntrySet() {
        }

        abstract Multiset<E> multiset();

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            if (o instanceof Multiset.Entry) {
                void var1_1;
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int n = this.multiset().count(entry.getElement());
                return n == var1_1.getCount();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object element = entry.getElement();
                int entryCount = entry.getCount();
                if (entryCount != 0) {
                    void var1_2;
                    void var2_3;
                    Multiset<void> multiset = this.multiset();
                    return multiset.setCount(var2_3, (int)var1_2, 0);
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.multiset().clear();
        }
    }

    static abstract class ElementSet<E>
    extends Sets.ImprovedAbstractSet<E> {
        ElementSet() {
        }

        abstract Multiset<E> multiset();

        @Override
        public void clear() {
            this.multiset().clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.multiset().contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            return this.multiset().containsAll((Collection<?>)var1_1);
        }

        @Override
        public boolean isEmpty() {
            return this.multiset().isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_1;
            return this.multiset().remove(var1_1, Integer.MAX_VALUE) > 0;
        }

        @Override
        public int size() {
            return this.multiset().entrySet().size();
        }
    }

    static abstract class AbstractEntry<E>
    implements Multiset.Entry<E> {
        AbstractEntry() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            if (object instanceof Multiset.Entry) {
                void var1_1;
                Multiset.Entry that = (Multiset.Entry)object;
                return this.getCount() == that.getCount() && com.google.common.base.Objects.equal(this.getElement(), var1_1.getElement());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            Object e = this.getElement();
            return (e == null ? 0 : var1_1.hashCode()) ^ this.getCount();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var2_2;
            void var1_1;
            String text = String.valueOf(this.getElement());
            int n = this.getCount();
            if (n == 1) {
                return text;
            }
            return new StringBuilder(14 + String.valueOf(text).length()).append((String)var1_1).append(" x ").append((int)var2_2).toString();
        }
    }

    private static final class FilteredMultiset<E>
    extends ViewMultiset<E> {
        final Multiset<E> unfiltered;
        final Predicate<? super E> predicate;

        /*
         * WARNING - void declaration
         */
        FilteredMultiset(Multiset<E> unfiltered, Predicate<? super E> predicate) {
            void var2_2;
            void var1_1;
            this.unfiltered = (Multiset)Preconditions.checkNotNull(var1_1);
            this.predicate = (Predicate)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public final UnmodifiableIterator<E> iterator() {
            return Iterators.filter(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        final Set<E> createElementSet() {
            return Sets.filter(this.unfiltered.elementSet(), this.predicate);
        }

        @Override
        final Iterator<E> elementIterator() {
            throw new AssertionError((Object)"should never be called");
        }

        @Override
        final Set<Multiset.Entry<E>> createEntrySet() {
            return Sets.filter(this.unfiltered.entrySet(), new Predicate<Multiset.Entry<E>>(this){
                final /* synthetic */ FilteredMultiset this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean apply(Multiset.Entry<E> entry) {
                    void var1_1;
                    return this.this$0.predicate.apply(var1_1.getElement());
                }
            });
        }

        @Override
        final Iterator<Multiset.Entry<E>> entryIterator() {
            throw new AssertionError((Object)"should never be called");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int count(Object element) {
            int count = this.unfiltered.count(element);
            if (count > 0) {
                void var1_1;
                if (this.predicate.apply(var1_1)) {
                    void var2_2;
                    return (int)var2_2;
                }
                return 0;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int add(@ParametricNullness E element, int occurrences) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(this.predicate.apply(element), "Element %s does not match predicate %s", element, this.predicate);
            return this.unfiltered.add(var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int remove(Object element, int occurrences) {
            CollectPreconditions.checkNonnegative(occurrences, "occurrences");
            if (occurrences == 0) {
                return this.count(element);
            }
            if (this.contains(element)) {
                void var2_2;
                void var1_1;
                return this.unfiltered.remove(var1_1, (int)var2_2);
            }
            return 0;
        }
    }

    static class ImmutableEntry<E>
    extends AbstractEntry<E>
    implements Serializable {
        @ParametricNullness
        private final E element;
        private final int count;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ImmutableEntry(@ParametricNullness E element, int count) {
            void var2_2;
            void var1_1;
            this.element = var1_1;
            this.count = count;
            CollectPreconditions.checkNonnegative((int)var2_2, "count");
        }

        @Override
        @ParametricNullness
        public final E getElement() {
            return this.element;
        }

        @Override
        public final int getCount() {
            return this.count;
        }

        public ImmutableEntry<E> nextInBucket() {
            return null;
        }
    }

    static class UnmodifiableMultiset<E>
    extends ForwardingMultiset<E>
    implements Serializable {
        final Multiset<? extends E> delegate;
        transient Set<E> elementSet;
        transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableMultiset(Multiset<? extends E> delegate) {
            void var1_1;
            this.delegate = var1_1;
        }

        @Override
        protected Multiset<E> delegate() {
            return this.delegate;
        }

        Set<E> createElementSet() {
            return Collections.unmodifiableSet(this.delegate.elementSet());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<E> elementSet() {
            void var1_1;
            Set<E> es = this.elementSet;
            if (es == null) {
                this.elementSet = this.createElementSet();
                return this.elementSet;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            void var1_1;
            Set<Multiset.Entry<E>> es = this.entrySet;
            if (es == null) {
                this.entrySet = Collections.unmodifiableSet(this.delegate.entrySet());
                return this.entrySet;
            }
            return var1_1;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(this.delegate.iterator());
        }

        @Override
        public boolean add(@ParametricNullness E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int add(@ParametricNullness E element, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> elementsToAdd) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object element, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> elementsToRemove) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> elementsToRetain) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setCount(@ParametricNullness E element, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setCount(@ParametricNullness E element, int oldCount, int newCount) {
            throw new UnsupportedOperationException();
        }
    }
}

