/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractListMultimap;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.AbstractSortedSetMultimap;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.FilteredEntryMultimap;
import com.google.common.collect.FilteredEntrySetMultimap;
import com.google.common.collect.FilteredKeyListMultimap;
import com.google.common.collect.FilteredKeyMultimap;
import com.google.common.collect.FilteredKeySetMultimap;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.FilteredSetMultimap;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Synchronized;
import com.google.common.collect.TransformedIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Multimaps {
    private Multimaps() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V, M extends Multimap<K, V>> Collector<T, ?, M> toMultimap(java.util.function.Function<? super T, ? extends K> keyFunction, java.util.function.Function<? super T, ? extends V> valueFunction, Supplier<M> multimapSupplier) {
        void var2_2;
        void var1_1;
        return CollectCollectors.toMultimap(keyFunction, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <T, K, V, M extends Multimap<K, V>> Collector<T, ?, M> flatteningToMultimap(java.util.function.Function<? super T, ? extends K> keyFunction, java.util.function.Function<? super T, ? extends Stream<? extends V>> valueFunction, Supplier<M> multimapSupplier) {
        void var2_2;
        void var1_1;
        return CollectCollectors.flatteningToMultimap(keyFunction, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Multimap<K, V> newMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends Collection<V>> factory) {
        void var1_1;
        Map<K, Collection<V>> map2;
        return new CustomMultimap<K, V>(map2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ListMultimap<K, V> newListMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends List<V>> factory) {
        void var1_1;
        Map<K, Collection<V>> map2;
        return new CustomListMultimap<K, V>(map2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SetMultimap<K, V> newSetMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends Set<V>> factory) {
        void var1_1;
        Map<K, Collection<V>> map2;
        return new CustomSetMultimap<K, V>(map2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SortedSetMultimap<K, V> newSortedSetMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends SortedSet<V>> factory) {
        void var1_1;
        Map<K, Collection<V>> map2;
        return new CustomSortedSetMultimap<K, V>(map2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, M extends Multimap<K, V>> M invertFrom(Multimap<? extends V, ? extends K> source, M dest) {
        void var1_1;
        Object object;
        Preconditions.checkNotNull(dest);
        for (Map.Entry entry : object.entries()) {
            dest.put(entry.getValue(), entry.getKey());
        }
        return var1_1;
    }

    public static <K, V> Multimap<K, V> synchronizedMultimap(Multimap<K, V> multimap) {
        return Synchronized.multimap(multimap, null);
    }

    public static <K, V> Multimap<K, V> unmodifiableMultimap(Multimap<K, V> delegate) {
        Multimap<K, V> multimap;
        if (delegate instanceof UnmodifiableMultimap || delegate instanceof ImmutableMultimap) {
            return delegate;
        }
        return new UnmodifiableMultimap<K, V>(multimap);
    }

    @Deprecated
    public static <K, V> Multimap<K, V> unmodifiableMultimap(ImmutableMultimap<K, V> delegate) {
        return Preconditions.checkNotNull(delegate);
    }

    public static <K, V> SetMultimap<K, V> synchronizedSetMultimap(SetMultimap<K, V> multimap) {
        return Synchronized.setMultimap(multimap, null);
    }

    public static <K, V> SetMultimap<K, V> unmodifiableSetMultimap(SetMultimap<K, V> delegate) {
        SetMultimap<K, V> setMultimap;
        if (delegate instanceof UnmodifiableSetMultimap || delegate instanceof ImmutableSetMultimap) {
            return delegate;
        }
        return new UnmodifiableSetMultimap<K, V>(setMultimap);
    }

    @Deprecated
    public static <K, V> SetMultimap<K, V> unmodifiableSetMultimap(ImmutableSetMultimap<K, V> delegate) {
        return Preconditions.checkNotNull(delegate);
    }

    public static <K, V> SortedSetMultimap<K, V> synchronizedSortedSetMultimap(SortedSetMultimap<K, V> multimap) {
        return Synchronized.sortedSetMultimap(multimap, null);
    }

    public static <K, V> SortedSetMultimap<K, V> unmodifiableSortedSetMultimap(SortedSetMultimap<K, V> delegate) {
        SortedSetMultimap<K, V> sortedSetMultimap;
        if (delegate instanceof UnmodifiableSortedSetMultimap) {
            return delegate;
        }
        return new UnmodifiableSortedSetMultimap<K, V>(sortedSetMultimap);
    }

    public static <K, V> ListMultimap<K, V> synchronizedListMultimap(ListMultimap<K, V> multimap) {
        return Synchronized.listMultimap(multimap, null);
    }

    public static <K, V> ListMultimap<K, V> unmodifiableListMultimap(ListMultimap<K, V> delegate) {
        ListMultimap<K, V> listMultimap;
        if (delegate instanceof UnmodifiableListMultimap || delegate instanceof ImmutableListMultimap) {
            return delegate;
        }
        return new UnmodifiableListMultimap<K, V>(listMultimap);
    }

    @Deprecated
    public static <K, V> ListMultimap<K, V> unmodifiableListMultimap(ImmutableListMultimap<K, V> delegate) {
        return Preconditions.checkNotNull(delegate);
    }

    private static <V> Collection<V> unmodifiableValueCollection(Collection<V> collection) {
        Collection<V> collection2;
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableCollection(collection2);
    }

    private static <K, V> Collection<Map.Entry<K, V>> unmodifiableEntries(Collection<Map.Entry<K, V>> entries) {
        Collection<Map.Entry<K, V>> collection;
        if (entries instanceof Set) {
            return Maps.unmodifiableEntrySet((Set)entries);
        }
        return new Maps.UnmodifiableEntries<K, V>(Collections.unmodifiableCollection(collection));
    }

    @Beta
    public static <K, V> Map<K, List<V>> asMap(ListMultimap<K, V> multimap) {
        return multimap.asMap();
    }

    @Beta
    public static <K, V> Map<K, Set<V>> asMap(SetMultimap<K, V> multimap) {
        return multimap.asMap();
    }

    @Beta
    public static <K, V> Map<K, SortedSet<V>> asMap(SortedSetMultimap<K, V> multimap) {
        return multimap.asMap();
    }

    @Beta
    public static <K, V> Map<K, Collection<V>> asMap(Multimap<K, V> multimap) {
        return multimap.asMap();
    }

    public static <K, V> SetMultimap<K, V> forMap(Map<K, V> map) {
        Map<K, V> map2;
        return new MapMultimap<K, V>(map2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> Multimap<K, V2> transformValues(Multimap<K, V1> fromMultimap, Function<? super V1, V2> function) {
        void var1_1;
        Multimap<K, V1> multimap;
        Preconditions.checkNotNull(function);
        Maps.EntryTransformer transformer = Maps.asEntryTransformer(function);
        return Multimaps.transformEntries(multimap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> ListMultimap<K, V2> transformValues(ListMultimap<K, V1> fromMultimap, Function<? super V1, V2> function) {
        void var1_1;
        ListMultimap<K, V1> listMultimap;
        Preconditions.checkNotNull(function);
        Maps.EntryTransformer transformer = Maps.asEntryTransformer(function);
        return Multimaps.transformEntries(listMultimap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> Multimap<K, V2> transformEntries(Multimap<K, V1> fromMap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
        void var1_1;
        Multimap<K, V1> multimap;
        return new TransformedEntriesMultimap(multimap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> ListMultimap<K, V2> transformEntries(ListMultimap<K, V1> fromMap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
        void var1_1;
        ListMultimap<K, V1> listMultimap;
        return new TransformedEntriesListMultimap(listMultimap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> index(Iterable<V> values, Function<? super V, K> keyFunction) {
        void var1_1;
        return Multimaps.index(values.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> index(Iterator<V> values, Function<? super V, K> keyFunction) {
        void var2_2;
        Preconditions.checkNotNull(keyFunction);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        while (values.hasNext()) {
            void var3_3;
            V value = values.next();
            Preconditions.checkNotNull(value, values);
            builder.put((Object)keyFunction.apply(value), (Object)var3_3);
        }
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Multimap<K, V> filterKeys(Multimap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var1_1;
        FilteredMultimap filteredMultimap;
        if (unfiltered instanceof SetMultimap) {
            return Multimaps.filterKeys((SetMultimap)unfiltered, keyPredicate);
        }
        if (unfiltered instanceof ListMultimap) {
            return Multimaps.filterKeys((ListMultimap)unfiltered, keyPredicate);
        }
        if (unfiltered instanceof FilteredKeyMultimap) {
            FilteredMultimap prev = (FilteredKeyMultimap)unfiltered;
            return new FilteredKeyMultimap(prev.unfiltered, Predicates.and(filteredMultimap.keyPredicate, keyPredicate));
        }
        if (filteredMultimap instanceof FilteredMultimap) {
            filteredMultimap = filteredMultimap;
            return Multimaps.filterFiltered(filteredMultimap, Maps.keyPredicateOnEntries(keyPredicate));
        }
        return new FilteredKeyMultimap(filteredMultimap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SetMultimap<K, V> filterKeys(SetMultimap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var1_1;
        FilteredSetMultimap filteredSetMultimap;
        if (unfiltered instanceof FilteredKeySetMultimap) {
            FilteredSetMultimap prev = (FilteredKeySetMultimap)unfiltered;
            return new FilteredKeySetMultimap(prev.unfiltered(), Predicates.and(filteredSetMultimap.keyPredicate, keyPredicate));
        }
        if (filteredSetMultimap instanceof FilteredSetMultimap) {
            filteredSetMultimap = filteredSetMultimap;
            return Multimaps.filterFiltered(filteredSetMultimap, Maps.keyPredicateOnEntries(keyPredicate));
        }
        return new FilteredKeySetMultimap(filteredSetMultimap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ListMultimap<K, V> filterKeys(ListMultimap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var1_1;
        FilteredKeyListMultimap filteredKeyListMultimap;
        if (unfiltered instanceof FilteredKeyListMultimap) {
            FilteredKeyListMultimap prev = (FilteredKeyListMultimap)unfiltered;
            return new FilteredKeyListMultimap(prev.unfiltered(), Predicates.and(filteredKeyListMultimap.keyPredicate, keyPredicate));
        }
        return new FilteredKeyListMultimap(filteredKeyListMultimap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Multimap<K, V> filterValues(Multimap<K, V> unfiltered, Predicate<? super V> valuePredicate) {
        void var1_1;
        return Multimaps.filterEntries(unfiltered, Maps.valuePredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SetMultimap<K, V> filterValues(SetMultimap<K, V> unfiltered, Predicate<? super V> valuePredicate) {
        void var1_1;
        return Multimaps.filterEntries(unfiltered, Maps.valuePredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Multimap<K, V> filterEntries(Multimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        Multimap<K, V> multimap;
        Preconditions.checkNotNull(entryPredicate);
        if (unfiltered instanceof SetMultimap) {
            return Multimaps.filterEntries((SetMultimap)unfiltered, entryPredicate);
        }
        if (unfiltered instanceof FilteredMultimap) {
            return Multimaps.filterFiltered((FilteredMultimap)unfiltered, entryPredicate);
        }
        return new FilteredEntryMultimap<K, V>(Preconditions.checkNotNull(multimap), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SetMultimap<K, V> filterEntries(SetMultimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        SetMultimap<K, V> setMultimap;
        Preconditions.checkNotNull(entryPredicate);
        if (unfiltered instanceof FilteredSetMultimap) {
            return Multimaps.filterFiltered((FilteredSetMultimap)unfiltered, entryPredicate);
        }
        return new FilteredEntrySetMultimap<K, V>(Preconditions.checkNotNull(setMultimap), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> Multimap<K, V> filterFiltered(FilteredMultimap<K, V> multimap, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        FilteredMultimap<K, V> filteredMultimap;
        Predicate<? super Map.Entry<K, V>> predicate = Predicates.and(multimap.entryPredicate(), entryPredicate);
        return new FilteredEntryMultimap<K, V>(filteredMultimap.unfiltered(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> SetMultimap<K, V> filterFiltered(FilteredSetMultimap<K, V> multimap, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        FilteredSetMultimap<K, V> filteredSetMultimap;
        Predicate<? super Map.Entry<K, V>> predicate = Predicates.and(multimap.entryPredicate(), entryPredicate);
        return new FilteredEntrySetMultimap(filteredSetMultimap.unfiltered(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Multimap<?, ?> multimap, Object object) {
        if (object == multimap) {
            return true;
        }
        if (object instanceof Multimap) {
            void var1_1;
            Multimap<?, ?> multimap2;
            Multimap that = (Multimap)object;
            return multimap2.asMap().equals(var1_1.asMap());
        }
        return false;
    }

    static final class AsMap<K, V>
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        private final Multimap<K, V> multimap;

        /*
         * WARNING - void declaration
         */
        AsMap(Multimap<K, V> multimap) {
            void var1_1;
            this.multimap = (Multimap)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final int size() {
            return this.multimap.keySet().size();
        }

        @Override
        protected final Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new EntrySet(this);
        }

        /*
         * WARNING - void declaration
         */
        final void removeValuesForKey(Object key) {
            void var1_1;
            this.multimap.keySet().remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Collection<V> get(Object key) {
            if (this.containsKey(key)) {
                void var1_1;
                return this.multimap.get(var1_1);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Collection<V> remove(Object key) {
            if (this.containsKey(key)) {
                void var1_1;
                return this.multimap.removeAll(var1_1);
            }
            return null;
        }

        @Override
        public final Set<K> keySet() {
            return this.multimap.keySet();
        }

        @Override
        public final boolean isEmpty() {
            return this.multimap.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.multimap.containsKey(var1_1);
        }

        @Override
        public final void clear() {
            this.multimap.clear();
        }

        class EntrySet
        extends Maps.EntrySet<K, Collection<V>> {
            final /* synthetic */ AsMap this$0;

            /*
             * WARNING - void declaration
             */
            EntrySet(AsMap this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            Map<K, Collection<V>> map() {
                return this.this$0;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return Maps.asMapEntryIterator(this.this$0.multimap.keySet(), new Function<K, Collection<V>>(this){
                    final /* synthetic */ EntrySet this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Collection<V> apply(@ParametricNullness K key) {
                        void var1_1;
                        return this.this$1.this$0.multimap.get(var1_1);
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object o) {
                void var1_1;
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = Objects.requireNonNull((Map.Entry)o);
                this.this$0.removeValuesForKey(var1_1.getKey());
                return true;
            }
        }
    }

    static abstract class Entries<K, V>
    extends AbstractCollection<Map.Entry<K, V>> {
        Entries() {
        }

        abstract Multimap<K, V> multimap();

        @Override
        public int size() {
            return this.multimap().size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                return this.multimap().containsEntry(entry.getKey(), var1_1.getValue());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                return this.multimap().remove(entry.getKey(), var1_1.getValue());
            }
            return false;
        }

        @Override
        public void clear() {
            this.multimap().clear();
        }
    }

    static class Keys<K, V>
    extends AbstractMultiset<K> {
        final Multimap<K, V> multimap;

        /*
         * WARNING - void declaration
         */
        Keys(Multimap<K, V> multimap) {
            void var1_1;
            this.multimap = var1_1;
        }

        @Override
        Iterator<Multiset.Entry<K>> entryIterator() {
            Keys keys = this;
            return new TransformedIterator<Map.Entry<K, Collection<V>>, Multiset.Entry<K>>(keys, keys.multimap.asMap().entrySet().iterator()){
                {
                    void var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                Multiset.Entry<K> transform(Map.Entry<K, Collection<V>> backingEntry) {
                    void var1_1;
                    return new Multisets.AbstractEntry<K>(this, (Map.Entry)var1_1){
                        final /* synthetic */ Map.Entry val$backingEntry;
                        {
                            this.val$backingEntry = entry;
                        }

                        @Override
                        @ParametricNullness
                        public K getElement() {
                            return this.val$backingEntry.getKey();
                        }

                        @Override
                        public int getCount() {
                            return ((Collection)this.val$backingEntry.getValue()).size();
                        }
                    };
                }
            };
        }

        @Override
        public Spliterator<K> spliterator() {
            return CollectSpliterators.map(this.multimap.entries().spliterator(), Map.Entry::getKey);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(Consumer<? super K> consumer) {
            void var1_1;
            Preconditions.checkNotNull(consumer);
            this.multimap.entries().forEach(arg_0 -> Keys.lambda$forEach$0((Consumer)var1_1, arg_0));
        }

        @Override
        int distinctElements() {
            return this.multimap.asMap().size();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object element) {
            void var1_1;
            return this.multimap.containsKey(var1_1);
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(this.multimap.entries().iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int count(Object element) {
            void var1_1;
            Collection<V> values = Maps.safeGet(this.multimap.asMap(), element);
            if (values == null) {
                return 0;
            }
            return var1_1.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int remove(Object element, int occurrences) {
            void var3_3;
            CollectPreconditions.checkNonnegative(occurrences, "occurrences");
            if (occurrences == 0) {
                return this.count(element);
            }
            Collection<V> values = Maps.safeGet(this.multimap.asMap(), element);
            if (values == null) {
                return 0;
            }
            int oldCount = values.size();
            if (occurrences >= oldCount) {
                values.clear();
            } else {
                Iterator<V> iterator = values.iterator();
                for (int i = 0; i < occurrences; ++i) {
                    iterator.next();
                    iterator.remove();
                }
            }
            return (int)var3_3;
        }

        @Override
        public void clear() {
            this.multimap.clear();
        }

        @Override
        public Set<K> elementSet() {
            return this.multimap.keySet();
        }

        @Override
        Iterator<K> elementIterator() {
            throw new AssertionError((Object)"should never be called");
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEach$0(Consumer consumer, Map.Entry entry) {
            void var1_1;
            consumer.accept(var1_1.getKey());
        }
    }

    private static final class TransformedEntriesListMultimap<K, V1, V2>
    extends TransformedEntriesMultimap<K, V1, V2>
    implements ListMultimap<K, V2> {
        /*
         * WARNING - void declaration
         */
        TransformedEntriesListMultimap(ListMultimap<K, V1> fromMultimap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final List<V2> transform(@ParametricNullness K key, Collection<V1> values) {
            void var1_1;
            return Lists.transform((List)values, Maps.asValueToValueFunction(this.transformer, var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<V2> get(@ParametricNullness K key) {
            void var1_1;
            return this.transform((Object)key, this.fromMultimap.get(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<V2> removeAll(Object key) {
            void var1_1;
            return this.transform(key, this.fromMultimap.removeAll(var1_1));
        }

        @Override
        public final List<V2> replaceValues(@ParametricNullness K key, Iterable<? extends V2> values) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TransformedEntriesMultimap<K, V1, V2>
    extends AbstractMultimap<K, V2> {
        final Multimap<K, V1> fromMultimap;
        final Maps.EntryTransformer<? super K, ? super V1, V2> transformer;

        /*
         * WARNING - void declaration
         */
        TransformedEntriesMultimap(Multimap<K, V1> fromMultimap, Maps.EntryTransformer<? super K, ? super V1, V2> transformer) {
            void var2_2;
            void var1_1;
            this.fromMultimap = (Multimap)Preconditions.checkNotNull(var1_1);
            this.transformer = (Maps.EntryTransformer)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        Collection<V2> transform(@ParametricNullness K key, Collection<V1> values) {
            void var1_1;
            void var2_2;
            Function<? super V1, V2> function = Maps.asValueToValueFunction(this.transformer, key);
            if (values instanceof List) {
                return Lists.transform((List)values, function);
            }
            return Collections2.transform(var2_2, var1_1);
        }

        @Override
        Map<K, Collection<V2>> createAsMap() {
            return Maps.transformEntries(this.fromMultimap.asMap(), new Maps.EntryTransformer<K, Collection<V1>, Collection<V2>>(this){
                final /* synthetic */ TransformedEntriesMultimap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Collection<V2> transformEntry(@ParametricNullness K key, Collection<V1> value) {
                    void var2_2;
                    void var1_1;
                    return this.this$0.transform(var1_1, var2_2);
                }
            });
        }

        @Override
        public void clear() {
            this.fromMultimap.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.fromMultimap.containsKey(var1_1);
        }

        @Override
        Collection<Map.Entry<K, V2>> createEntries() {
            return new AbstractMultimap.Entries(this);
        }

        @Override
        Iterator<Map.Entry<K, V2>> entryIterator() {
            return Iterators.transform(this.fromMultimap.entries().iterator(), Maps.asEntryToEntryFunction(this.transformer));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V2> get(@ParametricNullness K key) {
            void var1_1;
            return this.transform(key, this.fromMultimap.get(var1_1));
        }

        @Override
        public boolean isEmpty() {
            return this.fromMultimap.isEmpty();
        }

        @Override
        Set<K> createKeySet() {
            return this.fromMultimap.keySet();
        }

        @Override
        Multiset<K> createKeys() {
            return this.fromMultimap.keys();
        }

        @Override
        public boolean put(@ParametricNullness K key, @ParametricNullness V2 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(@ParametricNullness K key, Iterable<? extends V2> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(Multimap<? extends K, ? extends V2> multimap) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object key, Object value) {
            void var2_2;
            void var1_1;
            return this.get(var1_1).remove(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V2> removeAll(Object key) {
            void var1_1;
            return this.transform(key, this.fromMultimap.removeAll(var1_1));
        }

        @Override
        public Collection<V2> replaceValues(@ParametricNullness K key, Iterable<? extends V2> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.fromMultimap.size();
        }

        @Override
        Collection<V2> createValues() {
            return Collections2.transform(this.fromMultimap.entries(), Maps.asEntryToValueFunction(this.transformer));
        }
    }

    private static class MapMultimap<K, V>
    extends AbstractMultimap<K, V>
    implements SetMultimap<K, V>,
    Serializable {
        final Map<K, V> map;
        private static final long serialVersionUID = 7845222491160860175L;

        /*
         * WARNING - void declaration
         */
        MapMultimap(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.map.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsValue(Object value) {
            void var1_1;
            return this.map.containsValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsEntry(Object key, Object value) {
            void var2_2;
            void var1_1;
            return this.map.entrySet().contains(Maps.immutableEntry(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<V> get(@ParametricNullness K key) {
            void var1_1;
            return new Sets.ImprovedAbstractSet<V>(this, var1_1){
                final /* synthetic */ Object val$key;
                final /* synthetic */ MapMultimap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$key = object;
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(this){
                        int i;
                        final /* synthetic */ 1 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i == 0 && this.this$1.this$0.map.containsKey(this.this$1.val$key);
                        }

                        @Override
                        @ParametricNullness
                        public V next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            ++this.i;
                            return NullnessCasts.uncheckedCastNullableTToT(this.this$1.this$0.map.get(this.this$1.val$key));
                        }

                        @Override
                        public void remove() {
                            CollectPreconditions.checkRemove(this.i == 1);
                            this.i = -1;
                            this.this$1.this$0.map.remove(this.this$1.val$key);
                        }
                    };
                }

                @Override
                public int size() {
                    if (this.this$0.map.containsKey(this.val$key)) {
                        return 1;
                    }
                    return 0;
                }
            };
        }

        @Override
        public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(@ParametricNullness K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object key, Object value) {
            void var2_2;
            void var1_1;
            return this.map.entrySet().remove(Maps.immutableEntry(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<V> removeAll(Object key) {
            void var2_2;
            void var1_1;
            HashSet<V> values = new HashSet<V>(2);
            if (!this.map.containsKey(key)) {
                return values;
            }
            values.add(this.map.remove(var1_1));
            return var2_2;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        Set<K> createKeySet() {
            return this.map.keySet();
        }

        @Override
        Collection<V> createValues() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entries() {
            return this.map.entrySet();
        }

        @Override
        Collection<Map.Entry<K, V>> createEntries() {
            throw new AssertionError((Object)"unreachable");
        }

        @Override
        Multiset<K> createKeys() {
            return new Keys(this);
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return this.map.entrySet().iterator();
        }

        @Override
        Map<K, Collection<V>> createAsMap() {
            return new AsMap(this);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }
    }

    private static class UnmodifiableSortedSetMultimap<K, V>
    extends UnmodifiableSetMultimap<K, V>
    implements SortedSetMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableSortedSetMultimap(SortedSetMultimap<K, V> delegate) {
            super(var1_1);
            void var1_1;
        }

        @Override
        public SortedSetMultimap<K, V> delegate() {
            return (SortedSetMultimap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<V> get(@ParametricNullness K key) {
            void var1_1;
            return Collections.unmodifiableSortedSet(this.delegate().get((Object)var1_1));
        }

        @Override
        public SortedSet<V> removeAll(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparator<? super V> valueComparator() {
            return this.delegate().valueComparator();
        }
    }

    private static class UnmodifiableSetMultimap<K, V>
    extends UnmodifiableMultimap<K, V>
    implements SetMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableSetMultimap(SetMultimap<K, V> delegate) {
            super(var1_1);
            void var1_1;
        }

        @Override
        public SetMultimap<K, V> delegate() {
            return (SetMultimap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<V> get(@ParametricNullness K key) {
            void var1_1;
            return Collections.unmodifiableSet(this.delegate().get((Object)var1_1));
        }

        @Override
        public Set<Map.Entry<K, V>> entries() {
            return Maps.unmodifiableEntrySet(this.delegate().entries());
        }

        @Override
        public Set<V> removeAll(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableListMultimap<K, V>
    extends UnmodifiableMultimap<K, V>
    implements ListMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableListMultimap(ListMultimap<K, V> delegate) {
            super(var1_1);
            void var1_1;
        }

        @Override
        public ListMultimap<K, V> delegate() {
            return (ListMultimap)super.delegate();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<V> get(@ParametricNullness K key) {
            void var1_1;
            return Collections.unmodifiableList(this.delegate().get((Object)var1_1));
        }

        @Override
        public List<V> removeAll(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableMultimap<K, V>
    extends ForwardingMultimap<K, V>
    implements Serializable {
        final Multimap<K, V> delegate;
        transient Collection<Map.Entry<K, V>> entries;
        transient Multiset<K> keys;
        transient Set<K> keySet;
        transient Collection<V> values;
        transient Map<K, Collection<V>> map;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableMultimap(Multimap<K, V> delegate) {
            void var1_1;
            this.delegate = (Multimap)Preconditions.checkNotNull(var1_1);
        }

        @Override
        protected Multimap<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<K, Collection<V>> asMap() {
            void var1_1;
            Map<K, Collection<Object>> result = this.map;
            if (result == null) {
                result = this.map = Collections.unmodifiableMap(Maps.transformValues(this.delegate.asMap(), new Function<Collection<V>, Collection<V>>(this){

                    @Override
                    public Collection<V> apply(Collection<V> collection) {
                        return Multimaps.unmodifiableValueCollection(collection);
                    }
                }));
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<Map.Entry<K, V>> entries() {
            void var1_1;
            Collection result = this.entries;
            if (result == null) {
                this.entries = result = Multimaps.unmodifiableEntries(this.delegate.entries());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> consumer) {
            void var1_1;
            this.delegate.forEach((BiConsumer)Preconditions.checkNotNull(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> get(@ParametricNullness K key) {
            void var1_1;
            return Multimaps.unmodifiableValueCollection(this.delegate.get(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Multiset<K> keys() {
            void var1_1;
            Multiset<K> result = this.keys;
            if (result == null) {
                this.keys = result = Multisets.unmodifiableMultiset(this.delegate.keys());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<K> keySet() {
            void var1_1;
            Set<K> result = this.keySet;
            if (result == null) {
                this.keySet = result = Collections.unmodifiableSet(this.delegate.keySet());
            }
            return var1_1;
        }

        @Override
        public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(@ParametricNullness K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<V> removeAll(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> values() {
            void var1_1;
            Collection<V> result = this.values;
            if (result == null) {
                this.values = result = Collections.unmodifiableCollection(this.delegate.values());
            }
            return var1_1;
        }
    }

    private static class CustomSortedSetMultimap<K, V>
    extends AbstractSortedSetMultimap<K, V> {
        transient com.google.common.base.Supplier<? extends SortedSet<V>> factory;
        transient Comparator<? super V> valueComparator;
        @GwtIncompatible
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        CustomSortedSetMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends SortedSet<V>> factory) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.factory = Preconditions.checkNotNull(factory);
            this.valueComparator = ((SortedSet)var2_2.get()).comparator();
        }

        @Override
        Set<K> createKeySet() {
            return this.createMaybeNavigableKeySet();
        }

        @Override
        Map<K, Collection<V>> createAsMap() {
            return this.createMaybeNavigableAsMap();
        }

        @Override
        protected SortedSet<V> createCollection() {
            return this.factory.get();
        }

        @Override
        public Comparator<? super V> valueComparator() {
            return this.valueComparator;
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            void var1_1;
            stream.defaultWriteObject();
            stream.writeObject(this.factory);
            var1_1.writeObject(this.backingMap());
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            void var1_1;
            stream.defaultReadObject();
            this.factory = (com.google.common.base.Supplier)stream.readObject();
            this.valueComparator = this.factory.get().comparator();
            Map map = (Map)stream.readObject();
            this.setMap(var1_1);
        }
    }

    private static class CustomSetMultimap<K, V>
    extends AbstractSetMultimap<K, V> {
        transient com.google.common.base.Supplier<? extends Set<V>> factory;
        @GwtIncompatible
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        CustomSetMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends Set<V>> factory) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.factory = (com.google.common.base.Supplier)Preconditions.checkNotNull(var2_2);
        }

        @Override
        Set<K> createKeySet() {
            return this.createMaybeNavigableKeySet();
        }

        @Override
        Map<K, Collection<V>> createAsMap() {
            return this.createMaybeNavigableAsMap();
        }

        @Override
        protected Set<V> createCollection() {
            return this.factory.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
            void var1_1;
            if (collection instanceof NavigableSet) {
                return Sets.unmodifiableNavigableSet((NavigableSet)collection);
            }
            if (collection instanceof SortedSet) {
                return Collections.unmodifiableSortedSet((SortedSet)collection);
            }
            return Collections.unmodifiableSet((Set)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Collection<V> wrapCollection(@ParametricNullness K key, Collection<V> collection) {
            void var2_2;
            void var1_1;
            if (collection instanceof NavigableSet) {
                return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedNavigableSet(key, (NavigableSet)collection, null);
            }
            if (collection instanceof SortedSet) {
                return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedSortedSet(key, (SortedSet)collection, null);
            }
            return new AbstractMapBasedMultimap.WrappedSet(var1_1, (Set)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            void var1_1;
            stream.defaultWriteObject();
            stream.writeObject(this.factory);
            var1_1.writeObject(this.backingMap());
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            void var1_1;
            stream.defaultReadObject();
            this.factory = (com.google.common.base.Supplier)stream.readObject();
            Map map = (Map)stream.readObject();
            this.setMap(var1_1);
        }
    }

    private static class CustomListMultimap<K, V>
    extends AbstractListMultimap<K, V> {
        transient com.google.common.base.Supplier<? extends List<V>> factory;
        @GwtIncompatible
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        CustomListMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends List<V>> factory) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.factory = (com.google.common.base.Supplier)Preconditions.checkNotNull(var2_2);
        }

        @Override
        Set<K> createKeySet() {
            return this.createMaybeNavigableKeySet();
        }

        @Override
        Map<K, Collection<V>> createAsMap() {
            return this.createMaybeNavigableAsMap();
        }

        @Override
        protected List<V> createCollection() {
            return this.factory.get();
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            void var1_1;
            stream.defaultWriteObject();
            stream.writeObject(this.factory);
            var1_1.writeObject(this.backingMap());
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            void var1_1;
            stream.defaultReadObject();
            this.factory = (com.google.common.base.Supplier)stream.readObject();
            Map map = (Map)stream.readObject();
            this.setMap(var1_1);
        }
    }

    private static class CustomMultimap<K, V>
    extends AbstractMapBasedMultimap<K, V> {
        transient com.google.common.base.Supplier<? extends Collection<V>> factory;
        @GwtIncompatible
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        CustomMultimap(Map<K, Collection<V>> map, com.google.common.base.Supplier<? extends Collection<V>> factory) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.factory = (com.google.common.base.Supplier)Preconditions.checkNotNull(var2_2);
        }

        @Override
        Set<K> createKeySet() {
            return this.createMaybeNavigableKeySet();
        }

        @Override
        Map<K, Collection<V>> createAsMap() {
            return this.createMaybeNavigableAsMap();
        }

        @Override
        protected Collection<V> createCollection() {
            return this.factory.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
            void var1_1;
            if (collection instanceof NavigableSet) {
                return Sets.unmodifiableNavigableSet((NavigableSet)collection);
            }
            if (collection instanceof SortedSet) {
                return Collections.unmodifiableSortedSet((SortedSet)collection);
            }
            if (collection instanceof Set) {
                return Collections.unmodifiableSet((Set)collection);
            }
            if (collection instanceof List) {
                return Collections.unmodifiableList((List)collection);
            }
            return Collections.unmodifiableCollection(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Collection<V> wrapCollection(@ParametricNullness K key, Collection<V> collection) {
            void var2_2;
            void var1_1;
            if (collection instanceof List) {
                return this.wrapList(key, (List)collection, null);
            }
            if (collection instanceof NavigableSet) {
                return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedNavigableSet(key, (NavigableSet)collection, null);
            }
            if (collection instanceof SortedSet) {
                return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedSortedSet(key, (SortedSet)collection, null);
            }
            if (collection instanceof Set) {
                return new AbstractMapBasedMultimap.WrappedSet(key, (Set)collection);
            }
            return new AbstractMapBasedMultimap.WrappedCollection(this, var1_1, var2_2, null);
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void writeObject(ObjectOutputStream stream) throws IOException {
            void var1_1;
            stream.defaultWriteObject();
            stream.writeObject(this.factory);
            var1_1.writeObject(this.backingMap());
        }

        /*
         * WARNING - void declaration
         */
        @GwtIncompatible
        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            void var1_1;
            stream.defaultReadObject();
            this.factory = (com.google.common.base.Supplier)stream.readObject();
            Map map = (Map)stream.readObject();
            this.setMap(var1_1);
        }
    }
}

