/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class MultimapBuilder<K0, V0> {
    private static final int DEFAULT_EXPECTED_KEYS = 8;

    private MultimapBuilder() {
    }

    public static MultimapBuilderWithKeys<Object> hashKeys() {
        return MultimapBuilder.hashKeys(8);
    }

    public static MultimapBuilderWithKeys<Object> hashKeys(int expectedKeys) {
        int n;
        CollectPreconditions.checkNonnegative(expectedKeys, "expectedKeys");
        return new MultimapBuilderWithKeys<Object>(){

            @Override
            <K, V> Map<K, Collection<V>> createMap() {
                return Platform.newHashMapWithExpectedSize(n);
            }
        };
    }

    public static MultimapBuilderWithKeys<Object> linkedHashKeys() {
        return MultimapBuilder.linkedHashKeys(8);
    }

    public static MultimapBuilderWithKeys<Object> linkedHashKeys(int expectedKeys) {
        int n;
        CollectPreconditions.checkNonnegative(expectedKeys, "expectedKeys");
        return new MultimapBuilderWithKeys<Object>(){

            @Override
            <K, V> Map<K, Collection<V>> createMap() {
                return Platform.newLinkedHashMapWithExpectedSize(n);
            }
        };
    }

    public static MultimapBuilderWithKeys<Comparable> treeKeys() {
        return MultimapBuilder.treeKeys(Ordering.natural());
    }

    public static <K0> MultimapBuilderWithKeys<K0> treeKeys(Comparator<K0> comparator) {
        Comparator<K0> comparator2;
        Preconditions.checkNotNull(comparator);
        return new MultimapBuilderWithKeys<K0>(){

            @Override
            <K extends K0, V> Map<K, Collection<V>> createMap() {
                return new TreeMap(comparator2);
            }
        };
    }

    public static <K0 extends Enum<K0>> MultimapBuilderWithKeys<K0> enumKeys(Class<K0> keyClass) {
        Class<K0> clazz;
        Preconditions.checkNotNull(keyClass);
        return new MultimapBuilderWithKeys<K0>(){

            @Override
            <K extends K0, V> Map<K, Collection<V>> createMap() {
                return new EnumMap(clazz);
            }
        };
    }

    public abstract <K extends K0, V extends V0> Multimap<K, V> build();

    /*
     * WARNING - void declaration
     */
    public <K extends K0, V extends V0> Multimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
        void var2_2;
        void var1_1;
        Multimap<K, V> result = this.build();
        result.putAll((Multimap<K, V>)var1_1);
        return var2_2;
    }

    public static abstract class SortedSetMultimapBuilder<K0, V0>
    extends SetMultimapBuilder<K0, V0> {
        SortedSetMultimapBuilder() {
        }

        @Override
        public abstract <K extends K0, V extends V0> SortedSetMultimap<K, V> build();

        /*
         * WARNING - void declaration
         */
        @Override
        public <K extends K0, V extends V0> SortedSetMultimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
            void var1_1;
            return (SortedSetMultimap)super.build((Multimap)var1_1);
        }
    }

    public static abstract class SetMultimapBuilder<K0, V0>
    extends MultimapBuilder<K0, V0> {
        SetMultimapBuilder() {
        }

        @Override
        public abstract <K extends K0, V extends V0> SetMultimap<K, V> build();

        /*
         * WARNING - void declaration
         */
        @Override
        public <K extends K0, V extends V0> SetMultimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
            void var1_1;
            return (SetMultimap)super.build(var1_1);
        }
    }

    public static abstract class ListMultimapBuilder<K0, V0>
    extends MultimapBuilder<K0, V0> {
        ListMultimapBuilder() {
        }

        @Override
        public abstract <K extends K0, V extends V0> ListMultimap<K, V> build();

        /*
         * WARNING - void declaration
         */
        @Override
        public <K extends K0, V extends V0> ListMultimap<K, V> build(Multimap<? extends K, ? extends V> multimap) {
            void var1_1;
            return (ListMultimap)super.build(var1_1);
        }
    }

    public static abstract class MultimapBuilderWithKeys<K0> {
        private static final int DEFAULT_EXPECTED_VALUES_PER_KEY = 2;

        MultimapBuilderWithKeys() {
        }

        abstract <K extends K0, V> Map<K, Collection<V>> createMap();

        public ListMultimapBuilder<K0, Object> arrayListValues() {
            return this.arrayListValues(2);
        }

        /*
         * WARNING - void declaration
         */
        public ListMultimapBuilder<K0, Object> arrayListValues(int expectedValuesPerKey) {
            void var1_1;
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
            return new ListMultimapBuilder<K0, Object>(this, (int)var1_1){
                final /* synthetic */ int val$expectedValuesPerKey;
                final /* synthetic */ MultimapBuilderWithKeys this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$expectedValuesPerKey = n;
                }

                @Override
                public <K extends K0, V> ListMultimap<K, V> build() {
                    return Multimaps.newListMultimap(this.this$0.createMap(), new ArrayListSupplier(this.val$expectedValuesPerKey));
                }
            };
        }

        public ListMultimapBuilder<K0, Object> linkedListValues() {
            return new ListMultimapBuilder<K0, Object>(this){
                final /* synthetic */ MultimapBuilderWithKeys this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public <K extends K0, V> ListMultimap<K, V> build() {
                    return Multimaps.newListMultimap(this.this$0.createMap(), LinkedListSupplier.instance());
                }
            };
        }

        public SetMultimapBuilder<K0, Object> hashSetValues() {
            return this.hashSetValues(2);
        }

        /*
         * WARNING - void declaration
         */
        public SetMultimapBuilder<K0, Object> hashSetValues(int expectedValuesPerKey) {
            void var1_1;
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
            return new SetMultimapBuilder<K0, Object>(this, (int)var1_1){
                final /* synthetic */ int val$expectedValuesPerKey;
                final /* synthetic */ MultimapBuilderWithKeys this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$expectedValuesPerKey = n;
                }

                @Override
                public <K extends K0, V> SetMultimap<K, V> build() {
                    return Multimaps.newSetMultimap(this.this$0.createMap(), new HashSetSupplier(this.val$expectedValuesPerKey));
                }
            };
        }

        public SetMultimapBuilder<K0, Object> linkedHashSetValues() {
            return this.linkedHashSetValues(2);
        }

        /*
         * WARNING - void declaration
         */
        public SetMultimapBuilder<K0, Object> linkedHashSetValues(int expectedValuesPerKey) {
            void var1_1;
            CollectPreconditions.checkNonnegative(expectedValuesPerKey, "expectedValuesPerKey");
            return new SetMultimapBuilder<K0, Object>(this, (int)var1_1){
                final /* synthetic */ int val$expectedValuesPerKey;
                final /* synthetic */ MultimapBuilderWithKeys this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$expectedValuesPerKey = n;
                }

                @Override
                public <K extends K0, V> SetMultimap<K, V> build() {
                    return Multimaps.newSetMultimap(this.this$0.createMap(), new LinkedHashSetSupplier(this.val$expectedValuesPerKey));
                }
            };
        }

        public SortedSetMultimapBuilder<K0, Comparable> treeSetValues() {
            return this.treeSetValues(Ordering.natural());
        }

        /*
         * WARNING - void declaration
         */
        public <V0> SortedSetMultimapBuilder<K0, V0> treeSetValues(Comparator<V0> comparator) {
            void var1_1;
            Preconditions.checkNotNull(comparator, "comparator");
            return new SortedSetMultimapBuilder<K0, V0>(this, (Comparator)var1_1){
                final /* synthetic */ Comparator val$comparator;
                final /* synthetic */ MultimapBuilderWithKeys this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$comparator = comparator;
                }

                @Override
                public <K extends K0, V extends V0> SortedSetMultimap<K, V> build() {
                    return Multimaps.newSortedSetMultimap(this.this$0.createMap(), new TreeSetSupplier(this.val$comparator));
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        public <V0 extends Enum<V0>> SetMultimapBuilder<K0, V0> enumSetValues(Class<V0> valueClass) {
            void var1_1;
            Preconditions.checkNotNull(valueClass, "valueClass");
            return new SetMultimapBuilder<K0, V0>(this, (Class)var1_1){
                final /* synthetic */ Class val$valueClass;
                final /* synthetic */ MultimapBuilderWithKeys this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$valueClass = clazz;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public <K extends K0, V extends V0> SetMultimap<K, V> build() {
                    void var1_1;
                    EnumSetSupplier factory = new EnumSetSupplier(this.val$valueClass);
                    return Multimaps.newSetMultimap(this.this$0.createMap(), var1_1);
                }
            };
        }
    }

    private static final class EnumSetSupplier<V extends Enum<V>>
    implements Supplier<Set<V>>,
    Serializable {
        private final Class<V> clazz;

        /*
         * WARNING - void declaration
         */
        EnumSetSupplier(Class<V> clazz) {
            void var1_1;
            this.clazz = (Class)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final Set<V> get() {
            return EnumSet.noneOf(this.clazz);
        }
    }

    private static final class TreeSetSupplier<V>
    implements Supplier<SortedSet<V>>,
    Serializable {
        private final Comparator<? super V> comparator;

        /*
         * WARNING - void declaration
         */
        TreeSetSupplier(Comparator<? super V> comparator) {
            void var1_1;
            this.comparator = (Comparator)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final SortedSet<V> get() {
            return new TreeSet<V>(this.comparator);
        }
    }

    private static final class LinkedHashSetSupplier<V>
    implements Supplier<Set<V>>,
    Serializable {
        private final int expectedValuesPerKey;

        /*
         * WARNING - void declaration
         */
        LinkedHashSetSupplier(int expectedValuesPerKey) {
            void var1_1;
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative((int)var1_1, "expectedValuesPerKey");
        }

        @Override
        public final Set<V> get() {
            return Platform.newLinkedHashSetWithExpectedSize(this.expectedValuesPerKey);
        }
    }

    private static final class HashSetSupplier<V>
    implements Supplier<Set<V>>,
    Serializable {
        private final int expectedValuesPerKey;

        /*
         * WARNING - void declaration
         */
        HashSetSupplier(int expectedValuesPerKey) {
            void var1_1;
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative((int)var1_1, "expectedValuesPerKey");
        }

        @Override
        public final Set<V> get() {
            return Platform.newHashSetWithExpectedSize(this.expectedValuesPerKey);
        }
    }

    private static enum LinkedListSupplier implements Supplier<List<?>>
    {
        INSTANCE;


        public static <V> Supplier<List<V>> instance() {
            LinkedListSupplier linkedListSupplier = INSTANCE;
            return linkedListSupplier;
        }

        @Override
        public final List<?> get() {
            return new LinkedList();
        }
    }

    private static final class ArrayListSupplier<V>
    implements Supplier<List<V>>,
    Serializable {
        private final int expectedValuesPerKey;

        /*
         * WARNING - void declaration
         */
        ArrayListSupplier(int expectedValuesPerKey) {
            void var1_1;
            this.expectedValuesPerKey = CollectPreconditions.checkNonnegative((int)var1_1, "expectedValuesPerKey");
        }

        @Override
        public final List<V> get() {
            return new ArrayList(this.expectedValuesPerKey);
        }
    }
}

