/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Multiset;
import com.google.common.collect.ParametricNullness;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public interface Multimap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public boolean containsEntry(Object var1, Object var2);

    public boolean put(@ParametricNullness K var1, @ParametricNullness V var2);

    public boolean remove(Object var1, Object var2);

    public boolean putAll(@ParametricNullness K var1, Iterable<? extends V> var2);

    public boolean putAll(Multimap<? extends K, ? extends V> var1);

    public Collection<V> replaceValues(@ParametricNullness K var1, Iterable<? extends V> var2);

    public Collection<V> removeAll(Object var1);

    public void clear();

    public Collection<V> get(@ParametricNullness K var1);

    public Set<K> keySet();

    public Multiset<K> keys();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    /*
     * WARNING - void declaration
     */
    default public void forEach(BiConsumer<? super K, ? super V> action) {
        void var1_1;
        Preconditions.checkNotNull(action);
        this.entries().forEach(arg_0 -> Multimap.lambda$forEach$0((BiConsumer)var1_1, arg_0));
    }

    public Map<K, Collection<V>> asMap();

    public boolean equals(Object var1);

    public int hashCode();

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEach$0(BiConsumer action, Map.Entry entry) {
        void var1_1;
        action.accept(entry.getKey(), var1_1.getValue());
    }
}

